/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import lotr.client.LOTRClientUtil;
import lotr.common.time.LOTRDate;
import lotr.common.util.LOTRUtil;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class DateDisplay {
    private int dateDisplayTime = 0;
    private static final int DATE_DISPLAY_DURATION = 200;

    public void displayNewDate() {
        this.dateDisplayTime = 200;
    }

    public void update() {
        if (this.dateDisplayTime > 0) {
            --this.dateDisplayTime;
        }
    }

    public void reset() {
        this.dateDisplayTime = 0;
    }

    public void render(Minecraft mc) {
        if (this.dateDisplayTime > 0) {
            String date = LOTRDate.ShireReckoning.getShireDate().getDisplayName(true).func_150254_d();
            float alpha = this.calculateDisplayAlpha();
            MainWindow window = mc.func_228018_at_();
            int width = window.func_198107_o();
            int height = window.func_198087_p();
            float scale = 1.5f;
            float invScale = 1.0f / scale;
            width = (int)((float)width * invScale);
            height = (int)((float)height * invScale);
            FontRenderer font = mc.field_71466_p;
            int dateX = (width - font.func_78256_a(date)) / 2;
            font.getClass();
            int dateY = (height - 9) * 2 / 5;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            font.func_211126_b(date, (float)dateX, (float)dateY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    private float calculateDisplayAlpha() {
        return LOTRUtil.normalisedTriangleWave(200 - this.dateDisplayTime, 200.0f, 0.0f, 1.0f);
    }
}

