/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import lotr.client.LOTRKeyHandler;
import lotr.client.event.AdvancedDrunkEffect;
import lotr.client.event.AshfallFog;
import lotr.client.event.DateDisplay;
import lotr.client.event.MistyMountainsMist;
import lotr.client.event.RainMist;
import lotr.client.event.SandstormFog;
import lotr.client.event.SunGlare;
import lotr.client.event.WorldTypeHelpDisplay;
import lotr.client.gui.AlignmentRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.render.MiddleEarthCloudRenderer;
import lotr.client.render.MiddleEarthWorldRenderer;
import lotr.client.render.NorthernLightsRenderer;
import lotr.client.render.OnScreenCompassRenderer;
import lotr.client.sound.LOTRAmbience;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.data.LOTRLevelData;
import lotr.common.dim.LOTRDimension;
import lotr.common.event.LOTRTickHandlerServer;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRParticles;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class LOTRTickHandlerClient
implements ISelectiveResourceReloadListener {
    private static final ResourceLocation PORTAL_OVERLAY = new ResourceLocation("lotr", "textures/overlay/portal.png");
    private static final ResourceLocation MIST_OVERLAY = new ResourceLocation("lotr", "textures/overlay/mist.png");
    private final Minecraft mc;
    private Screen lastScreenOpen;
    private boolean inRingPortal = false;
    private int ringPortalTick;
    private final AdvancedDrunkEffect drunkEffect = new AdvancedDrunkEffect();
    private final DateDisplay dateDisplay = new DateDisplay();
    private final LOTRAmbience ambienceTicker = new LOTRAmbience();
    private final SunGlare sunGlare = new SunGlare();
    private final RainMist rainMist = new RainMist();
    private final MistyMountainsMist mountainsMist = new MistyMountainsMist();
    private final SandstormFog sandstormFog = new SandstormFog();
    private final AshfallFog ashfallFog = new AshfallFog();
    private final WorldTypeHelpDisplay worldTypeHelpDisplay = new WorldTypeHelpDisplay();
    private boolean sentResourcePackCheck = false;
    public static float renderPartialTick;
    private final AlignmentRenderer alignmentRenderer = new AlignmentRenderer();
    private final OnScreenCompassRenderer compassRenderer = new OnScreenCompassRenderer();

    public LOTRTickHandlerClient() {
        this.mc = Minecraft.func_71410_x();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((IReloadableResourceManager)this.mc.func_195551_G()).func_219534_a((IFutureReloadListener)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        TickEvent.Phase phase = event.phase;
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity viewer = this.mc.field_175622_Z;
        if (phase == TickEvent.Phase.START) {
            this.replaceWorldRendererIfNotReplaced();
        }
        if (phase == TickEvent.Phase.END) {
            Screen screen;
            if (player != null) {
                ClientWorld world = (ClientWorld)player.field_70170_p;
                this.alignmentRenderer.updateHUD(this.mc, (PlayerEntity)player);
                LOTRKeyHandler.updateAlignmentChange();
                if (!this.mc.func_147113_T()) {
                    if (world.func_201675_m() instanceof LOTRDimension) {
                        LOTRTime.updateTime((World)world);
                        IRenderHandler clouds = world.func_201675_m().getCloudRenderer();
                        if (clouds instanceof MiddleEarthCloudRenderer) {
                            ((MiddleEarthCloudRenderer)clouds).updateClouds((World)world);
                        }
                    }
                    if (((Boolean)LOTRConfig.CLIENT.northernLights.get()).booleanValue()) {
                        NorthernLightsRenderer.update(viewer);
                    }
                    if (viewer instanceof LivingEntity) {
                        this.drunkEffect.update((LivingEntity)viewer);
                    }
                    this.dateDisplay.update();
                    this.ambienceTicker.updateAmbience(this.mc, (World)world, (PlayerEntity)player);
                    this.sunGlare.update(world, viewer);
                    this.rainMist.update((World)world, viewer);
                    this.mountainsMist.update((World)world, viewer);
                    this.sandstormFog.update((World)world, viewer);
                    this.ashfallFog.update((World)world, viewer);
                    world.func_217381_Z().func_76320_a("lotrEnvironmentFX");
                    BlockPos.Mutable movingParticlePos = new BlockPos.Mutable();
                    for (int l = 0; l < 667; ++l) {
                        this.spawnEnvironmentParticles(viewer, (World)world, 16, movingParticlePos);
                        this.spawnEnvironmentParticles(viewer, (World)world, 32, movingParticlePos);
                    }
                    world.func_217381_Z().func_76319_b();
                    if (this.inRingPortal) {
                        boolean stillInPortal = LOTRTickHandlerServer.checkInRingPortal((Entity)player);
                        if (stillInPortal) {
                            ++this.ringPortalTick;
                        } else {
                            this.inRingPortal = false;
                            this.ringPortalTick = 0;
                        }
                    }
                    this.checkResourcePack((World)world, (PlayerEntity)player);
                }
            }
            if ((screen = this.mc.field_71462_r) != null) {
                if (screen instanceof MainMenuScreen && !(this.lastScreenOpen instanceof MainMenuScreen)) {
                    LOTRLevelData.serverInstance().resetNeedsLoad();
                    LOTRLevelData.clientInstance().resetNeedsLoad();
                    LOTRTime.resetNeedsLoad();
                    LOTRDate.resetWorldTimeInMenu();
                    MiddleEarthMapScreen.clearPlayerLocations();
                    this.drunkEffect.reset();
                    this.dateDisplay.reset();
                    this.sunGlare.reset();
                    this.rainMist.reset();
                    this.mountainsMist.reset();
                    this.sandstormFog.reset();
                    this.ashfallFog.reset();
                    this.alignmentRenderer.resetInMenu();
                    this.sentResourcePackCheck = false;
                }
                this.lastScreenOpen = screen;
            }
        }
    }

    private void replaceWorldRendererIfNotReplaced() {
        WorldRenderer wr = this.mc.field_71438_f;
        if (!(wr instanceof MiddleEarthWorldRenderer)) {
            MiddleEarthWorldRenderer newWr = new MiddleEarthWorldRenderer(this.mc, this.mc.func_228019_au_());
            Field f_mcWr = null;
            for (Field f : Minecraft.class.getDeclaredFields()) {
                if (f.getType() != WorldRenderer.class) continue;
                f_mcWr = f;
                break;
            }
            if (f_mcWr == null) {
                LOTRLog.error("Could not locate WorldRenderer field in Minecraft game class");
            } else {
                LOTRUtil.unlockFinalField(f_mcWr);
                try {
                    f_mcWr.set(this.mc, (Object)newWr);
                    ((IReloadableResourceManager)this.mc.func_195551_G()).func_219534_a((IFutureReloadListener)newWr);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOTRLog.error("Failed to set new WorldRenderer");
                    e.printStackTrace();
                }
            }
        }
    }

    private void spawnEnvironmentParticles(Entity player, World world, int range, BlockPos.Mutable movingPos) {
        BlockPos belowPos;
        BlockState below;
        BlockPos playerPos = player.func_180425_c();
        Random rand = world.field_73012_v;
        int x = playerPos.func_177958_n() + rand.nextInt(range) - rand.nextInt(range);
        int y = playerPos.func_177956_o() + rand.nextInt(range) - rand.nextInt(range);
        int z = playerPos.func_177952_p() + rand.nextInt(range) - rand.nextInt(range);
        movingPos.func_181079_c(x, y, z);
        BlockState blockState = world.func_180495_p((BlockPos)movingPos);
        if (blockState.func_185904_a() == Material.field_151586_h) {
            Biome biome = world.func_226691_t_((BlockPos)movingPos);
        }
        if (blockState.func_185904_a() == Material.field_151586_h && !world.func_204610_c((BlockPos)movingPos).func_206889_d() && (below = world.func_180495_p(belowPos = movingPos.func_177977_b())).func_185904_a() == Material.field_151586_h) {
            int waterRange = 1;
            BlockPos.Mutable waterMovingPos = new BlockPos.Mutable();
            for (int i = -waterRange; i <= waterRange; ++i) {
                for (int k = -waterRange; k <= waterRange; ++k) {
                    waterMovingPos.func_181079_c(x + i, y - 1, z + k);
                    BlockState adjBlock = world.func_180495_p((BlockPos)waterMovingPos);
                    if (adjBlock.func_185904_a() != Material.field_151586_h || !world.func_204610_c((BlockPos)waterMovingPos).func_206889_d() || !world.func_175623_d(waterMovingPos.func_177984_a())) continue;
                    for (int l = 0; l < 2; ++l) {
                        double px = (double)x + 0.5 + (double)((float)i * rand.nextFloat());
                        double py = (float)y + rand.nextFloat() * 0.2f;
                        double pz = (double)z + 0.5 + (double)((float)k * rand.nextFloat());
                        double speed = MathHelper.func_82716_a((Random)rand, (double)0.03, (double)0.07);
                        world.func_195594_a((IParticleData)LOTRParticles.WATERFALL.get(), px, py, pz, 0.0, speed, 0.0);
                    }
                }
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        TickEvent.Phase phase = event.phase;
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity viewer = this.mc.field_175622_Z;
        if (phase == TickEvent.Phase.START) {
            renderPartialTick = event.renderTickTime;
        }
        if (phase == TickEvent.Phase.END && player != null) {
            World world = player.field_70170_p;
            boolean guiEnabled = Minecraft.func_71382_s();
            boolean isModDimension = world.func_201675_m() instanceof LOTRDimension;
            if (guiEnabled && (isModDimension || ((Boolean)LOTRConfig.CLIENT.showAlignmentEverywhere.get()).booleanValue())) {
                this.alignmentRenderer.renderAlignmentHUDBar(this.mc, (PlayerEntity)player, renderPartialTick);
            }
            if (guiEnabled && this.mc.field_71462_r == null) {
                if (isModDimension && ((Boolean)LOTRConfig.CLIENT.compass.get()).booleanValue() && !this.mc.field_71474_y.field_74330_P) {
                    this.compassRenderer.renderCompassAndInformation(this.mc, (PlayerEntity)player, world, renderPartialTick);
                }
                if (world.func_201675_m().func_186058_p() == LOTRDimensions.middleEarth()) {
                    this.dateDisplay.render(this.mc);
                }
            }
        }
    }

    public void setInRingPortal(Entity entity) {
        if (entity == this.mc.field_71439_g) {
            this.inRingPortal = true;
        }
    }

    private void checkResourcePack(World world, PlayerEntity player) {
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS)) {
            this.sentResourcePackCheck = false;
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        this.drunkEffect.handle(event);
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        ClientWorld world = this.mc.field_71441_e;
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity viewer = this.mc.field_175622_Z;
        float partialTick = event.getPartialTicks();
        IngameGui guiIngame = this.mc.field_71456_v;
        if (world != null && viewer != null && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            float mountainsMistFactor;
            float sunGlareBrightness = this.sunGlare.getGlareBrightness(partialTick);
            if (sunGlareBrightness > 0.0f && this.mc.field_71474_y.field_74320_O == 0) {
                this.renderColoredOverlay(this.sunGlare.getGlareColorRGB(), sunGlareBrightness *= 1.0f);
            }
            if (this.inRingPortal) {
                float progress = (float)this.ringPortalTick / 100.0f;
                progress = Math.min(progress, 1.0f);
                this.renderTexturedOverlay(PORTAL_OVERLAY, 0.1f + progress * 0.6f);
            }
            if ((mountainsMistFactor = this.mountainsMist.getCurrentMistFactor(viewer, partialTick)) > 0.0f) {
                this.renderTexturedOverlay(MIST_OVERLAY, mountainsMistFactor * 0.75f);
            }
        }
    }

    private void renderTexturedOverlay(ResourceLocation texture, float alpha) {
        this.renderOverlay(texture, null, alpha);
    }

    private void renderColoredOverlay(float[] rgb, float alpha) {
        this.renderOverlay(null, rgb, alpha);
    }

    private void renderOverlay(@Nullable ResourceLocation texture, @Nullable float[] rgb, float alpha) {
        MainWindow mainWindow = this.mc.func_228018_at_();
        int width = mainWindow.func_198107_o();
        int height = mainWindow.func_198087_p();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        if (rgb != null) {
            RenderSystem.color4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        if (texture != null) {
            this.mc.func_110434_K().func_110577_a(texture);
        } else {
            RenderSystem.disableTexture();
        }
        double depth = -90.0;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_(0.0, (double)height, depth).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buf.func_225582_a_((double)width, (double)height, depth).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buf.func_225582_a_((double)width, 0.0, depth).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buf.func_225582_a_(0.0, 0.0, depth).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tess.func_78381_a();
        if (texture == null) {
            RenderSystem.enableTexture();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        float f = event.getPartialTicks();
        if (((Boolean)LOTRConfig.CLIENT.northernLights.get()).booleanValue() && world.func_201675_m().func_186058_p() == LOTRDimensions.middleEarth()) {
            NorthernLightsRenderer.render(mc, world, event.getMatrixStack(), f);
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewer = event.getInfo().func_216773_g();
        World world = viewer.field_70170_p;
        Dimension dimension = world.func_201675_m();
        Biome biome = world.func_226691_t_(viewer.func_180425_c());
        float farPlane = event.getFarPlaneDistance();
        FogRenderer.FogType fogType = event.getType();
        if (dimension instanceof LOTRDimension) {
            float ashFog;
            float sandFog;
            float mountainsMistFactor;
            float[] fogStartEnd = ((LOTRDimension)dimension).modifyFogIntensity(farPlane, fogType, viewer);
            float fogStart = fogStartEnd[0];
            float fogEnd = fogStartEnd[1];
            float rain = this.rainMist.getRainMistStrength(renderPartialTick);
            if (rain > 0.0f) {
                float rainOpacityStart = 0.95f;
                float rainOpacityEnd = 0.2f;
                fogStart -= fogStart * (rain * rainOpacityStart);
                fogEnd -= fogEnd * (rain * rainOpacityEnd);
            }
            if ((mountainsMistFactor = this.mountainsMist.getCurrentMistFactor(viewer, renderPartialTick)) > 0.0f) {
                float mistOpacityStart = 0.95f;
                float mistOpacityEnd = 0.7f;
                fogStart -= fogStart * (mountainsMistFactor * mistOpacityStart);
                fogEnd -= fogEnd * (mountainsMistFactor * mistOpacityEnd);
            }
            if ((sandFog = this.sandstormFog.getWeatherFogStrength(renderPartialTick)) > 0.0f) {
                float sandOpacityStart = 0.99f;
                float sandOpacityEnd = 0.75f;
                fogStart -= fogStart * (sandFog * sandOpacityStart);
                fogEnd -= fogEnd * (sandFog * sandOpacityEnd);
            }
            if ((ashFog = this.ashfallFog.getWeatherFogStrength(renderPartialTick)) > 0.0f) {
                float ashOpacityStart = 0.95f;
                float ashOpacityEnd = 0.6f;
                fogStart -= fogStart * (ashFog * ashOpacityStart);
                fogEnd -= fogEnd * (ashFog * ashOpacityEnd);
            }
            RenderSystem.fogStart((float)fogStart);
            RenderSystem.fogEnd((float)fogEnd);
        }
    }

    @SubscribeEvent
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        this.sandstormFog.modifyFogColors(event, renderPartialTick);
        this.ashfallFog.modifyFogColors(event, renderPartialTick);
    }

    public void displayNewDate() {
        this.dateDisplay.displayNewDate();
    }

    public void displayAlignmentDrain(int numFactions) {
        this.alignmentRenderer.displayAlignmentDrain(numFactions);
    }

    public float getCurrentSandstormFogStrength() {
        return this.sandstormFog.getWeatherFogStrength(renderPartialTick);
    }
}

