/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import lotr.client.gui.CustomWaypointScreen;
import lotr.client.gui.UpdateCustomWaypointScreen;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.network.CPacketDestroyCustomWaypoint;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.world.map.CustomWaypoint;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DestroyCustomWaypointScreen
extends CustomWaypointScreen {
    private final UpdateCustomWaypointScreen parentScreen;
    private final CustomWaypoint theWaypoint;
    private Button destroyButton;
    private Button cancelButton;
    private int destroyTimer;

    public DestroyCustomWaypointScreen(UpdateCustomWaypointScreen parent, CustomWaypoint wp) {
        super((ITextComponent)new StringTextComponent("CWP"));
        this.parentScreen = parent;
        this.theWaypoint = wp;
        this.destroyTimer = 20;
    }

    public void init() {
        super.init();
        this.destroyButton = (Button)this.addButton((Widget)new RedBookButton(this.width / 2 + 4, this.height / 2 + 65, 120, 20, I18n.func_135052_a((String)"gui.lotr.cwp.destroy.do", (Object[])new Object[0]), b -> {
            LOTRPacketHandler.sendToServer(new CPacketDestroyCustomWaypoint(this.theWaypoint));
            this.minecraft.field_71439_g.func_71053_j();
        }).setRedText());
        this.destroyButton.active = false;
        this.cancelButton = (Button)this.addButton((Widget)new RedBookButton(this.width / 2 - 124, this.height / 2 + 65, 120, 20, I18n.func_135052_a((String)"gui.lotr.cwp.destroy.cancel", (Object[])new Object[0]), b -> this.onClose()));
    }

    public void onClose() {
        this.minecraft.func_147108_a((Screen)this.parentScreen);
    }

    @Override
    public void tick() {
        super.tick();
        --this.destroyTimer;
        if (this.destroyTimer <= 0) {
            this.destroyButton.active = true;
        }
    }

    public void render(int mouseX, int mouseY, float f) {
        this.renderBackground();
        String title = I18n.func_135052_a((String)"gui.lotr.cwp.destroy.title", (Object[])new Object[0]);
        this.drawCenteredString(this.font, title, this.width / 2, this.height / 2 - 90, 0xFFFFFF);
        String warning1 = I18n.func_135052_a((String)"gui.lotr.cwp.destroy.warning.1", (Object[])new Object[]{this.theWaypoint.getDisplayName().func_150254_d()});
        String warning2 = I18n.func_135052_a((String)"gui.lotr.cwp.destroy.warning.2", (Object[])new Object[0]);
        String warning3 = I18n.func_135052_a((String)"gui.lotr.cwp.destroy.warning.3", (Object[])new Object[0]);
        int warningY = this.drawCenteredStringLinesWrappedToWidth(this.font, warning1, 300, this.width / 2, this.height / 2 - 55, 0xFFFFFF);
        this.drawCenteredString(this.font, warning2, this.width / 2, warningY += 16, 0xFFFFFF);
        warningY += 30;
        warningY = this.drawCenteredStringLinesWrappedToWidth(this.font, warning3, 300, this.width / 2, warningY, 0xFFFFFF);
        int adoptedCount = this.theWaypoint.getAdoptedCountForDisplay();
        if (adoptedCount > 0) {
            String warningAdopted = ChatFormatting.RED + I18n.func_135052_a((String)"gui.lotr.cwp.destroy.warning.adopted", (Object[])new Object[]{adoptedCount});
            this.drawCenteredString(this.font, warningAdopted, this.width / 2, warningY += 12, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, f);
    }
}

