/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.client.gui.MiddleEarthMapRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.fml.BrandingControl;

public class LOTRMainMenuScreen
extends MainMenuScreen {
    private static final ResourceLocation TITLE_TEXTURE = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation TITLE_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private boolean fadeIn = isFirstMenu;
    private static boolean isFirstMenu = true;
    private long firstRenderTime;
    private boolean minceraft;
    private String splashText;
    private String copyrightText = "Copyright Mojang AB. Do not distribute!";
    private int widthCopyright;
    private int widthCopyrightRest;
    private NotificationModUpdateScreen modUpdateNotification;
    private MiddleEarthMapScreen mapGui;
    private static MiddleEarthMapRenderer mapRenderer;
    private static int tickCounter;
    private static Random rand;
    private static List<MapWaypoint> waypointRoute;
    private static int currentWPIndex;
    private static boolean randomWPStart;
    private static float mapSpeed;
    private static float mapVelX;
    private static float mapVelY;
    private static final float wpChangeDistance = 12.0f;
    private static final float mapSpeedMax = 0.8f;
    private static final float mapSpeedIncr = 0.01f;
    private static final float mapAccel = 0.02f;
    private static final float zoomBase = -0.1f;
    private static final float zoomOscilSpeed = 0.003f;
    private static final float zoomOscilMax = 0.8f;

    public LOTRMainMenuScreen() {
        isFirstMenu = false;
        this.minceraft = (double)new Random().nextFloat() < 1.0E-4;
        this.mapGui = new MiddleEarthMapScreen();
        mapRenderer = new MiddleEarthMapRenderer();
        mapRenderer.setSepia(false);
        LOTRMainMenuScreen.setupWaypoints();
        if (!waypointRoute.isEmpty()) {
            currentWPIndex = randomWPStart ? rand.nextInt(waypointRoute.size()) : 0;
            MapWaypoint wp = waypointRoute.get(currentWPIndex);
            LOTRMainMenuScreen.mapRenderer.prevMapX = LOTRMainMenuScreen.mapRenderer.mapX = wp.getMapX();
            LOTRMainMenuScreen.mapRenderer.prevMapY = LOTRMainMenuScreen.mapRenderer.mapY = wp.getMapZ();
        } else {
            MapSettings mapSettings = MapSettingsManager.clientInstance().getCurrentLoadedMap();
            LOTRMainMenuScreen.mapRenderer.prevMapX = LOTRMainMenuScreen.mapRenderer.mapX = (double)mapSettings.getOriginX();
            LOTRMainMenuScreen.mapRenderer.prevMapY = LOTRMainMenuScreen.mapRenderer.mapY = (double)mapSettings.getOriginZ();
        }
    }

    private static void setupWaypoints() {
        waypointRoute.clear();
        MapSettings mapSettings = MapSettingsManager.clientInstance().getCurrentLoadedMap();
        waypointRoute.addAll(mapSettings.getMenuWaypointRoute());
    }

    public void init() {
        super.init();
        if (this.splashText == null) {
            this.splashText = this.minecraft.func_213269_at().func_215276_a();
        }
        this.widthCopyright = this.font.func_78256_a(this.copyrightText);
        this.widthCopyrightRest = this.width - this.widthCopyright - 2;
        Button modbutton = this.buttons.stream().filter(widget -> widget instanceof Button && widget.getMessage().equals(I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0]))).findFirst().orElse(null);
        this.modUpdateNotification = NotificationModUpdateScreen.init((MainMenuScreen)this, (Button)modbutton);
        int lowerButtonMaxY = 0;
        for (Widget button : this.buttons) {
            int buttonMaxY = button.y + button.getHeight();
            if (buttonMaxY <= lowerButtonMaxY) continue;
            lowerButtonMaxY = buttonMaxY;
        }
        int idealMoveDown = 50;
        int lowestSuitableHeight = this.height - 25;
        int moveDown = Math.min(idealMoveDown, lowestSuitableHeight - lowerButtonMaxY);
        moveDown = Math.max(moveDown, 0);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Widget button = (Widget)this.buttons.get(i);
            button.y += moveDown;
            if (button.getClass() != Button.class) continue;
            Button bt = (Button)button;
            RedBookButton newButton = new RedBookButton(bt.x, bt.y, bt.getWidth(), bt.getHeight(), bt.getMessage(), b -> bt.onPress());
            this.buttons.set(i, newButton);
        }
    }

    public void init(Minecraft mc, int i, int j) {
        super.init(mc, i, j);
        this.mapGui.loadCurrentMapTextures();
        this.mapGui.init(mc, i, j);
    }

    public void tick() {
        super.tick();
        ++tickCounter;
        mapRenderer.tick();
        if (!waypointRoute.isEmpty()) {
            double dy;
            MapWaypoint wp;
            double dx;
            double distSq;
            double dist;
            if (currentWPIndex >= waypointRoute.size()) {
                currentWPIndex = 0;
            }
            if ((dist = Math.sqrt(distSq = (dx = (wp = waypointRoute.get(currentWPIndex)).getMapX() - LOTRMainMenuScreen.mapRenderer.mapX) * dx + (dy = wp.getMapZ() - LOTRMainMenuScreen.mapRenderer.mapY) * dy)) <= 12.0) {
                if (++currentWPIndex >= waypointRoute.size()) {
                    currentWPIndex = 0;
                }
            } else {
                mapSpeed += 0.01f;
                mapSpeed = Math.min(mapSpeed, 0.8f);
                float vXNew = (float)(dx / dist) * mapSpeed;
                float vYNew = (float)(dy / dist) * mapSpeed;
                float a = 0.02f;
                mapVelX += (vXNew - mapVelX) * a;
                mapVelY += (vYNew - mapVelY) * a;
            }
        }
        LOTRMainMenuScreen.mapRenderer.mapX += (double)mapVelX;
        LOTRMainMenuScreen.mapRenderer.mapY += (double)mapVelY;
    }

    public void render(int mouseX, int mouseY, float f) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.firstRenderTime == 0L && this.fadeIn) {
            this.firstRenderTime = Util.func_211177_b();
        }
        float fade = this.fadeIn ? (float)(Util.func_211177_b() - this.firstRenderTime) / 1000.0f : 1.0f;
        LOTRMainMenuScreen.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-1);
        LOTRMainMenuScreen.mapRenderer.zoomExp = -0.1f + MathHelper.func_76134_b((float)(((float)tickCounter + f) * 0.003f)) * 0.8f;
        if (this.fadeIn) {
            float slowerFade = fade * 0.5f;
            float fadeInZoom = MathHelper.func_76131_a((float)(1.0f - slowerFade), (float)0.0f, (float)1.0f) * -2.5f;
            LOTRMainMenuScreen.mapRenderer.zoomExp += fadeInZoom;
        }
        LOTRMainMenuScreen.mapRenderer.zoomStable = (float)Math.pow(2.0, -0.1f);
        mapRenderer.renderMap((Screen)this, this.mapGui, f);
        mapRenderer.renderVignettes((Screen)this, this.getBlitOffset(), 2);
        int i = 274;
        int j = this.width / 2 - i / 2;
        this.minecraft.func_110434_K().func_110577_a(PANORAMA_OVERLAY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fadeIn ? MathHelper.func_76131_a((float)(1.0f - fade), (float)0.0f, (float)1.0f) : 0.0f));
        LOTRMainMenuScreen.blit((int)0, (int)0, (int)this.width, (int)this.height, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.fadeIn ? MathHelper.func_76131_a((float)(fade - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = MathHelper.func_76123_f((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            this.minecraft.func_110434_K().func_110577_a(TITLE_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.minceraft) {
                this.blit(j + 0, 30, 0, 0, 99, 44);
                this.blit(j + 99, 30, 129, 0, 27, 44);
                this.blit(j + 99 + 26, 30, 126, 0, 3, 44);
                this.blit(j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                this.blit(j + 155, 30, 0, 45, 155, 44);
            } else {
                this.blit(j + 0, 30, 0, 0, 155, 44);
                this.blit(j + 155, 30, 0, 45, 155, 44);
            }
            String modTitle = I18n.func_135052_a((String)"lotr.menu.title", (Object[])new Object[0]);
            this.drawString(this.font, modTitle, this.width / 2 - this.font.func_78256_a(modTitle) / 2, 86, -1);
            String modSubtitle = I18n.func_135052_a((String)"lotr.menu.subtitle", (Object[])new Object[0]);
            this.drawString(this.font, ChatFormatting.ITALIC + modSubtitle, this.width / 2 - this.font.func_78256_a(modSubtitle) / 2, 96, -2236963);
            this.minecraft.func_110434_K().func_110577_a(TITLE_EDITION);
            LOTRMainMenuScreen.blit((int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            ForgeHooksClient.renderMainMenu((MainMenuScreen)this, (FontRenderer)this.font, (int)this.width, (int)this.height);
            String s = "Minecraft " + SharedConstants.func_215069_a().getName();
            s = this.minecraft.func_71355_q() ? s + " Demo" : s + ("release".equalsIgnoreCase(this.minecraft.func_184123_d()) ? "" : "/" + this.minecraft.func_184123_d());
            if (this.minecraft.func_230151_c_()) {
                s = s + I18n.func_135052_a((String)"menu.modded", (Object[])new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                this.font.getClass();
                this.drawString(this.font, (String)brd, 2, this.height - (10 + n * (9 + 1)), 0xFFFFFF | l);
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.width - this.font.func_78256_a(brd);
                int n2 = brdline + 1;
                this.font.getClass();
                this.drawString(this.font, (String)brd, n, this.height - (10 + n2 * (9 + 1)), 0xFFFFFF | l);
            });
            this.drawString(this.font, this.copyrightText, this.widthCopyrightRest, this.height - 10, 0xFFFFFF | l);
            if (mouseX > this.widthCopyrightRest && mouseX < this.widthCopyrightRest + this.widthCopyright && mouseY > this.height - 10 && mouseY < this.height) {
                LOTRMainMenuScreen.fill((int)this.widthCopyrightRest, (int)(this.height - 1), (int)(this.widthCopyrightRest + this.widthCopyright), (int)this.height, (int)(0xFFFFFF | l));
            }
            for (Widget widget : this.buttons) {
                widget.setAlpha(f1);
            }
            for (Widget widget : this.buttons) {
                widget.render(mouseX, mouseY, f);
            }
            this.modUpdateNotification.render(mouseX, mouseY, f);
        }
    }

    static {
        rand = new Random();
        waypointRoute = new ArrayList<MapWaypoint>();
        randomWPStart = false;
    }
}

