/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class MapWidget
implements IGuiEventListener {
    private final int xPos;
    private final int yPos;
    public final int width;
    private String name;
    private final int texUBase;
    private final int texVBase;
    private int texUOffset;
    private int texVOffset;
    public boolean visible = true;
    private final BooleanSupplier onPress;

    public MapWidget(int x, int y, int w, String s, int u, int v, BooleanSupplier press) {
        this.xPos = x;
        this.yPos = y;
        this.width = w;
        this.name = s;
        this.texUBase = u;
        this.texVBase = v;
        this.onPress = press;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public String getTranslatedName() {
        return I18n.func_135052_a((String)("gui.lotr.map.widget." + this.name), (Object[])new Object[0]);
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setTexUOffset(int i) {
        this.texUOffset = i;
    }

    public void setTexVOffset(int i) {
        this.texVOffset = i;
    }

    public int getTexU() {
        return this.texUBase + this.texUOffset * this.width;
    }

    public int getTexV() {
        return this.texVBase + this.texVOffset * this.width;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.xPos && mouseX < (double)(this.xPos + this.width) && mouseY >= (double)this.yPos && mouseY < (double)(this.yPos + this.width);
    }

    public boolean mouseClicked(double x, double y, int mouseCode) {
        boolean flag;
        if (this.visible && this.isMouseOver(x, y) && mouseCode == 0 && (flag = this.onPress.getAsBoolean())) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }
}

