/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.google.common.math.IntMath;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.client.LOTRClientUtil;
import lotr.client.gui.AlignmentFormatter;
import lotr.client.gui.AlignmentRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.widget.ScrollPane;
import lotr.client.gui.widget.button.FactionsMapButton;
import lotr.client.gui.widget.button.FactionsPageButton;
import lotr.client.gui.widget.button.PledgeButton;
import lotr.client.gui.widget.button.PreferredRankGenderButton;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.config.LOTRConfig;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.FactionStats;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.DummyFactionRank;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRank;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionRelation;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.MapSquare;
import lotr.common.fac.RankGender;
import lotr.common.init.LOTRDimensions;
import lotr.common.network.CPacketSetPledge;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.world.fac.FactionSettingsManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class MiddleEarthFactionsScreen
extends MiddleEarthMenuScreen {
    public static final ResourceLocation FACTIONS_TEXTURE = new ResourceLocation("lotr", "textures/gui/factions.png");
    public static final ResourceLocation FACTIONS_TEXTURE_FULL = new ResourceLocation("lotr", "textures/gui/factions_full.png");
    private FactionSettings currentLoadedFactions;
    private static DimensionType currentDimension;
    private static DimensionType prevDimension;
    private static FactionRegion currentRegion;
    private static FactionRegion prevRegion;
    private static List<Faction> currentFactionList;
    private int currentFactionIndex = 0;
    private int prevFactionIndex = 0;
    private Faction currentFaction;
    private static final int MAX_ALIGNMENTS_DISPLAYED = 1;
    private static Page currentPage;
    private int pageY = 46;
    private int pageWidth = 256;
    private int pageHeight = 128;
    private int pageBorderLeft = 16;
    private int pageBorderTop = 12;
    private int pageMapX = 159;
    private int pageMapY = 22;
    private int pageMapSize = 80;
    private MiddleEarthMapScreen mapDrawGui;
    private final AlignmentRenderer alignmentRenderer = new AlignmentRenderer();
    private Button buttonRegions;
    private Button buttonPagePrev;
    private Button buttonPageNext;
    private Button buttonFactionMap;
    private Button buttonPreferredRanksMasc;
    private Button buttonPreferredRanksFem;
    private PledgeButton buttonOpenPledgeScreen;
    private PledgeButton buttonPledgeConfirm;
    private PledgeButton buttonPledgeRevoke;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasMouseDown;
    private boolean isMouseDown;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarBorder;
    private int scrollWidgetWidth;
    private int scrollWidgetHeight;
    private ScrollPane scrollPaneAlliesEnemies;
    private int scrollAlliesEnemiesX;
    private static final int MAX_DISPLAYED_ALLIES_ENEMIES = 10;
    private int numDisplayedAlliesEnemies;
    private List currentAlliesEnemies;
    private boolean isOtherPlayer;
    private String otherPlayerName;
    private Map<Faction, Float> otherPlayerAlignmentMap;
    private boolean isPledging;
    private boolean isUnpledging;

    public MiddleEarthFactionsScreen() {
        super((ITextComponent)new StringTextComponent("FACTIONS"));
        this.xSize = this.pageWidth;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.scrollBarWidth = 240;
        this.scrollBarHeight = 14;
        this.scrollBarX = this.xSize / 2 - this.scrollBarWidth / 2;
        this.scrollBarY = 180;
        this.scrollBarBorder = 1;
        this.scrollWidgetWidth = 17;
        this.scrollWidgetHeight = 12;
        this.scrollPaneAlliesEnemies = new ScrollPane(7, 7).setColors(5521198, 8019267);
        this.scrollAlliesEnemiesX = 138;
        this.isOtherPlayer = false;
        this.isPledging = false;
        this.isUnpledging = false;
        this.mapDrawGui = new MiddleEarthMapScreen();
        this.currentLoadedFactions = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
    }

    public void setOtherPlayer(String name, Map<Faction, Float> alignments) {
        this.isOtherPlayer = true;
        this.otherPlayerName = name;
        this.otherPlayerAlignmentMap = alignments;
    }

    public void init(Minecraft mc, int w, int h) {
        super.init(mc, w, h);
        this.mapDrawGui.init(mc, w, h);
    }

    @Override
    public void init() {
        super.init();
        if (this.isOtherPlayer) {
            this.removeButton((Widget)this.buttonMenuReturn);
        }
        this.buttonRegions = (Button)this.addButton((Widget)new RedBookButton(this.guiLeft + this.xSize / 2 - 60, this.guiTop + 200, 120, 20, "", button -> {
            List<FactionRegion> regionList = this.currentLoadedFactions.getRegionsForDimension(currentDimension);
            if (!regionList.isEmpty()) {
                int i = regionList.indexOf(currentRegion);
                ++i;
                i = IntMath.mod((int)i, (int)regionList.size());
                currentRegion = regionList.get(i);
                this.updateCurrentDimensionAndFaction();
                this.setCurrentScrollFromFaction();
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonPagePrev = (Button)this.addButton((Widget)new FactionsPageButton(this.guiLeft + 13, this.guiTop + this.pageY + 104, true, I18n.func_135052_a((String)"gui.lotr.factions.page.previous", (Object[])new Object[0]), button -> {
            Page newPage = currentPage.prev();
            if (newPage != null) {
                currentPage = newPage;
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonPageNext = (Button)this.addButton((Widget)new FactionsPageButton(this.guiLeft + this.pageWidth - 29, this.guiTop + this.pageY + 104, false, I18n.func_135052_a((String)"gui.lotr.factions.page.next", (Object[])new Object[0]), button -> {
            Page newPage = currentPage.next();
            if (newPage != null) {
                currentPage = newPage;
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonFactionMap = (Button)this.addButton((Widget)new FactionsMapButton(this.guiLeft + this.pageMapX + this.pageMapSize - 3 - 8, this.guiTop + this.pageY + this.pageMapY + 3, button -> {
            MiddleEarthMapScreen factionGuiMap = new MiddleEarthMapScreen();
            factionGuiMap.setAreasOfInfluence(this.currentFaction);
            this.minecraft.func_147108_a((Screen)factionGuiMap);
        }));
        this.buttonPreferredRanksMasc = (Button)this.addButton((Widget)new PreferredRankGenderButton(this.guiLeft + this.pageWidth - this.pageBorderLeft - 24, this.guiTop + this.pageY + this.pageBorderTop, RankGender.MASCULINE, PreferredRankGenderButton::sendPreferenceToServer));
        this.buttonPreferredRanksFem = (Button)this.addButton((Widget)new PreferredRankGenderButton(this.guiLeft + this.pageWidth - this.pageBorderLeft - 12, this.guiTop + this.pageY + this.pageBorderTop, RankGender.FEMININE, PreferredRankGenderButton::sendPreferenceToServer));
        this.buttonOpenPledgeScreen = (PledgeButton)this.addButton((Widget)new PledgeButton(this, this.guiLeft + 14, this.guiTop + this.pageY + this.pageHeight - 42, false, button -> {
            if (this.getClientPlayerData().getAlignmentData().isPledgedTo(this.currentFaction)) {
                this.isUnpledging = true;
            } else {
                this.isPledging = true;
            }
        }));
        this.buttonPledgeConfirm = (PledgeButton)this.addButton((Widget)new PledgeButton(this, this.guiLeft + this.pageWidth / 2 - 16, this.guiTop + this.pageY + this.pageHeight - 44, false, button -> {
            LOTRPacketHandler.sendToServer(new CPacketSetPledge(this.currentFaction));
            this.isPledging = false;
        }));
        this.buttonPledgeRevoke = (PledgeButton)this.addButton((Widget)new PledgeButton(this, this.guiLeft + this.pageWidth / 2 - 16, this.guiTop + this.pageY + this.pageHeight - 44, true, button -> {
            LOTRPacketHandler.sendToServer(new CPacketSetPledge(null));
            this.isUnpledging = false;
            this.minecraft.func_147108_a(null);
        }));
        prevDimension = currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.minecraft.field_71441_e);
        AlignmentDataModule alignData = LOTRLevelData.clientInstance().getData((PlayerEntity)this.minecraft.field_71439_g).getAlignmentData();
        this.currentFaction = alignData.getCurrentViewedFactionOrFallbackToFirstIn(currentDimension);
        if (this.currentFaction != null) {
            prevRegion = currentRegion = this.currentFaction.getRegion();
            currentFactionList = this.currentLoadedFactions.getFactionsForRegion(currentRegion);
            this.prevFactionIndex = this.currentFactionIndex = currentFactionList.indexOf(this.currentFaction);
            this.setCurrentScrollFromFaction();
        }
    }

    private LOTRPlayerData getClientPlayerData() {
        return LOTRLevelData.clientInstance().getData((PlayerEntity)this.minecraft.field_71439_g);
    }

    @Override
    public void tick() {
        super.tick();
        this.updateCurrentDimensionAndFaction();
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        if (this.isPledging && !alignData.hasPledgeAlignment(this.currentFaction)) {
            this.isPledging = false;
        }
        if (this.isUnpledging && !alignData.isPledgedTo(this.currentFaction)) {
            this.isUnpledging = false;
        }
    }

    private void updateCurrentDimensionAndFaction() {
        boolean changes;
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        HashMap<FactionRegion, Faction> lastViewedRegions = new HashMap<FactionRegion, Faction>();
        if (currentFactionList != null && this.currentFactionIndex != this.prevFactionIndex) {
            this.currentFaction = currentFactionList.get(this.currentFactionIndex);
        }
        this.prevFactionIndex = this.currentFactionIndex;
        currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.minecraft.field_71441_e);
        if (currentDimension != prevDimension) {
            currentRegion = this.currentLoadedFactions.getRegions().get(0);
        }
        if (currentRegion != prevRegion) {
            alignData.setRegionLastViewedFaction(prevRegion, this.currentFaction);
            lastViewedRegions.put(prevRegion, this.currentFaction);
            currentFactionList = this.currentLoadedFactions.getFactionsForRegion(currentRegion);
            this.currentFaction = alignData.getRegionLastViewedFaction(currentRegion);
            this.prevFactionIndex = this.currentFactionIndex = currentFactionList.indexOf(this.currentFaction);
        }
        prevDimension = currentDimension;
        prevRegion = currentRegion;
        Faction prevFaction = alignData.getCurrentViewedFaction();
        boolean bl = changes = this.currentFaction != prevFaction;
        if (changes) {
            alignData.setCurrentViewedFaction(this.currentFaction);
            lastViewedRegions.forEach(alignData::setRegionLastViewedFaction);
            alignData.sendViewedFactionsToServer();
            this.isPledging = false;
            this.isUnpledging = false;
        }
    }

    private boolean useFullPageTexture() {
        return this.isPledging || this.isUnpledging || currentPage == Page.RANKS;
    }

    public void render(int mouseX, int mouseY, float f) {
        LOTRPlayerData clientPD = this.getClientPlayerData();
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        boolean mouseOverAlignLock = false;
        boolean mouseOverCivilianKills = false;
        if (!this.isPledging && !this.isUnpledging) {
            boolean isRanksPage;
            this.buttonPagePrev.active = currentPage.prev() != null;
            this.buttonPageNext.active = currentPage.next() != null;
            this.buttonFactionMap.active = currentPage != Page.RANKS && this.currentFaction != null && this.currentFaction.getMapSquare() != null && LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.minecraft.field_71441_e) == this.currentFaction.getDimension();
            this.buttonFactionMap.visible = this.buttonFactionMap.active;
            if (!AreasOfInfluence.areAreasOfInfluenceEnabled((World)this.minecraft.field_71441_e)) {
                this.buttonFactionMap.active = false;
                this.buttonFactionMap.visible = false;
            }
            this.buttonPreferredRanksMasc.visible = this.buttonPreferredRanksMasc.active = (isRanksPage = currentPage == Page.RANKS);
            this.buttonPreferredRanksFem.visible = this.buttonPreferredRanksFem.active = isRanksPage;
            if (!this.isOtherPlayer && currentPage == Page.OVERVIEW) {
                if (alignData.isPledgedTo(this.currentFaction)) {
                    this.buttonOpenPledgeScreen.setDisplayAsBroken(this.buttonOpenPledgeScreen.isHovered());
                    this.buttonOpenPledgeScreen.active = true;
                    this.buttonOpenPledgeScreen.visible = true;
                    this.buttonOpenPledgeScreen.setTooltipLines(I18n.func_135052_a((String)"gui.lotr.factions.unpledge", (Object[])new Object[0]));
                } else {
                    this.buttonOpenPledgeScreen.setDisplayAsBroken(false);
                    this.buttonOpenPledgeScreen.visible = alignData.getPledgeFaction() == null && this.currentFaction.isPlayableAlignmentFaction() && alignData.getAlignment(this.currentFaction) >= 0.0f;
                    this.buttonOpenPledgeScreen.active = this.buttonOpenPledgeScreen.visible && alignData.hasPledgeAlignment(this.currentFaction);
                    String desc1 = I18n.func_135052_a((String)"gui.lotr.factions.pledge", (Object[])new Object[0]);
                    String desc2 = I18n.func_135052_a((String)"gui.lotr.factions.pledge.req", (Object[])new Object[]{AlignmentFormatter.formatAlignForDisplay(this.currentFaction.getPledgeAlignment())});
                    this.buttonOpenPledgeScreen.setTooltipLines(desc1, desc2);
                }
            } else {
                this.buttonOpenPledgeScreen.active = false;
                this.buttonOpenPledgeScreen.visible = false;
            }
            this.buttonPledgeConfirm.active = false;
            this.buttonPledgeConfirm.visible = false;
            this.buttonPledgeRevoke.active = false;
            this.buttonPledgeRevoke.visible = false;
        } else {
            this.buttonPagePrev.active = false;
            this.buttonPageNext.active = false;
            this.buttonFactionMap.active = false;
            this.buttonFactionMap.visible = false;
            this.buttonPreferredRanksMasc.active = false;
            this.buttonPreferredRanksMasc.visible = false;
            this.buttonPreferredRanksFem.active = false;
            this.buttonPreferredRanksFem.visible = false;
            this.buttonOpenPledgeScreen.active = false;
            this.buttonOpenPledgeScreen.visible = false;
            if (this.isPledging) {
                this.buttonPledgeConfirm.visible = true;
                this.buttonPledgeConfirm.active = alignData.canMakeNewPledge() && alignData.canPledgeToNow(this.currentFaction);
                this.buttonPledgeConfirm.setTooltipLines(I18n.func_135052_a((String)"gui.lotr.factions.pledge", (Object[])new Object[0]));
                this.buttonPledgeRevoke.active = false;
                this.buttonPledgeRevoke.visible = false;
            } else if (this.isUnpledging) {
                this.buttonPledgeConfirm.active = false;
                this.buttonPledgeConfirm.visible = false;
                this.buttonPledgeRevoke.active = true;
                this.buttonPledgeRevoke.visible = true;
                this.buttonPledgeRevoke.setTooltipLines(I18n.func_135052_a((String)"gui.lotr.factions.unpledge", (Object[])new Object[0]));
            }
        }
        this.processFactionScrollBar(mouseX, mouseY);
        this.renderBackground();
        if (this.useFullPageTexture()) {
            this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE_FULL);
        } else {
            this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.guiLeft, this.guiTop + this.pageY, 0, 0, this.pageWidth, this.pageHeight);
        String title = I18n.func_135052_a((String)"gui.lotr.factions.title", (Object[])new Object[]{LOTRDimensions.getDisplayName(currentDimension).func_150254_d()});
        if (this.isOtherPlayer) {
            title = I18n.func_135052_a((String)"gui.lotr.factions.title", (Object[])new Object[]{this.otherPlayerName});
        }
        this.font.func_211126_b(title, (float)(this.guiLeft + this.xSize / 2 - this.font.func_78256_a(title) / 2), (float)(this.guiTop - 30), 0xFFFFFF);
        if (currentRegion != null && this.currentLoadedFactions.getRegionsForDimension(currentDimension).size() > 1) {
            this.buttonRegions.setMessage(currentRegion.getDisplayName().func_150254_d());
            this.buttonRegions.active = true;
            this.buttonRegions.visible = true;
        } else {
            this.buttonRegions.setMessage("");
            this.buttonRegions.active = false;
            this.buttonRegions.visible = false;
        }
        if (this.currentFaction != null) {
            float alignment = this.isOtherPlayer && this.otherPlayerAlignmentMap != null ? this.otherPlayerAlignmentMap.get(this.currentFaction).floatValue() : alignData.getAlignment(this.currentFaction);
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop;
            this.alignmentRenderer.renderAlignmentBar(this.minecraft, alignment, this.isOtherPlayer, this.currentFaction, x, y, true, false, true, true);
            this.font.getClass();
            String s = this.currentFaction.getDisplaySubtitle().func_150254_d();
            this.drawCenteredStringNoShadow(this.font, s, x, y += 9 + 22, 0xFFFFFF);
            this.font.getClass();
            y += 9 * 3;
            if (!this.useFullPageTexture()) {
                MapSquare mapSquare = this.currentFaction.getMapSquare();
                if (mapSquare != null) {
                    int mapX = mapSquare.mapX;
                    int mapZ = mapSquare.mapZ;
                    int mapR = mapSquare.radius;
                    int xMin = this.guiLeft + this.pageMapX;
                    int xMax = xMin + this.pageMapSize;
                    int yMin = this.guiTop + this.pageY + this.pageMapY;
                    int yMax = yMin + this.pageMapSize;
                    int mapBorder = 1;
                    MiddleEarthFactionsScreen.fill((int)(xMin - mapBorder), (int)(yMin - mapBorder), (int)(xMax + mapBorder), (int)(yMax + mapBorder), (int)-16777216);
                    float zoom = (float)this.pageMapSize / (float)(mapR * 2);
                    float zoomExp = (float)Math.log(zoom) / (float)Math.log(2.0);
                    MiddleEarthMapScreen.StaticMapProperties statics = MiddleEarthMapScreen.setFakeStaticPropertiesAndSaveCurrent(this.pageMapSize, this.pageMapSize, xMin, xMax, yMin, yMax);
                    this.mapDrawGui.setFakeMapProperties(mapX, mapZ, zoom, zoomExp, zoom);
                    this.mapDrawGui.enableZoomOutWPFading = false;
                    boolean sepia = (Boolean)LOTRConfig.CLIENT.sepiaMap.get();
                    this.mapDrawGui.renderMapAndOverlay(sepia, 1.0f, true);
                    MiddleEarthMapScreen.restoreFakeStaticProperties(statics);
                }
                int wcX = this.guiLeft + this.pageMapX + 3;
                int wcY = this.guiTop + this.pageY + this.pageMapY + this.pageMapSize + 5;
                int wcWidth = 8;
                this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.currentFaction.approvesCivilianKills()) {
                    this.blit(wcX, wcY, 33, 142, wcWidth, wcWidth);
                } else {
                    this.blit(wcX, wcY, 41, 142, wcWidth, wcWidth);
                }
                if (mouseX >= wcX && mouseX < wcX + wcWidth && mouseY >= wcY && mouseY < wcY + wcWidth) {
                    mouseOverCivilianKills = true;
                }
            }
            x = this.guiLeft + this.pageBorderLeft;
            y = this.guiTop + this.pageY + this.pageBorderTop;
            if (!this.isPledging && !this.isUnpledging) {
                int index;
                if (currentPage == Page.OVERVIEW) {
                    if (this.isOtherPlayer) {
                        s = I18n.func_135052_a((String)"gui.lotr.factions.overview.otherPlayer", (Object[])new Object[]{this.otherPlayerName});
                        this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                        this.font.getClass();
                        y += 9 * 2;
                    }
                    String alignmentInfo = I18n.func_135052_a((String)"gui.lotr.factions.alignment", (Object[])new Object[0]);
                    this.font.func_211126_b(alignmentInfo, (float)x, (float)y, 8019267);
                    String alignmentString = AlignmentFormatter.formatAlignForDisplay(alignment);
                    this.alignmentRenderer.drawAlignmentText(this.font, x += this.font.func_78256_a(alignmentInfo) + 5, y, alignmentString, 1.0f);
                    if (alignData.isPledgeEnemyAlignmentLimited(this.currentFaction)) {
                        this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        int lockX = x + this.font.func_78256_a(alignmentString) + 5;
                        int lockY = y;
                        int lockWidth = 16;
                        this.blit(lockX, lockY, 0, 200, lockWidth, lockWidth);
                        if (mouseX >= lockX && mouseX < lockX + lockWidth && mouseY >= lockY && mouseY < lockY + lockWidth) {
                            mouseOverAlignLock = true;
                        }
                    }
                    this.font.getClass();
                    x = this.guiLeft + this.pageBorderLeft;
                    FactionRank curRank = this.currentFaction.getRankFor(alignment);
                    String rankName = curRank.getDisplayFullName(clientPD.getMiscData().getPreferredRankGender());
                    rankName = I18n.func_135052_a((String)"gui.lotr.factions.alignment.rank", (Object[])new Object[]{rankName});
                    this.font.func_211126_b(rankName, (float)x, (float)(y += 9), 8019267);
                    this.font.getClass();
                    y += 9 * 2;
                    if (!this.isOtherPlayer) {
                        FactionStats factionStats = clientPD.getFactionStatsData().getFactionStats(this.currentFaction);
                        if (alignment >= 0.0f) {
                            float conq;
                            s = I18n.func_135052_a((String)"gui.lotr.factions.stats.enemiesKilled", (Object[])new Object[]{factionStats.getEnemiesKilled()});
                            this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                            this.font.getClass();
                            s = I18n.func_135052_a((String)"gui.lotr.factions.stats.trades", (Object[])new Object[]{factionStats.getTradeCount()});
                            this.font.func_211126_b(s, (float)x, (float)(y += 9), 8019267);
                            this.font.getClass();
                            s = I18n.func_135052_a((String)"gui.lotr.factions.stats.hires", (Object[])new Object[]{factionStats.getHireCount()});
                            this.font.func_211126_b(s, (float)x, (float)(y += 9), 8019267);
                            this.font.getClass();
                            s = I18n.func_135052_a((String)"gui.lotr.factions.stats.miniquests", (Object[])new Object[]{factionStats.getMiniQuestsCompleted()});
                            this.font.func_211126_b(s, (float)x, (float)(y += 9), 8019267);
                            this.font.getClass();
                            y += 9;
                            if (alignData.isPledgedTo(this.currentFaction) && (conq = factionStats.getConquestEarned()) != 0.0f) {
                                int conqInt = Math.round(conq);
                                s = I18n.func_135052_a((String)"gui.lotr.factions.stats.conquest", (Object[])new Object[]{conqInt});
                                this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                                this.font.getClass();
                                y += 9;
                            }
                        }
                        if (alignment <= 0.0f) {
                            s = I18n.func_135052_a((String)"gui.lotr.factions.stats.membersKilled", (Object[])new Object[]{factionStats.getMembersKilled()});
                            this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                            this.font.getClass();
                            y += 9;
                        }
                        if (this.buttonOpenPledgeScreen.visible && alignData.isPledgedTo(this.currentFaction)) {
                            s = I18n.func_135052_a((String)"gui.lotr.factions.pledged", (Object[])new Object[0]);
                            int px = this.buttonOpenPledgeScreen.x + this.buttonOpenPledgeScreen.getWidth() + 8;
                            int n = this.buttonOpenPledgeScreen.y + this.buttonOpenPledgeScreen.getHeight() / 2;
                            this.font.getClass();
                            int py = n - 9 / 2;
                            this.font.func_211126_b(s, (float)px, (float)py, 0xFF0000);
                        }
                    }
                } else if (currentPage == Page.RANKS) {
                    FactionRank curRank = this.currentFaction.getRankFor(clientPD);
                    int[] minMax = this.scrollPaneAlliesEnemies.getMinMaxIndices(this.currentAlliesEnemies, this.numDisplayedAlliesEnemies);
                    for (index = minMax[0]; index <= minMax[1]; ++index) {
                        Object listObj = this.currentAlliesEnemies.get(index);
                        if (listObj instanceof String) {
                            s = (String)listObj;
                            this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                        } else if (listObj instanceof FactionRank) {
                            FactionRank rank = (FactionRank)listObj;
                            String rankName = rank.getDisplayShortName(clientPD.getMiscData().getPreferredRankGender());
                            String rankAlign = AlignmentFormatter.formatAlignForDisplay(rank.getAlignment());
                            if (rank == DummyFactionRank.ENEMY) {
                                rankAlign = "-";
                            }
                            boolean hiddenRankName = false;
                            if (!alignData.isPledgedTo(this.currentFaction) && rank.getAlignment() > this.currentFaction.getPledgeAlignment() && rank.getAlignment() > this.currentFaction.getRankAbove(curRank).getAlignment()) {
                                hiddenRankName = true;
                            }
                            if (hiddenRankName) {
                                rankName = I18n.func_135052_a((String)"gui.lotr.factions.rank.unknown", (Object[])new Object[0]);
                            }
                            s = I18n.func_135052_a((String)"gui.lotr.factions.listRank", (Object[])new Object[]{rankName, rankAlign});
                            if (rank == curRank) {
                                this.alignmentRenderer.drawAlignmentText(this.font, x, y, s, 1.0f);
                            } else {
                                this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                            }
                        }
                        this.font.getClass();
                        y += 9;
                    }
                } else if (currentPage == Page.GOOD_RELATIONS || currentPage == Page.BAD_RELATIONS) {
                    int avgBgColor = LOTRClientUtil.computeAverageFactionPageColor(this.minecraft, FACTIONS_TEXTURE, 20, 20, 120, 80);
                    int[] minMax = this.scrollPaneAlliesEnemies.getMinMaxIndices(this.currentAlliesEnemies, this.numDisplayedAlliesEnemies);
                    for (index = minMax[0]; index <= minMax[1]; ++index) {
                        Object listObj = this.currentAlliesEnemies.get(index);
                        if (listObj instanceof FactionRelation) {
                            FactionRelation rel = (FactionRelation)((Object)listObj);
                            s = I18n.func_135052_a((String)"gui.lotr.factions.relationHeader", (Object[])new Object[]{rel.getDisplayName().func_150254_d()});
                            this.font.func_211126_b(s, (float)x, (float)y, 8019267);
                        } else if (listObj instanceof Faction) {
                            Faction fac = (Faction)listObj;
                            s = I18n.func_135052_a((String)"gui.lotr.factions.list", (Object[])new Object[]{fac.getDisplayName().func_150254_d()});
                            this.font.func_211126_b(s, (float)x, (float)y, LOTRClientUtil.findContrastingColor(fac.getColor(), avgBgColor));
                        }
                        this.font.getClass();
                        y += 9;
                    }
                }
                if (this.scrollPaneAlliesEnemies.hasScrollBar) {
                    this.scrollPaneAlliesEnemies.drawScrollBar();
                }
            } else {
                int stringWidth = this.pageWidth - this.pageBorderLeft * 2;
                ArrayList<String> displayLines = new ArrayList<String>();
                if (this.isPledging) {
                    List<Faction> facsPreventingPledge = alignData.getFactionsPreventingPledgeTo(this.currentFaction);
                    if (facsPreventingPledge.isEmpty()) {
                        if (alignData.canMakeNewPledge()) {
                            if (alignData.canPledgeToNow(this.currentFaction)) {
                                String desc = I18n.func_135052_a((String)"gui.lotr.factions.pledge.desc.1", (Object[])new Object[]{this.currentFaction.getDisplayName().func_150254_d()});
                                displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                                displayLines.add("");
                                desc = I18n.func_135052_a((String)"gui.lotr.factions.pledge.desc.2", (Object[])new Object[0]);
                                displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                            }
                        } else {
                            String brokenPledgeName = Faction.getFactionOrUnknownDisplayName(alignData.getBrokenPledgeFaction()).func_150254_d();
                            String desc = I18n.func_135052_a((String)"gui.lotr.factions.pledge.breakCooldown", (Object[])new Object[]{this.currentFaction.getDisplayName().func_150254_d(), brokenPledgeName});
                            displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                            displayLines.add("");
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                            this.blit(this.guiLeft + this.pageWidth / 2 - 97, this.guiTop + this.pageY + 56, 0, 240, 194, 16);
                            this.blit(this.guiLeft + this.pageWidth / 2 - 75, this.guiTop + this.pageY + 60, 22, 232, MathHelper.func_76123_f((float)(alignData.getPledgeBreakCooldownFraction() * 150.0f)), 8);
                        }
                    } else {
                        Collections.sort(facsPreventingPledge, Comparator.comparing(alignData::getAlignment).reversed());
                        String facNames = "If you are reading this, something has gone hideously wrong.";
                        if (facsPreventingPledge.size() == 1) {
                            facNames = I18n.func_135052_a((String)"gui.lotr.factions.pledge.enemies.1", (Object[])new Object[]{facsPreventingPledge.get(0).getDisplayName().func_150254_d()});
                        } else if (facsPreventingPledge.size() == 2) {
                            facNames = I18n.func_135052_a((String)"gui.lotr.factions.pledge.enemies.2", (Object[])new Object[]{facsPreventingPledge.get(0).getDisplayName().func_150254_d(), facsPreventingPledge.get(1).getDisplayName().func_150254_d()});
                        } else if (facsPreventingPledge.size() == 3) {
                            facNames = I18n.func_135052_a((String)"gui.lotr.factions.pledge.enemies.3", (Object[])new Object[]{facsPreventingPledge.get(0).getDisplayName().func_150254_d(), facsPreventingPledge.get(1).getDisplayName().func_150254_d(), facsPreventingPledge.get(2).getDisplayName().func_150254_d()});
                        } else if (facsPreventingPledge.size() > 3) {
                            facNames = I18n.func_135052_a((String)"gui.lotr.factions.pledge.enemies.3+", (Object[])new Object[]{facsPreventingPledge.get(0).getDisplayName().func_150254_d(), facsPreventingPledge.get(1).getDisplayName().func_150254_d(), facsPreventingPledge.get(2).getDisplayName().func_150254_d(), facsPreventingPledge.size() - 3});
                        }
                        String desc = I18n.func_135052_a((String)"gui.lotr.factions.pledge.enemies", (Object[])new Object[]{this.currentFaction.getDisplayName().func_150254_d(), facNames});
                        displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                        displayLines.add("");
                    }
                } else if (this.isUnpledging) {
                    String desc = I18n.func_135052_a((String)"gui.lotr.factions.unpledge.desc.1", (Object[])new Object[]{this.currentFaction.getDisplayName().func_150254_d()});
                    displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                    displayLines.add("");
                    desc = I18n.func_135052_a((String)"gui.lotr.factions.unpledge.desc.2", (Object[])new Object[0]);
                    displayLines.addAll(this.font.func_78271_c(desc, stringWidth));
                }
                for (String line : displayLines) {
                    this.font.func_211126_b(line, (float)x, (float)y, 8019267);
                    this.font.getClass();
                    y += 9;
                }
            }
        }
        if (this.hasScrollBar()) {
            this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(this.guiLeft + this.scrollBarX, this.guiTop + this.scrollBarY, 0, 128, this.scrollBarWidth, this.scrollBarHeight);
            int factions = currentFactionList.size();
            for (int index = 0; index < factions; ++index) {
                Faction faction = currentFactionList.get(index);
                float[] factionColors = faction.getColorComponents();
                float shade = 0.6f;
                RenderSystem.color4f((float)(factionColors[0] * shade), (float)(factionColors[1] * shade), (float)(factionColors[2] * shade), (float)1.0f);
                float fracMin = (float)index / (float)factions;
                float fracMax = (float)(index + 1) / (float)factions;
                float uMin = (float)this.scrollBarBorder + fracMin * (float)(this.scrollBarWidth - this.scrollBarBorder * 2);
                float uMax = (float)this.scrollBarBorder + fracMax * (float)(this.scrollBarWidth - this.scrollBarBorder * 2);
                float xMin = (float)(this.guiLeft + this.scrollBarX) + uMin;
                float xMax = (float)(this.guiLeft + this.scrollBarX) + uMax;
                float yMin = this.guiTop + this.scrollBarY + this.scrollBarBorder;
                float yMax = this.guiTop + this.scrollBarY + this.scrollBarHeight - this.scrollBarBorder;
                LOTRClientUtil.blitFloat((AbstractGui)this, (double)xMin, (double)yMin, 0.0f + uMin, (float)(128 + this.scrollBarBorder), (double)(xMax - xMin), (double)(yMax - yMin));
            }
            this.minecraft.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.canScroll()) {
                int scroll = (int)(this.currentScroll * (float)(this.scrollBarWidth - this.scrollBarBorder * 2 - this.scrollWidgetWidth));
                this.blit(this.guiLeft + this.scrollBarX + this.scrollBarBorder + scroll, this.guiTop + this.scrollBarY + this.scrollBarBorder, 0, 142, this.scrollWidgetWidth, this.scrollWidgetHeight);
            }
        }
        super.render(mouseX, mouseY, f);
        this.renderButtonTooltipIfHovered(this.buttonFactionMap, I18n.func_135052_a((String)"gui.lotr.factions.viewMap", (Object[])new Object[0]), mouseX, mouseY);
        Page prevPage = currentPage.prev();
        Page nextPage = currentPage.next();
        if (prevPage != null) {
            this.renderButtonTooltipIfHovered(this.buttonPagePrev, prevPage.getDisplayName(), mouseX, mouseY);
        }
        if (nextPage != null) {
            this.renderButtonTooltipIfHovered(this.buttonPageNext, nextPage.getDisplayName(), mouseX, mouseY);
        }
        this.renderButtonTooltipIfHovered(this.buttonPreferredRanksMasc, I18n.func_135052_a((String)"gui.lotr.factions.rankGender.masc", (Object[])new Object[0]), mouseX, mouseY);
        this.renderButtonTooltipIfHovered(this.buttonPreferredRanksFem, I18n.func_135052_a((String)"gui.lotr.factions.rankGender.fem", (Object[])new Object[0]), mouseX, mouseY);
        if (mouseOverAlignLock) {
            String alignLimit = AlignmentFormatter.formatAlignForDisplay(alignData.getPledgeEnemyAlignmentLimit(this.currentFaction));
            String lockDesc = I18n.func_135052_a((String)"gui.lotr.factions.pledgeLocked", (Object[])new Object[]{alignLimit, alignData.getPledgeFaction().getDisplayName().func_150254_d()});
            int stringWidth = 200;
            this.renderTooltip(this.font.func_78271_c(lockDesc, stringWidth), mouseX, mouseY);
        }
        if (mouseOverCivilianKills) {
            String civilianKills = this.currentFaction.approvesCivilianKills() ? "gui.lotr.factions.civilianKills.yes" : "gui.lotr.factions.civilianKills.no";
            civilianKills = I18n.func_135052_a((String)civilianKills, (Object[])new Object[0]);
            int stringWidth = 200;
            this.renderTooltip(this.font.func_78271_c(civilianKills, stringWidth), mouseX, mouseY);
        }
    }

    private boolean hasScrollBar() {
        return currentFactionList.size() > 1;
    }

    private boolean canScroll() {
        return true;
    }

    private void processFactionScrollBar(int mouseX, int mouseY) {
        int i1 = this.guiLeft + this.scrollBarX;
        int j1 = this.guiTop + this.scrollBarY;
        int i2 = i1 + this.scrollBarWidth;
        int j2 = j1 + this.scrollBarHeight;
        if (!this.wasMouseDown && this.isMouseDown && mouseX >= i1 && mouseY >= j1 && mouseX < i2 && mouseY < j2) {
            this.isScrolling = this.canScroll();
        }
        if (!this.isMouseDown) {
            this.isScrolling = false;
        }
        this.wasMouseDown = this.isMouseDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseX - i1) - (float)this.scrollWidgetWidth / 2.0f) / ((float)(i2 - i1) - (float)this.scrollWidgetWidth);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.currentFactionIndex = Math.round(this.currentScroll * (float)(currentFactionList.size() - 1));
            this.scrollPaneAlliesEnemies.resetScroll();
        }
        if (currentPage == Page.GOOD_RELATIONS || currentPage == Page.BAD_RELATIONS || currentPage == Page.RANKS) {
            if (currentPage == Page.GOOD_RELATIONS) {
                List<Faction> friends;
                this.currentAlliesEnemies = new ArrayList();
                List<Faction> allies = this.currentFaction.getOthersOfRelation(FactionRelation.ALLY);
                if (!allies.isEmpty()) {
                    this.currentAlliesEnemies.add(FactionRelation.ALLY);
                    this.currentAlliesEnemies.addAll(allies);
                }
                if (!(friends = this.currentFaction.getOthersOfRelation(FactionRelation.FRIEND)).isEmpty()) {
                    if (!this.currentAlliesEnemies.isEmpty()) {
                        this.currentAlliesEnemies.add(null);
                    }
                    this.currentAlliesEnemies.add(FactionRelation.FRIEND);
                    this.currentAlliesEnemies.addAll(friends);
                }
            } else if (currentPage == Page.BAD_RELATIONS) {
                List<Faction> enemies;
                this.currentAlliesEnemies = new ArrayList();
                List<Faction> mortals = this.currentFaction.getOthersOfRelation(FactionRelation.MORTAL_ENEMY);
                if (!mortals.isEmpty()) {
                    this.currentAlliesEnemies.add(FactionRelation.MORTAL_ENEMY);
                    this.currentAlliesEnemies.addAll(mortals);
                }
                if (!(enemies = this.currentFaction.getOthersOfRelation(FactionRelation.ENEMY)).isEmpty()) {
                    if (!this.currentAlliesEnemies.isEmpty()) {
                        this.currentAlliesEnemies.add(null);
                    }
                    this.currentAlliesEnemies.add(FactionRelation.ENEMY);
                    this.currentAlliesEnemies.addAll(enemies);
                }
            } else if (currentPage == Page.RANKS) {
                this.currentAlliesEnemies = new ArrayList();
                this.currentAlliesEnemies.add(I18n.func_135052_a((String)"gui.lotr.factions.ranksHeader", (Object[])new Object[0]));
                if (LOTRLevelData.clientInstance().getData((PlayerEntity)this.minecraft.field_71439_g).getAlignmentData().getAlignment(this.currentFaction) <= 0.0f) {
                    this.currentAlliesEnemies.add(DummyFactionRank.ENEMY);
                }
                FactionRank rank = DummyFactionRank.NEUTRAL;
                while (true) {
                    this.currentAlliesEnemies.add(rank);
                    FactionRank nextRank = this.currentFaction.getRankAbove(rank);
                    if (nextRank == null || nextRank.isDummyRank() || this.currentAlliesEnemies.contains(nextRank)) break;
                    rank = nextRank;
                }
            }
            this.scrollPaneAlliesEnemies.hasScrollBar = false;
            this.numDisplayedAlliesEnemies = this.currentAlliesEnemies.size();
            if (this.numDisplayedAlliesEnemies > 10) {
                this.numDisplayedAlliesEnemies = 10;
                this.scrollPaneAlliesEnemies.hasScrollBar = true;
            }
            this.scrollPaneAlliesEnemies.paneX0 = this.guiLeft;
            this.scrollPaneAlliesEnemies.scrollBarX0 = this.guiLeft + this.scrollAlliesEnemiesX;
            if (currentPage == Page.RANKS) {
                this.scrollPaneAlliesEnemies.scrollBarX0 += 50;
            }
            int n = this.scrollPaneAlliesEnemies.paneY0 = this.guiTop + this.pageY + this.pageBorderTop;
            this.font.getClass();
            this.scrollPaneAlliesEnemies.paneY1 = n + 9 * this.numDisplayedAlliesEnemies;
            this.scrollPaneAlliesEnemies.mouseDragScroll(mouseX, mouseY, this.isMouseDown);
        } else {
            this.scrollPaneAlliesEnemies.hasScrollBar = false;
            this.scrollPaneAlliesEnemies.mouseDragScroll(mouseX, mouseY, this.isMouseDown);
        }
    }

    @Override
    public boolean keyPressed(int key, int scan, int param3) {
        if (this.isEscapeOrInventoryKey(key, scan)) {
            if (this.isPledging) {
                this.isPledging = false;
                return true;
            }
            if (this.isUnpledging) {
                this.isUnpledging = false;
                return true;
            }
            if (this.isOtherPlayer) {
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
        }
        return super.keyPressed(key, scan, param3);
    }

    public boolean mouseClicked(double x, double y, int code) {
        if (code == 0) {
            this.isMouseDown = true;
        }
        return super.mouseClicked(x, y, code);
    }

    public boolean mouseReleased(double x, double y, int code) {
        if (code == 0) {
            this.isMouseDown = false;
        }
        return super.mouseReleased(x, y, code);
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        if (super.mouseScrolled(x, y, scroll)) {
            return true;
        }
        if (scroll != 0.0) {
            if (this.scrollPaneAlliesEnemies.hasScrollBar && this.scrollPaneAlliesEnemies.mouseOver) {
                int l = this.currentAlliesEnemies.size() - this.numDisplayedAlliesEnemies;
                this.scrollPaneAlliesEnemies.mouseWheelScroll(scroll, l);
                return true;
            }
            if (scroll < 0.0) {
                this.currentFactionIndex = Math.min(this.currentFactionIndex + 1, Math.max(0, currentFactionList.size() - 1));
            }
            if (scroll > 0.0) {
                this.currentFactionIndex = Math.max(this.currentFactionIndex - 1, 0);
            }
            this.setCurrentScrollFromFaction();
            this.scrollPaneAlliesEnemies.resetScroll();
            this.isPledging = false;
            this.isUnpledging = false;
            return true;
        }
        return false;
    }

    private void setCurrentScrollFromFaction() {
        this.currentScroll = (float)this.currentFactionIndex / (float)(currentFactionList.size() - 1);
    }

    static {
        currentPage = Page.OVERVIEW;
    }

    public static enum Page {
        OVERVIEW("overview"),
        RANKS("ranks"),
        GOOD_RELATIONS("goodRelations"),
        BAD_RELATIONS("badRelations");

        private final String pageName;

        private Page(String name) {
            this.pageName = name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)("gui.lotr.factions.page." + this.pageName), (Object[])new Object[0]);
        }

        public Page prev() {
            int i = this.ordinal();
            if (i == 0) {
                return null;
            }
            return Page.values()[--i];
        }

        public Page next() {
            int i = this.ordinal();
            if (i == Page.values().length - 1) {
                return null;
            }
            return Page.values()[++i];
        }
    }
}

