/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import lotr.client.MapImageTextures;
import lotr.client.gui.MiddleEarthMapScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class MiddleEarthMapRenderer {
    public static final ResourceLocation VIGNETTE_TEXTURE = new ResourceLocation("textures/misc/vignette.png");
    public double prevMapX;
    public double mapX;
    public double prevMapY;
    public double mapY;
    public float zoomExp;
    public float zoomStable;
    private boolean sepia = false;

    public void setSepia(boolean flag) {
        this.sepia = flag;
    }

    public void tick() {
        this.prevMapX = this.mapX;
        this.prevMapY = this.mapY;
    }

    public void renderMap(Screen gui, MiddleEarthMapScreen mapGui, float f) {
        this.renderMap(gui, mapGui, f, 0, 0, gui.width, gui.height);
    }

    public void renderMap(Screen gui, MiddleEarthMapScreen mapGui, float f, int x0, int y0, int x1, int y1) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int seaColor = MapImageTextures.INSTANCE.getMapBackgroundColor(this.sepia);
        Screen.fill((int)x0, (int)y0, (int)x1, (int)y1, (int)seaColor);
        float zoom = (float)Math.pow(2.0, this.zoomExp);
        double mapPosX = this.prevMapX + (this.mapX - this.prevMapX) * (double)f;
        double mapPosY = this.prevMapY + (this.mapY - this.prevMapY) * (double)f;
        mapGui.setFakeMapProperties(mapPosX, mapPosY, zoom, this.zoomExp, this.zoomStable);
        MiddleEarthMapScreen.StaticMapProperties statics = MiddleEarthMapScreen.setFakeStaticPropertiesAndSaveCurrent(x1 - x0, y1 - y0, x0, x1, y0, y1);
        mapGui.enableZoomOutWPFading = false;
        mapGui.setBlitOffset(gui.getBlitOffset());
        mapGui.renderMapAndOverlay(this.sepia, 1.0f, true);
        mapGui.renderRoads(false);
        mapGui.renderWaypoints(0, 0, 0, false);
        MiddleEarthMapScreen.restoreFakeStaticProperties(statics);
    }

    public void renderVignette(Screen gui, double zLevel) {
        this.renderVignette(gui, zLevel, 0, 0, gui.width, gui.height);
    }

    public void renderVignette(Screen gui, double zLevel, int x0, int y0, int x1, int y1) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(VIGNETTE_TEXTURE);
        float alpha = 1.0f;
        RenderSystem.color4f((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        float u0 = (float)x0 / (float)gui.width;
        float u1 = (float)x1 / (float)gui.width;
        float v0 = (float)y0 / (float)gui.height;
        float v1 = (float)y1 / (float)gui.height;
        double z = zLevel;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_((double)x0, (double)y1, z).func_225583_a_(u0, v1).func_181675_d();
        buf.func_225582_a_((double)x1, (double)y1, z).func_225583_a_(u1, v1).func_181675_d();
        buf.func_225582_a_((double)x1, (double)y0, z).func_225583_a_(u1, v0).func_181675_d();
        buf.func_225582_a_((double)x0, (double)y0, z).func_225583_a_(u0, v0).func_181675_d();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tess.func_78381_a();
        RenderSystem.defaultBlendFunc();
    }

    public void renderVignettes(Screen gui, double zLevel, int count) {
        for (int l = 0; l < count; ++l) {
            this.renderVignette(gui, zLevel);
        }
    }

    public void renderVignettes(Screen gui, double zLevel, int count, int x0, int y0, int x1, int y1) {
        for (int l = 0; l < count; ++l) {
            this.renderVignette(gui, zLevel, x0, y0, x1, y1);
        }
    }
}

