/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.google.common.collect.Streams;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.client.LOTRClientUtil;
import lotr.client.LOTRKeyHandler;
import lotr.client.MapImageTextures;
import lotr.client.gui.AlignmentRenderer;
import lotr.client.gui.MapWidget;
import lotr.client.gui.MiddleEarthFactionsScreen;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.WaypointTooltipRenderer;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreaOfInfluence;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.Faction;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRItems;
import lotr.common.network.CPacketFastTravel;
import lotr.common.network.CPacketIsOpRequest;
import lotr.common.network.CPacketMapTp;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.util.LOTRUtil;
import lotr.common.world.map.GeneratedRoadPoint;
import lotr.common.world.map.MapLabel;
import lotr.common.world.map.MapPlayerLocation;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.Road;
import lotr.common.world.map.RoadSection;
import lotr.common.world.map.RouteRoadPoint;
import lotr.common.world.map.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;

public class MiddleEarthMapScreen
extends MiddleEarthMenuScreen {
    private static Map<UUID, MapPlayerLocation> playerLocations = new HashMap<UUID, MapPlayerLocation>();
    public static final ResourceLocation MAP_ICONS = new ResourceLocation("lotr", "textures/map/screen.png");
    private static final ItemStack QUEST_ICON = new ItemStack((IItemProvider)LOTRItems.RED_BOOK.get());
    public static final int BLACK = -16777216;
    public static final int BORDER_COLOR = -6156032;
    private static final int MAP_BORDER = 30;
    private static boolean fullscreen = true;
    private final MapSettings loadedMapSettings;
    private static int mapWidth;
    private static int mapHeight;
    private static int mapXMin;
    private static int mapXMax;
    private static int mapYMin;
    private static int mapYMax;
    private static int mapXMin_W;
    private static int mapXMax_W;
    private static int mapYMin_W;
    private static int mapYMax_W;
    private List<MapWidget> mapWidgets = new ArrayList<MapWidget>();
    private MapWidget widgetZoomIn;
    private MapWidget widgetZoomOut;
    private MapWidget widgetFullScreen;
    private MapWidget widgetSepia;
    private MapWidget widgetLabels;
    private MapWidget widgetToggleMapWPs;
    private MapWidget widgetToggleCustomWPs;
    private MapWidget widgetToggleShowLocation;
    private int tickCounter;
    private double posX;
    private double posY;
    private int isMouseButtonDown;
    private int prevMouseX;
    private int prevMouseY;
    private boolean isMouseWithinMap;
    private int mouseXCoord;
    private int mouseZCoord;
    private double posXMove;
    private double posYMove;
    private double prevPosX;
    private double prevPosY;
    private static final int MIN_ZOOM = -3;
    private static final int MAX_ZOOM = 4;
    private static float zoomPower;
    private float prevZoomPower = zoomPower;
    private float zoomScale;
    private float zoomScaleStable;
    private float zoomExp;
    private static final int ZOOM_TIME = 6;
    private int zoomTicks;
    private int prevZoomTicks;
    public boolean enableZoomOutWPFading = true;
    private static final DecimalFormat ZOOM_DISPLAY_FORMAT;
    private int zoomingMessageDisplayTicks;
    private static final int ZOOMING_MESSAGE_DISPLAY_TIME = 30;
    private boolean zoomingMessageIsZoomIn;
    private Waypoint selectedWaypoint;
    private static final int WAYPOINT_SELECT_RANGE = 5;
    private final WaypointTooltipRenderer waypointTooltip = new WaypointTooltipRenderer();
    private int waypointSelectTick;
    private int prevWaypointSelectTick;
    private static final int WAYPOINT_SELECT_TIME = 6;
    private boolean hasOverlay;
    private boolean isPlayerOp = false;
    private boolean sentOpRequestPacket = false;
    private Faction areaOfInfluenceFaction;
    private boolean mouseInAreaOfInfluence;
    private boolean mouseInReducedAreaOfInfluence;
    private final AlignmentRenderer alignmentRenderer = new AlignmentRenderer();
    private boolean isFacScrolling = false;

    public static void refreshPlayerLocations(List<MapPlayerLocation> newPlayerLocations) {
        MiddleEarthMapScreen.clearPlayerLocations();
        ClientPlayNetHandler nph = Minecraft.func_71410_x().func_147114_u();
        for (MapPlayerLocation loc : newPlayerLocations) {
            UUID playerID = loc.profile.getId();
            if (playerID != null) {
                NetworkPlayerInfo player = nph.func_175102_a(playerID);
                playerLocations.put(playerID, loc.withFullProfile(player.func_178845_a()));
                continue;
            }
            LOTRLog.warn("Received map player location from server with null UUID");
        }
    }

    public static void clearPlayerLocations() {
        playerLocations.clear();
    }

    public MiddleEarthMapScreen() {
        super((ITextComponent)new StringTextComponent("MAP"));
        this.loadedMapSettings = MapSettingsManager.clientInstance().getLoadedMapOrLoadDefault(Minecraft.func_71410_x().func_195551_G());
        this.loadCurrentMapTextures();
    }

    public void loadCurrentMapTextures() {
        MapImageTextures.INSTANCE.loadMapTexturesIfNew(this.loadedMapSettings);
    }

    public void setAreasOfInfluence(Faction faction) {
        this.areaOfInfluenceFaction = faction;
    }

    private boolean hasAreasOfInfluence() {
        return this.areaOfInfluenceFaction != null && AreasOfInfluence.areAreasOfInfluenceEnabled((World)this.minecraft.field_71441_e);
    }

    @Override
    public void init() {
        this.xSize = 256;
        this.ySize = 256;
        super.init();
        if (fullscreen) {
            int midX = this.width / 2;
            int buttonMargin = 100;
            this.buttonMenuReturn.x = midX - buttonMargin - this.buttonMenuReturn.getWidth();
            this.buttonMenuReturn.y = 4;
        }
        if (this.hasAreasOfInfluence()) {
            this.removeButton((Widget)this.buttonMenuReturn);
        }
        this.setupMapDimensions();
        this.setupMapWidgets();
        this.children.add(new MapDragListener());
        if (this.hasAreasOfInfluence()) {
            this.setupMapDimensions();
            double[] zoneBorders = this.areaOfInfluenceFaction.getAreasOfInfluence().calculateAreaOfInfluenceBordersIncludingReduced();
            double xMin = zoneBorders[0];
            double xMax = zoneBorders[1];
            double zMin = zoneBorders[2];
            double zMax = zoneBorders[3];
            double centreX = (xMin + xMax) / 2.0;
            double centreZ = (zMin + zMax) / 2.0;
            this.posX = this.loadedMapSettings.worldToMapX_frac(centreX);
            this.posY = this.loadedMapSettings.worldToMapZ_frac(centreZ);
            double zoneWidth = xMax - xMin;
            double zoneHeight = zMax - zMin;
            double mapZoneWidth = this.loadedMapSettings.worldToMapDistance(zoneWidth);
            double mapZoneHeight = this.loadedMapSettings.worldToMapDistance(zoneHeight);
            int zoomPowerWidth = MathHelper.func_76128_c((double)(Math.log((double)mapWidth / mapZoneWidth) / Math.log(2.0)));
            int zoomPowerHeight = MathHelper.func_76128_c((double)(Math.log((double)mapHeight / mapZoneHeight) / Math.log(2.0)));
            this.prevZoomPower = zoomPower = (float)Math.min(zoomPowerWidth, zoomPowerHeight);
        } else if (this.minecraft.field_71439_g != null) {
            this.posX = this.loadedMapSettings.worldToMapX_frac(this.minecraft.field_71439_g.func_226277_ct_());
            this.posY = this.loadedMapSettings.worldToMapZ_frac(this.minecraft.field_71439_g.func_226281_cx_());
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.waypointTooltip.init(this, this.minecraft, this.font);
    }

    private void setupMapWidgets() {
        this.mapWidgets.clear();
        this.widgetZoomIn = new MapWidget(mapXMin + 6, mapYMin + 6, 10, "zoomIn", 30, 0, () -> {
            if (!this.hasOverlay && this.zoomTicks == 0 && zoomPower < 4.0f) {
                this.zoomIn();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetZoomIn);
        this.widgetZoomOut = new MapWidget(mapXMin + 6, mapYMin + 20, 10, "zoomOut", 40, 0, () -> {
            if (!this.hasOverlay && this.zoomTicks == 0 && zoomPower > -3.0f) {
                this.zoomOut();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetZoomOut);
        this.widgetFullScreen = new MapWidget(mapXMin + 20, mapYMin + 6, 10, "fullScreen", 50, 0, () -> {
            if (!this.hasOverlay) {
                fullscreen = !fullscreen;
                this.init(this.minecraft, this.minecraft.func_228018_at_().func_198107_o(), this.minecraft.func_228018_at_().func_198087_p());
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetFullScreen);
        this.widgetSepia = new MapWidget(mapXMin + 34, mapYMin + 6, 10, "sepia", 60, 0, () -> {
            if (!this.hasOverlay) {
                LOTRConfig.CLIENT.toggleSepia();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetSepia);
        this.widgetLabels = new MapWidget(mapXMax - 16, mapYMin + 6, 10, "labels", 70, 0, () -> {
            if (!this.hasOverlay) {
                this.toggleMapLabels();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetLabels);
        this.widgetToggleMapWPs = new MapWidget(mapXMax - 44, mapYMin + 6, 10, "toggleMapWPs", 80, 0, () -> {
            if (!this.hasOverlay) {
                this.getClientPlayerData().getFastTravelData().toggleShowMapWaypointsAndSendToServer();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetToggleMapWPs);
        this.widgetToggleCustomWPs = new MapWidget(mapXMax - 30, mapYMin + 6, 10, "toggleCustomWPs", 90, 0, () -> {
            if (!this.hasOverlay) {
                this.getClientPlayerData().getFastTravelData().toggleShowCustomWaypointsAndSendToServer();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetToggleCustomWPs);
        this.widgetToggleShowLocation = new MapWidget(mapXMax - 16, mapYMin + 20, 10, "toggleShowLocation", 60, 10, () -> {
            if (!this.hasOverlay) {
                this.getClientPlayerData().getMiscData().toggleShowMapLocationAndSendToServer();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetToggleShowLocation);
        this.children.addAll(this.mapWidgets);
    }

    private void setupMapDimensions() {
        if (fullscreen) {
            mapXMin = 30;
            mapXMax = this.width - 30;
            mapYMin = 30;
            mapYMax = this.height - 30;
        } else {
            int windowWidth = 312;
            mapXMin = this.width / 2 - windowWidth / 2;
            mapXMax = this.width / 2 + windowWidth / 2;
            mapYMin = this.guiTop;
            mapYMax = this.guiTop + 200;
        }
        mapWidth = mapXMax - mapXMin;
        mapHeight = mapYMax - mapYMin;
    }

    public LOTRPlayerData getClientPlayerData() {
        return LOTRLevelData.clientInstance().getData((PlayerEntity)this.minecraft.field_71439_g);
    }

    private boolean showOwnLocation() {
        return this.minecraft.field_71439_g == null || this.getClientPlayerData().getMiscData().getShowMapLocation();
    }

    private boolean showMapWaypoints() {
        return this.minecraft.field_71439_g == null || this.getClientPlayerData().getFastTravelData().getShowMapWaypoints();
    }

    private boolean showCustomWaypoints() {
        return this.minecraft.field_71439_g != null && this.getClientPlayerData().getFastTravelData().getShowCustomWaypoints();
    }

    private boolean showHiddenSharedCustomWaypoints() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tickCounter;
        if (this.zoomTicks <= 0 && this.prevZoomTicks > 0) {
            this.prevZoomPower = zoomPower;
        }
        this.prevZoomTicks = this.zoomTicks;
        if (this.zoomTicks > 0) {
            --this.zoomTicks;
        }
        if (this.zoomingMessageDisplayTicks > 0) {
            --this.zoomingMessageDisplayTicks;
        }
        this.prevWaypointSelectTick = this.waypointSelectTick;
        if (this.waypointSelectTick > 0) {
            --this.waypointSelectTick;
        }
        this.handleMapKeyboardMovement();
    }

    private void setupZoomVariables(float f) {
        float zoomStableExp;
        if (this.zoomTicks > 0 || this.prevZoomTicks > 0) {
            float zoomTickLerp = (float)this.prevZoomTicks + (float)(this.zoomTicks - this.prevZoomTicks) * f;
            float progress = (6.0f - zoomTickLerp) / 6.0f;
            this.zoomExp = this.prevZoomPower + (zoomPower - this.prevZoomPower) * progress;
            zoomStableExp = Math.min(zoomPower, this.prevZoomPower);
        } else {
            zoomStableExp = this.zoomExp = zoomPower;
        }
        this.zoomScale = (float)Math.pow(2.0, this.zoomExp);
        this.zoomScaleStable = (float)Math.pow(2.0, zoomStableExp);
    }

    public void render(int mouseX, int mouseY, float tick) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        boolean blit0 = false;
        this.setBlitOffset(0);
        this.setupZoomVariables(this.minecraft.func_184121_ak());
        this.isMouseWithinMap = mouseX >= mapXMin && mouseX < mapXMax && mouseY >= mapYMin && mouseY < mapYMax;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.posX += this.posXMove * (double)tick;
        this.posY += this.posYMove * (double)tick;
        this.keepMapPositionWithinBounds();
        boolean isSepia = (Boolean)LOTRConfig.CLIENT.sepiaMap.get();
        if (fullscreen) {
            this.minecraft.func_110434_K().func_110577_a(MapImageTextures.overlayTexture);
            RenderSystem.color4f((float)0.65f, (float)0.5f, (float)0.35f, (float)1.0f);
            double z = this.getBlitOffset();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_225582_a_(0.0, (double)this.height, z).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_225582_a_((double)this.width, (double)this.height, z).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_225582_a_((double)this.width, 0.0, z).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_225582_a_(0.0, 0.0, z).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tess.func_78381_a();
            int redW = 4;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderGraduatedRects(mapXMin - 1, mapYMin - 1, mapXMax + 1, mapYMax + 1, -6156032, -16777216, redW);
        } else {
            this.renderBackground();
            this.renderGraduatedRects(mapXMin - 1, mapYMin - 1, mapXMax + 1, mapYMax + 1, -6156032, -16777216, 4);
        }
        this.setupScrollBars(mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int seaColor = MapImageTextures.INSTANCE.getMapBackgroundColor(isSepia);
        MiddleEarthMapScreen.fill((int)mapXMin, (int)mapYMin, (int)mapXMax, (int)mapYMax, (int)seaColor);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String mapTitle = this.loadedMapSettings.getTitle(I18n::func_135052_a);
        String title = I18n.func_135052_a((String)"gui.lotr.map.title", (Object[])new Object[]{mapTitle});
        if (fullscreen) {
            this.drawCenteredStringNoShadow(this.font, title, this.width / 2, 10, 0xFFFFFF);
        } else {
            this.drawCenteredStringNoShadow(this.font, title, this.width / 2, this.guiTop - 30, 0xFFFFFF);
        }
        if (this.hasAreasOfInfluence()) {
            this.renderMapAndOverlay(isSepia, 1.0f, false);
            this.renderAreasOfInfluence(mouseX, mouseY);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.renderMapAndOverlay(isSepia, 0.5f, true);
            RenderSystem.disableBlend();
        } else {
            this.renderMapAndOverlay(isSepia, 1.0f, true);
        }
        this.renderRoads();
        this.renderPlayers(mouseX, mouseY);
        this.renderWaypoints(0, mouseX, mouseY);
        this.renderLabels();
        RenderSystem.enableAlphaTest();
        MapImageTextures.drawMapCompassBottomLeft(mapXMin + 12, mapYMax - 12, 100.0f, 1.0f);
        this.renderWaypoints(1, mouseX, mouseY);
        if (this.hasAreasOfInfluence()) {
            String tooltip;
            String string = this.mouseInAreaOfInfluence ? I18n.func_135052_a((String)"gui.lotr.map.areaOfInfluence.full", (Object[])new Object[0]) : (tooltip = this.mouseInReducedAreaOfInfluence ? I18n.func_135052_a((String)"gui.lotr.map.areaOfInfluence.reduced", (Object[])new Object[0]) : null);
            if (tooltip != null) {
                this.renderInFront(() -> {
                    int strWidth = this.minecraft.field_71466_p.func_78256_a(tooltip);
                    this.minecraft.field_71466_p.getClass();
                    int strHeight = 9;
                    int rectX = mouseX + 12;
                    int rectY = mouseY - 12;
                    int border = 3;
                    int rectWidth = strWidth + border * 2;
                    int rectHeight = strHeight + border * 2;
                    int mapBorder2 = 2;
                    rectX = Math.max(rectX, mapXMin + mapBorder2);
                    rectX = Math.min(rectX, mapXMax - mapBorder2 - rectWidth);
                    rectY = Math.max(rectY, mapYMin + mapBorder2);
                    rectY = Math.min(rectY, mapYMax - mapBorder2 - rectHeight);
                    this.drawFancyRect(rectX, rectY, rectX + rectWidth, rectY + rectHeight);
                    this.font.func_211126_b(tooltip, (float)(rectX + border), (float)(rectY + border), 0xFFFFFF);
                });
            }
        }
        if (this.selectedWaypoint != null && this.isWaypointVisible(this.selectedWaypoint)) {
            if (!this.hasOverlay) {
                this.renderWaypointTooltip(this.selectedWaypoint, true, mouseX, mouseY, tick);
            }
        } else {
            this.selectWaypoint(null);
        }
        this.setBlitOffset(100);
        if (!this.hasOverlay) {
            if (this.isMiddleEarth() && this.selectedWaypoint != null) {
                int blit1 = this.getBlitOffset();
                this.setBlitOffset(500);
                LOTRPlayerData pd = this.getClientPlayerData();
                FastTravelDataModule ftData = pd.getFastTravelData();
                boolean hasUnlocked = this.selectedWaypoint.hasPlayerUnlocked((PlayerEntity)this.minecraft.field_71439_g);
                int ftSince = ftData.getTimeSinceFT();
                int wpTimeThreshold = ftData.getWaypointFTTime(this.selectedWaypoint, (PlayerEntity)this.minecraft.field_71439_g);
                int timeRemaining = wpTimeThreshold - ftSince;
                boolean canFastTravel = hasUnlocked && timeRemaining <= 0;
                String notUnlockedMessage = this.selectedWaypoint.getNotUnlockedMessage((PlayerEntity)this.minecraft.field_71439_g, I18n::func_135052_a);
                String ftPrompt = I18n.func_135052_a((String)"gui.lotr.map.fastTravel.prompt", (Object[])new Object[]{LOTRKeyHandler.getFastTravelKey(this.minecraft).func_197978_k()});
                String ftMoreTime = I18n.func_135052_a((String)"gui.lotr.map.fastTravel.moreTime", (Object[])new Object[]{LOTRUtil.getHMSTime_Ticks(timeRemaining).func_150254_d()});
                String ftWaitTime = I18n.func_135052_a((String)"gui.lotr.map.fastTravel.waitTime", (Object[])new Object[]{LOTRUtil.getHMSTime_Ticks(wpTimeThreshold).func_150254_d()});
                if (fullscreen) {
                    if (!hasUnlocked) {
                        this.renderFullscreenSubtitles(notUnlockedMessage);
                    } else if (canFastTravel) {
                        this.renderFullscreenSubtitles(ftPrompt, ftWaitTime);
                    } else {
                        this.renderFullscreenSubtitles(ftMoreTime, ftWaitTime);
                    }
                } else {
                    ArrayList<String> lines = new ArrayList<String>();
                    if (!hasUnlocked) {
                        lines.add(notUnlockedMessage);
                    } else if (canFastTravel) {
                        lines.add(ftPrompt);
                        lines.add(ftWaitTime);
                    } else {
                        lines.add(ftMoreTime);
                        lines.add(ftWaitTime);
                    }
                    this.font.getClass();
                    int stringHeight = 9;
                    int rectWidth = mapWidth;
                    int border = 3;
                    int rectHeight = border + (stringHeight + border) * lines.size();
                    int x = mapXMin + mapWidth / 2 - rectWidth / 2;
                    int y = mapYMax + 10;
                    int strX = mapXMin + mapWidth / 2;
                    int strY = y + border;
                    this.drawFancyRect(x, y, x + rectWidth, y + rectHeight);
                    for (String s : lines) {
                        this.drawCenteredStringNoShadow(this.font, s, strX, strY, 0xFFFFFF);
                        strY += stringHeight + border;
                    }
                }
                this.setBlitOffset(blit1);
            } else if (this.isMouseWithinMap) {
                int blit1 = this.getBlitOffset();
                this.setBlitOffset(500);
                double biomePosX = this.posX + (double)((float)(mouseX - mapXMin - mapWidth / 2) / this.zoomScale);
                double biomePosZ = this.posY + (double)((float)(mouseY - mapYMin - mapHeight / 2) / this.zoomScale);
                int biomePosX_int = MathHelper.func_76128_c((double)biomePosX);
                int biomePosZ_int = MathHelper.func_76128_c((double)biomePosZ);
                Biome biome = LOTRBiomes.getBiomeFromID(this.loadedMapSettings.getBiomeIdAt(biomePosX_int, biomePosZ_int));
                this.mouseXCoord = this.loadedMapSettings.mapToWorldX(biomePosX);
                this.mouseZCoord = this.loadedMapSettings.mapToWorldZ(biomePosZ);
                String biomeName = biome.func_205403_k().func_150254_d();
                String coords = I18n.func_135052_a((String)"gui.lotr.map.coords", (Object[])new Object[]{this.mouseXCoord, this.mouseZCoord});
                String teleport = I18n.func_135052_a((String)"gui.lotr.map.tp", (Object[])new Object[]{LOTRKeyHandler.KEY_BIND_MAP_TELEPORT.func_197978_k()});
                this.font.getClass();
                int stringHeight = 9;
                if (fullscreen) {
                    this.renderFullscreenSubtitles(biomeName, coords);
                    if (this.canTeleport()) {
                        RenderSystem.pushMatrix();
                        RenderSystem.translated((double)(this.width / 2 - 30 - this.font.func_78256_a(teleport) / 2), (double)0.0, (double)0.0);
                        this.renderFullscreenSubtitles(teleport);
                        RenderSystem.popMatrix();
                    }
                } else {
                    int rectWidth = mapWidth;
                    int border = 3;
                    int rectHeight = border * 3 + stringHeight * 2;
                    if (this.canTeleport()) {
                        rectHeight += (stringHeight + border) * 2;
                    }
                    int x = mapXMin + mapWidth / 2 - rectWidth / 2;
                    int y = mapYMax + 10;
                    this.drawFancyRect(x, y, x + rectWidth, y + rectHeight);
                    int strX = mapXMin + mapWidth / 2;
                    int strY = y + border;
                    this.drawCenteredStringNoShadow(this.font, biomeName, strX, strY, 0xFFFFFF);
                    this.drawCenteredStringNoShadow(this.font, coords, strX, strY += stringHeight + border, 0xFFFFFF);
                    if (this.canTeleport()) {
                        this.drawCenteredStringNoShadow(this.font, teleport, strX, strY + (stringHeight + border) * 2, 0xFFFFFF);
                    }
                }
                this.setBlitOffset(blit1);
            }
        }
        if (!this.hasOverlay && this.hasAreasOfInfluence()) {
            this.renderInFront(() -> {
                String s = I18n.func_135052_a((String)"gui.lotr.map.areaOfInfluence.title", (Object[])new Object[]{this.areaOfInfluenceFaction.getDisplayName().func_150254_d()});
                int x = mapXMin + mapWidth / 2;
                int y = mapYMin + 20;
                this.alignmentRenderer.drawAlignmentText(this.font, x - this.font.func_78256_a(s) / 2, y, s, 1.0f);
                if (!AreasOfInfluence.areAreasOfInfluenceEnabled((World)this.minecraft.field_71441_e)) {
                    s = I18n.func_135052_a((String)"gui.lotr.map.areaOfInfluence.disabled", (Object[])new Object[0]);
                    this.alignmentRenderer.drawAlignmentText(this.font, x - this.font.func_78256_a(s) / 2, mapYMin + mapHeight / 2, s, 1.0f);
                }
            });
        }
        if (this.zoomingMessageDisplayTicks > 0) {
            this.renderInFront(() -> {
                String s = this.getZoomingDisplayMessage();
                int x = mapXMin + mapWidth / 2;
                int y = mapYMax - 30;
                float alpha = LOTRUtil.trapezoidalIntensitySinglePulse(30 - this.zoomingMessageDisplayTicks, 30.0f, 0.16f, 0.0f, 1.0f);
                this.drawCenteredStringNoShadow(this.font, s, x, y, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            });
        }
        super.render(mouseX, mouseY, tick);
        this.renderMapWidgets(mouseX, mouseY);
    }

    private void setupScrollBars(int i, int j) {
    }

    private void keepMapPositionWithinBounds() {
        float mapScaleX = (float)mapWidth / this.zoomScale;
        float mapScaleY = (float)mapHeight / this.zoomScale;
        if (this.loadedMapSettings.isScreenSideLocked(Direction.WEST)) {
            this.posX = Math.max(this.posX, (double)(mapScaleX / 2.0f));
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.EAST)) {
            this.posX = Math.min(this.posX, (double)((float)this.loadedMapSettings.getWidth() - mapScaleX / 2.0f));
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.NORTH)) {
            this.posY = Math.max(this.posY, (double)(mapScaleY / 2.0f));
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.SOUTH)) {
            this.posY = Math.min(this.posY, (double)((float)this.loadedMapSettings.getHeight() - mapScaleY / 2.0f));
        }
    }

    public void renderMapAndOverlay(boolean sepia, float alpha, boolean overlay) {
        mapXMin_W = mapXMin;
        mapXMax_W = mapXMax;
        mapYMin_W = mapYMin;
        mapYMax_W = mapYMax;
        float mapScaleX = (float)mapWidth / this.zoomScale;
        float mapScaleY = (float)mapHeight / this.zoomScale;
        float minU = (float)(this.posX - (double)(mapScaleX / 2.0f)) / (float)this.loadedMapSettings.getWidth();
        float maxU = (float)(this.posX + (double)(mapScaleX / 2.0f)) / (float)this.loadedMapSettings.getWidth();
        float minV = (float)(this.posY - (double)(mapScaleY / 2.0f)) / (float)this.loadedMapSettings.getHeight();
        float maxV = (float)(this.posY + (double)(mapScaleY / 2.0f)) / (float)this.loadedMapSettings.getHeight();
        if (minU < 0.0f) {
            mapXMin_W = mapXMin + Math.round((0.0f - minU) * (float)this.loadedMapSettings.getWidth() * this.zoomScale);
            minU = 0.0f;
            if (maxU < 0.0f) {
                maxU = 0.0f;
                mapXMax_W = mapXMin_W;
            }
        }
        if (maxU > 1.0f) {
            mapXMax_W = mapXMax - Math.round((maxU - 1.0f) * (float)this.loadedMapSettings.getWidth() * this.zoomScale);
            maxU = 1.0f;
            if (minU > 1.0f) {
                minU = 1.0f;
                mapXMin_W = mapXMax_W;
            }
        }
        if (minV < 0.0f) {
            mapYMin_W = mapYMin + Math.round((0.0f - minV) * (float)this.loadedMapSettings.getHeight() * this.zoomScale);
            minV = 0.0f;
            if (maxV < 0.0f) {
                maxV = 0.0f;
                mapYMax_W = mapYMin_W;
            }
        }
        if (maxV > 1.0f) {
            mapYMax_W = mapYMax - Math.round((maxV - 1.0f) * (float)this.loadedMapSettings.getHeight() * this.zoomScale);
            maxV = 1.0f;
            if (minV > 1.0f) {
                minV = 1.0f;
                mapYMin_W = mapYMax_W;
            }
        }
        MapImageTextures.drawMap((PlayerEntity)this.minecraft.field_71439_g, sepia, mapXMin_W, mapXMax_W, mapYMin_W, mapYMax_W, this.getBlitOffset(), minU, maxU, minV, maxV, alpha);
        if (overlay) {
            MapImageTextures.drawMapOverlay((PlayerEntity)this.minecraft.field_71439_g, mapXMin, mapXMax, mapYMin, mapYMax, this.getBlitOffset(), minU, maxU, minV, maxV);
        }
    }

    private void renderGraduatedRects(int x1, int y1, int x2, int y2, int c1, int c2, int w) {
        float[] rgb1 = new Color(c1).getColorComponents(null);
        float[] rgb2 = new Color(c2).getColorComponents(null);
        for (int l = w - 1; l >= 0; --l) {
            float f = (float)l / (float)(w - 1);
            float r = rgb1[0] + (rgb2[0] - rgb1[0]) * f;
            float g = rgb1[1] + (rgb2[1] - rgb1[1]) * f;
            float b = rgb1[2] + (rgb2[2] - rgb1[2]) * f;
            int color = LOTRClientUtil.getRGBA(new Color(r, g, b).getRGB(), 1.0f);
            MiddleEarthMapScreen.fill((int)(x1 - l), (int)(y1 - l), (int)(x2 + l), (int)(y2 + l), (int)color);
        }
    }

    private void renderMapWidgets(int mouseX, int mouseY) {
        boolean fineZoom = this.isFineZoom();
        this.widgetZoomIn.visible = !this.hasOverlay;
        this.widgetZoomIn.setTexVOffset(zoomPower < 4.0f ? 0 : 1);
        this.widgetZoomIn.setName(fineZoom ? "zoomIn.fine" : "zoomIn");
        this.widgetZoomOut.visible = !this.hasOverlay;
        this.widgetZoomOut.setTexVOffset(zoomPower > -3.0f ? 0 : 1);
        this.widgetZoomOut.setName(fineZoom ? "zoomOut.fine" : "zoomOut");
        this.widgetFullScreen.visible = !this.hasOverlay;
        this.widgetSepia.visible = !this.hasOverlay;
        this.widgetLabels.visible = !this.hasOverlay;
        this.widgetToggleMapWPs.visible = !this.hasOverlay;
        this.widgetToggleMapWPs.setTexVOffset(this.showMapWaypoints() ? 0 : 1);
        this.widgetToggleCustomWPs.visible = !this.hasOverlay;
        this.widgetToggleCustomWPs.setTexVOffset(this.showCustomWaypoints() ? 0 : 1);
        this.widgetToggleShowLocation.visible = !this.hasOverlay;
        this.widgetToggleShowLocation.setTexUOffset(this.showOwnLocation() ? 0 : 1);
        this.widgetToggleShowLocation.setName(this.showOwnLocation() ? "toggleShowLocation.shown" : "toggleShowLocation.hidden");
        MapWidget mouseOverWidget = null;
        for (MapWidget widget : this.mapWidgets) {
            if (!widget.visible) continue;
            this.minecraft.func_110434_K().func_110577_a(MAP_ICONS);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(widget.getXPos(), widget.getYPos(), widget.getTexU(), widget.getTexV(), widget.width, widget.width);
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            mouseOverWidget = widget;
        }
        if (mouseOverWidget != null) {
            int stringWidth = 200;
            List desc = this.font.func_78271_c(mouseOverWidget.getTranslatedName(), stringWidth);
            this.renderTooltip(desc, mouseX, mouseY);
        }
    }

    private void renderFullscreenSubtitles(String ... lines) {
        int strX = mapXMin + mapWidth / 2;
        int strY = mapYMax + 7;
        this.font.getClass();
        int border = 9 + 3;
        if (lines.length == 1) {
            strY += border / 2;
        }
        for (String s : lines) {
            this.drawCenteredStringNoShadow(this.font, s, strX, strY, 0xFFFFFF);
            strY += border;
        }
    }

    private void renderInFront(Runnable renderer) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)300.0f);
        renderer.run();
        RenderSystem.popMatrix();
    }

    private void renderPlayers(int mouseX, int mouseY) {
        String mouseOverPlayerName = null;
        double mouseOverPlayerX = 0.0;
        double mouseOverPlayerY = 0.0;
        double distanceMouseOverPlayer = Double.MAX_VALUE;
        int iconWidthHalf = 4;
        HashMap<UUID, MapPlayerLocation> playersToRender = new HashMap<UUID, MapPlayerLocation>();
        playersToRender.putAll(playerLocations);
        if (this.isMiddleEarth()) {
            playersToRender.put(this.minecraft.field_71439_g.func_110124_au(), MapPlayerLocation.ofPlayer((PlayerEntity)this.minecraft.field_71439_g));
        }
        for (Map.Entry entry : playersToRender.entrySet()) {
            double playerY;
            MapPlayerLocation info = (MapPlayerLocation)entry.getValue();
            GameProfile profile = info.profile;
            String playerName = profile.getName();
            double playerPosX = info.posX;
            double playerPosZ = info.posZ;
            double[] pos = this.transformWorldCoords(playerPosX, playerPosZ);
            double playerX = pos[0];
            double distToPlayer = this.renderPlayerIconAndReturnDistance(profile, playerX, playerY = pos[1], mouseX, mouseY);
            if (!(distToPlayer <= (double)(iconWidthHalf + 3)) || !(distToPlayer <= distanceMouseOverPlayer)) continue;
            mouseOverPlayerName = playerName;
            mouseOverPlayerX = playerX;
            mouseOverPlayerY = playerY;
            distanceMouseOverPlayer = distToPlayer;
        }
        if (mouseOverPlayerName != null && !this.hasOverlay) {
            String playerNameFinal = mouseOverPlayerName;
            double playerXFinal = mouseOverPlayerX;
            double playerYFinal = mouseOverPlayerY;
            this.renderInFront(() -> {
                int strWidth = this.font.func_78256_a(playerNameFinal);
                this.font.getClass();
                int strHeight = 9;
                int rectX = (int)Math.round(playerXFinal);
                int rectY = (int)Math.round(playerYFinal);
                rectY += iconWidthHalf + 3;
                int border = 3;
                int rectWidth = strWidth + border * 2;
                rectX -= rectWidth / 2;
                int rectHeight = strHeight + border * 2;
                int mapBorder2 = 2;
                rectX = Math.max(rectX, mapXMin + mapBorder2);
                rectX = Math.min(rectX, mapXMax - mapBorder2 - rectWidth);
                rectY = Math.max(rectY, mapYMin + mapBorder2);
                rectY = Math.min(rectY, mapYMax - mapBorder2 - rectHeight);
                this.drawFancyRect(rectX, rectY, rectX + rectWidth, rectY + rectHeight);
                this.font.func_211126_b(playerNameFinal, (float)(rectX + border), (float)(rectY + border), 0xFFFFFF);
            });
        }
    }

    private double renderPlayerIconAndReturnDistance(GameProfile profile, double playerX, double playerY, int mouseX, int mouseY) {
        NetworkPlayerInfo playerInfo = this.minecraft.func_147114_u().func_175102_a(profile.getId());
        if (playerInfo != null && playerInfo.func_178856_e()) {
            ResourceLocation skin = playerInfo.func_178837_g();
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            int iconWidthHalf = 4;
            int iconBorder = iconWidthHalf + 1;
            playerX = Math.max((double)(mapXMin + iconBorder), playerX);
            playerX = Math.min((double)(mapXMax - iconBorder - 1), playerX);
            playerY = Math.max((double)(mapYMin + iconBorder), playerY);
            playerY = Math.min((double)(mapYMax - iconBorder - 1), playerY);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            this.minecraft.func_110434_K().func_110577_a(skin);
            float skinWidth = 64.0f;
            float skinHeight = 64.0f;
            float iconMinU = 8.0f / skinWidth;
            float iconMaxU = 16.0f / skinWidth;
            float iconMinV = 8.0f / skinHeight;
            float iconMaxV = 16.0f / skinHeight;
            double playerX_d = playerX + 0.5;
            double playerY_d = playerY + 0.5;
            int z = this.getBlitOffset();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_225582_a_(playerX_d - (double)iconWidthHalf, playerY_d + (double)iconWidthHalf, (double)z).func_225583_a_(iconMinU, iconMaxV).func_181675_d();
            buf.func_225582_a_(playerX_d + (double)iconWidthHalf, playerY_d + (double)iconWidthHalf, (double)z).func_225583_a_(iconMaxU, iconMaxV).func_181675_d();
            buf.func_225582_a_(playerX_d + (double)iconWidthHalf, playerY_d - (double)iconWidthHalf, (double)z).func_225583_a_(iconMaxU, iconMinV).func_181675_d();
            buf.func_225582_a_(playerX_d - (double)iconWidthHalf, playerY_d - (double)iconWidthHalf, (double)z).func_225583_a_(iconMinU, iconMinV).func_181675_d();
            tess.func_78381_a();
            iconMinU = 40.0f / skinWidth;
            iconMaxU = 48.0f / skinWidth;
            iconMinV = 8.0f / skinHeight;
            iconMaxV = 16.0f / skinHeight;
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_225582_a_(playerX_d - (double)iconWidthHalf - 0.5, playerY_d + (double)iconWidthHalf + 0.5, (double)z).func_225583_a_(iconMinU, iconMaxV).func_181675_d();
            buf.func_225582_a_(playerX_d + (double)iconWidthHalf + 0.5, playerY_d + (double)iconWidthHalf + 0.5, (double)z).func_225583_a_(iconMaxU, iconMaxV).func_181675_d();
            buf.func_225582_a_(playerX_d + (double)iconWidthHalf + 0.5, playerY_d - (double)iconWidthHalf - 0.5, (double)z).func_225583_a_(iconMaxU, iconMinV).func_181675_d();
            buf.func_225582_a_(playerX_d - (double)iconWidthHalf - 0.5, playerY_d - (double)iconWidthHalf - 0.5, (double)z).func_225583_a_(iconMinU, iconMinV).func_181675_d();
            tess.func_78381_a();
            RenderSystem.disableAlphaTest();
            double dx = playerX - (double)mouseX;
            double dy = playerY - (double)mouseY;
            double distToPlayer = Math.sqrt(dx * dx + dy * dy);
            return distToPlayer;
        }
        return Double.MAX_VALUE;
    }

    private void renderAreasOfInfluence(int mouseX, int mouseY) {
        List<AreaOfInfluence> areasOfInfluence;
        this.mouseInAreaOfInfluence = false;
        this.mouseInReducedAreaOfInfluence = false;
        Faction faction = this.areaOfInfluenceFaction;
        if (faction.getDimension() == LOTRDimensions.middleEarth() && !(areasOfInfluence = faction.getAreasOfInfluence().getAreas()).isEmpty()) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            this.setupMapClipping();
            RenderSystem.disableTexture();
            for (int pass = 0; pass <= 2; ++pass) {
                int areaRgb = 0xFF0000;
                if (pass == 1) {
                    areaRgb = 0x550000;
                }
                if (pass == 0) {
                    areaRgb = 0xFF5555;
                }
                Color areaColor = new Color(areaRgb);
                for (AreaOfInfluence area : areasOfInfluence) {
                    float rScaled;
                    double dy;
                    double[] coords;
                    double dx;
                    float radius = area.getMapRadius();
                    if (pass == 2) {
                        radius -= 1.0f;
                    }
                    if (pass == 0) {
                        radius = area.getMapRadius() + faction.getAreasOfInfluence().getReducedInfluenceRange();
                    }
                    float radiusWorld = this.loadedMapSettings.mapToWorldDistance(radius);
                    buf.func_181668_a(9, DefaultVertexFormats.field_181706_f);
                    int sides = 100;
                    for (int l = sides - 1; l >= 0; --l) {
                        float angle = (float)l / (float)sides * 2.0f * (float)Math.PI;
                        double x = area.getWorldX();
                        double z = area.getWorldZ();
                        double[] coords2 = this.transformWorldCoords(x += (double)(MathHelper.func_76134_b((float)angle) * radiusWorld), z += (double)(MathHelper.func_76126_a((float)angle) * radiusWorld));
                        buf.func_225582_a_(coords2[0], coords2[1], (double)this.getBlitOffset()).func_225586_a_(areaColor.getRed(), areaColor.getGreen(), areaColor.getBlue(), areaColor.getAlpha()).func_181675_d();
                    }
                    tess.func_78381_a();
                    if (this.mouseInAreaOfInfluence && this.mouseInReducedAreaOfInfluence || !((dx = (double)mouseX - (coords = this.transformWorldCoords(area.getWorldX(), area.getWorldZ()))[0]) * dx + (dy = (double)mouseY - coords[1]) * dy <= (double)((rScaled = radius * this.zoomScale) * rScaled))) continue;
                    if (pass >= 1) {
                        this.mouseInAreaOfInfluence = true;
                        continue;
                    }
                    if (pass != 0) continue;
                    this.mouseInReducedAreaOfInfluence = true;
                }
            }
            RenderSystem.enableTexture();
            this.endMapClipping();
        }
    }

    private void renderRoads() {
        if (!this.showMapWaypoints() && !this.showCustomWaypoints()) {
            return;
        }
        this.renderRoads(this.hasMapLabels());
    }

    public void renderRoads(boolean labels) {
        float roadZoomlerp = (this.zoomExp - -3.3f) / 2.2f;
        roadZoomlerp = Math.min(roadZoomlerp, 1.0f);
        if (!this.enableZoomOutWPFading) {
            roadZoomlerp = 1.0f;
        }
        if (roadZoomlerp > 0.0f) {
            float mapScale = this.loadedMapSettings.getScaleFactor();
            int interval = Math.round(mapScale * 3.125f / this.zoomScaleStable);
            interval = Math.max(interval, 1);
            for (Road road : this.loadedMapSettings.getRoads()) {
                for (RoadSection section : road.getSections()) {
                    GeneratedRoadPoint[] sectionPoints = section.getRoutePoints();
                    for (int pointIndex = 0; pointIndex < sectionPoints.length; pointIndex += interval) {
                        int clip;
                        GeneratedRoadPoint point = sectionPoints[pointIndex];
                        double[] pos = this.transformMapCoords(point.getMapX(), point.getMapZ());
                        double x = pos[0];
                        double y = pos[1];
                        if (x >= (double)mapXMin && x < (double)mapXMax && y >= (double)mapYMin && y < (double)mapYMax) {
                            double roadWidth = 1.0;
                            double roadWidthLess1 = roadWidth - 1.0;
                            double x0 = x - roadWidthLess1;
                            double x1 = x + roadWidth;
                            double y0 = y - roadWidthLess1;
                            double y1 = y + roadWidth;
                            float roadR = 0.0f;
                            float roadG = 0.0f;
                            float roadB = 0.0f;
                            float roadAlpha = roadZoomlerp;
                            double z = this.getBlitOffset();
                            RenderSystem.disableTexture();
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            Tessellator tess = Tessellator.func_178181_a();
                            BufferBuilder buf = tess.func_178180_c();
                            buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                            buf.func_225582_a_(x0, y1, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_225582_a_(x1, y1, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_225582_a_(x1, y0, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_225582_a_(x0, y0, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            tess.func_78381_a();
                            RenderSystem.disableBlend();
                            RenderSystem.enableTexture();
                        }
                        if (!labels || !(x >= (double)(mapXMin - (clip = 200))) || !(x <= (double)(mapXMax + clip)) || !(y >= (double)(mapYMin - clip)) || !(y <= (double)(mapYMax + clip))) continue;
                        float zoomlerp = (this.zoomExp - -1.0f) / 4.0f;
                        zoomlerp = Math.min(zoomlerp, 1.0f);
                        float roadNameScale = zoomlerp * 0.75f;
                        String name = road.getDisplayName().func_150254_d();
                        int roadNameWidth = this.font.func_78256_a(name);
                        int nameInterval = (int)((float)(roadNameWidth * 2 + 200) * mapScale * 0.78125f / this.zoomScaleStable);
                        if (pointIndex % nameInterval >= interval) continue;
                        boolean endNear = false;
                        for (RouteRoadPoint end : section.getStartAndEndPoints()) {
                            double endY;
                            double dy;
                            int endpointOverlapDistance = 10;
                            MapWaypoint endWp = end.getCorrespondingWaypoint();
                            if (endWp != null) {
                                String endWpName = endWp.getDisplayName().func_150254_d();
                                int endWpNameWidth = this.font.func_78256_a(endWpName);
                                endpointOverlapDistance = endWpNameWidth / 2 + 10;
                            }
                            double overlapWidth = (double)roadNameWidth / 2.0 * (double)roadNameScale + (double)endpointOverlapDistance;
                            double overlapWidthSq = overlapWidth * overlapWidth;
                            double[] endPos = this.transformMapCoords(end.getMapX(), end.getMapZ());
                            double endX = endPos[0];
                            double dx = x - endX;
                            double dSq = dx * dx + (dy = y - (endY = endPos[1])) * dy;
                            if (!(dSq < overlapWidthSq)) continue;
                            endNear = true;
                        }
                        if (endNear || !(zoomlerp > 0.0f)) continue;
                        this.setupMapClipping();
                        RenderSystem.pushMatrix();
                        RenderSystem.translated((double)x, (double)y, (double)0.0);
                        RenderSystem.scalef((float)roadNameScale, (float)roadNameScale, (float)roadNameScale);
                        GeneratedRoadPoint nextPoint = sectionPoints[Math.min(pointIndex + 1, sectionPoints.length - 1)];
                        GeneratedRoadPoint prevPoint = sectionPoints[Math.max(pointIndex - 1, 0)];
                        double grad = (nextPoint.getMapZ() - prevPoint.getMapZ()) / (nextPoint.getMapX() - prevPoint.getMapX());
                        float angle = (float)Math.atan(grad);
                        angle = (float)Math.toDegrees(angle);
                        if (Math.abs(angle) > 90.0f) {
                            angle += 180.0f;
                        }
                        RenderSystem.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                        float alpha = zoomlerp;
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        int strX = -roadNameWidth / 2;
                        int strY = -15;
                        this.font.func_211126_b(name, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha *= 0.8f));
                        this.font.func_211126_b(name, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                        RenderSystem.disableBlend();
                        RenderSystem.popMatrix();
                        this.endMapClipping();
                    }
                }
            }
        }
    }

    private void selectWaypoint(Waypoint wp) {
        this.selectedWaypoint = wp;
        this.waypointSelectTick = this.selectedWaypoint != null ? 6 : 0;
        this.prevWaypointSelectTick = this.waypointSelectTick;
    }

    private boolean isWaypointVisible(Waypoint wp) {
        if (wp.getDisplayState((PlayerEntity)this.minecraft.field_71439_g) == Waypoint.WaypointDisplayState.HIDDEN) {
            return false;
        }
        if (wp.isCustom()) {
            if (wp.isSharedCustom() && wp.isSharedHidden() && !this.showHiddenSharedCustomWaypoints()) {
                return false;
            }
            return this.showCustomWaypoints();
        }
        return this.showMapWaypoints();
    }

    private void renderWaypoints(int pass, int mouseX, int mouseY) {
        if (!(this.showMapWaypoints() || this.showCustomWaypoints() || this.showHiddenSharedCustomWaypoints())) {
            return;
        }
        this.renderWaypoints(pass, mouseX, mouseY, this.hasMapLabels());
    }

    private List<Waypoint> getAllDisplayedWaypoints() {
        Stream mapWps = this.loadedMapSettings.getWaypoints().stream();
        Stream customWps = this.minecraft.field_71439_g != null ? this.getClientPlayerData().getFastTravelData().getCustomWaypoints().stream() : Stream.empty();
        Stream adoptedCustomWps = this.minecraft.field_71439_g != null ? this.getClientPlayerData().getFastTravelData().getAdoptedCustomWaypoints().stream() : Stream.empty();
        return Streams.concat((Stream[])new Stream[]{mapWps, customWps, adoptedCustomWps}).filter(this::isWaypointVisible).collect(Collectors.toList());
    }

    public void renderWaypoints(int pass, int mouseX, int mouseY, boolean mapLabels) {
        this.renderWaypoints(this.getAllDisplayedWaypoints(), pass, mouseX, mouseY, mapLabels);
    }

    private void renderWaypoints(List<Waypoint> waypoints, int pass, int mouseX, int mouseY, boolean mapLabels) {
        this.setupMapClipping();
        Waypoint mouseOverWP = null;
        double distanceMouseOverWP = Double.MAX_VALUE;
        float wpZoomlerp = (this.zoomExp - -3.3f) / 2.2f;
        wpZoomlerp = Math.min(wpZoomlerp, 1.0f);
        if (!this.enableZoomOutWPFading) {
            wpZoomlerp = 1.0f;
        }
        if (wpZoomlerp > 0.0f) {
            for (Waypoint waypoint : waypoints) {
                double dy;
                double dx;
                double distToWP;
                double[] pos = this.transformWorldCoords(waypoint.getWorldX(), waypoint.getWorldZ());
                double x = pos[0];
                double y = pos[1];
                int clip = 200;
                if (!(x >= (double)(mapXMin - clip)) || !(x <= (double)(mapXMax + clip)) || !(y >= (double)(mapYMin - clip)) || !(y <= (double)(mapYMax + clip))) continue;
                if (pass == 0) {
                    float wpAlpha = wpZoomlerp;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    if (MiddleEarthMapScreen.isOSRS()) {
                        float osScale = 0.33f;
                        RenderSystem.pushMatrix();
                        RenderSystem.scalef((float)0.33f, (float)0.33f, (float)1.0f);
                        this.minecraft.func_110434_K().func_110577_a(MapImageTextures.OSRS_ICONS);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        LOTRClientUtil.blitFloat((AbstractGui)this, x / (double)0.33f - 8.0, y / (double)0.33f - 8.0, 0.0f, 0.0f, 15.0, 15.0);
                        RenderSystem.popMatrix();
                    } else {
                        Waypoint.WaypointDisplayState state = waypoint.getDisplayState((PlayerEntity)this.minecraft.field_71439_g);
                        this.minecraft.func_110434_K().func_110577_a(MAP_ICONS);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)wpAlpha);
                        LOTRClientUtil.blitFloat((AbstractGui)this, x - 2.0, y - 2.0, (float)state.iconU, (float)state.iconV, 4.0, 4.0);
                    }
                    RenderSystem.disableBlend();
                    if (mapLabels) {
                        float zoomlerp = (this.zoomExp - -1.0f) / 4.0f;
                        if ((zoomlerp = Math.min(zoomlerp, 1.0f)) > 0.0f) {
                            RenderSystem.pushMatrix();
                            RenderSystem.translated((double)x, (double)y, (double)0.0);
                            float scale = zoomlerp;
                            RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
                            float alpha = zoomlerp;
                            alpha *= 0.8f;
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            String s = waypoint.getDisplayName().func_150254_d();
                            int strX = -this.font.func_78256_a(s) / 2;
                            int strY = -15;
                            this.font.func_211126_b(s, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                            this.font.func_211126_b(s, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                            RenderSystem.disableBlend();
                            RenderSystem.popMatrix();
                        }
                    }
                }
                if (pass != 1 || waypoint == this.selectedWaypoint || !(x >= (double)(mapXMin - 2)) || !(x <= (double)(mapXMax + 2)) || !(y >= (double)(mapYMin - 2)) || !(y <= (double)(mapYMax + 2)) || !((distToWP = Math.sqrt((dx = x - (double)mouseX) * dx + (dy = y - (double)mouseY) * dy)) <= 5.0) || !(distToWP <= distanceMouseOverWP)) continue;
                mouseOverWP = waypoint;
                distanceMouseOverWP = distToWP;
            }
        }
        if (pass == 1 && mouseOverWP != null && !this.hasOverlay) {
            this.renderWaypointTooltip(mouseOverWP, false, mouseX, mouseY, 1.0f);
        }
        this.endMapClipping();
    }

    private void renderWaypointTooltip(Waypoint waypoint, boolean selected, int mouseX, int mouseY, float tick) {
        this.waypointTooltip.setMapDimensions(mapXMin, mapXMax, mapYMin, mapYMax);
        this.waypointTooltip.setSelectionProgress(this.prevWaypointSelectTick, this.waypointSelectTick, 6, tick);
        this.waypointTooltip.render(waypoint, selected, mouseX, mouseY, tick);
    }

    private void renderLabels() {
        if (!this.hasMapLabels()) {
            return;
        }
        this.setupMapClipping();
        List<MapLabel> labels = this.loadedMapSettings.getLabels();
        for (MapLabel label : labels) {
            double[] pos = this.transformMapCoords(label.getMapX(), label.getMapZ());
            double x = pos[0];
            double y = pos[1];
            float zoomlerp = (this.zoomExp - label.getMinZoom()) / (label.getMaxZoom() - label.getMinZoom());
            if (!(zoomlerp > 0.0f) || !(zoomlerp < 1.0f)) continue;
            float alpha = (0.5f - Math.abs(zoomlerp - 0.5f)) / 0.5f;
            alpha *= 0.7f;
            if (MiddleEarthMapScreen.isOSRS()) {
                if (alpha < 0.3f) continue;
                alpha = 1.0f;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)0.0);
            float labelScale = this.zoomScale * label.getScale();
            RenderSystem.scalef((float)labelScale, (float)labelScale, (float)labelScale);
            if (!MiddleEarthMapScreen.isOSRS()) {
                RenderSystem.rotatef((float)label.getAngle(), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            String labelName = label.getDisplayName().func_150254_d();
            int strX = -this.font.func_78256_a(labelName) / 2;
            this.font.getClass();
            int strY = -9 / 2;
            if (MiddleEarthMapScreen.isOSRS()) {
                if (label.getScale() > 2.5f) {
                    this.font.func_211126_b(labelName, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                    this.font.func_211126_b(labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFAA00, alpha));
                } else {
                    this.font.func_211126_b(labelName, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                    this.font.func_211126_b(labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                }
            } else {
                this.font.func_211126_b(labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            }
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
        this.endMapClipping();
    }

    private boolean hasMapLabels() {
        return (Boolean)LOTRConfig.CLIENT.mapLabels.get();
    }

    private void toggleMapLabels() {
        LOTRConfig.CLIENT.toggleMapLabels();
    }

    private void setupMapClipping() {
        double scale = this.minecraft.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)mapXMin * scale)), (int)((int)((double)(this.height - mapYMax) * scale)), (int)((int)((double)mapWidth * scale)), (int)((int)((double)mapHeight * scale)));
    }

    private void endMapClipping() {
        GL11.glDisable((int)3089);
    }

    public double[] transformWorldCoords(double x, double z) {
        x = this.loadedMapSettings.worldToMapX_frac(x);
        z = this.loadedMapSettings.worldToMapZ_frac(z);
        return this.transformMapCoords(x, z);
    }

    public double[] transformMapCoords(double x, double z) {
        x -= this.posX;
        z -= this.posY;
        x *= (double)this.zoomScale;
        z *= (double)this.zoomScale;
        return new double[]{x += (double)(mapXMin + mapWidth / 2), z += (double)(mapYMin + mapHeight / 2)};
    }

    public void drawFancyRect(int x1, int y1, int x2, int y2) {
        MiddleEarthMapScreen.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)-1073741824);
        this.hLine(x1 - 1, x2, y1 - 1, -6156032);
        this.hLine(x1 - 1, x2, y2, -6156032);
        this.vLine(x1 - 1, y1 - 1, y2, -6156032);
        this.vLine(x2, y1 - 1, y2, -6156032);
    }

    @Override
    public boolean keyPressed(int key, int scan, int param3) {
        if (!this.hasOverlay) {
            if (this.selectedWaypoint != null && LOTRKeyHandler.getFastTravelKey(this.minecraft).func_197976_a(key, scan) && this.isMiddleEarth()) {
                FastTravelDataModule ftData = this.getClientPlayerData().getFastTravelData();
                if (this.selectedWaypoint.hasPlayerUnlocked((PlayerEntity)this.minecraft.field_71439_g) && ftData.getTimeSinceFT() >= ftData.getWaypointFTTime(this.selectedWaypoint, (PlayerEntity)this.minecraft.field_71439_g)) {
                    CPacketFastTravel packet = new CPacketFastTravel(this.selectedWaypoint);
                    LOTRPacketHandler.sendToServer(packet);
                    this.minecraft.field_71439_g.func_71053_j();
                    return true;
                }
            }
            if (this.selectedWaypoint == null && LOTRKeyHandler.KEY_BIND_MAP_TELEPORT.func_197976_a(key, scan) && this.isMouseWithinMap && this.canTeleport()) {
                CPacketMapTp packet = new CPacketMapTp(this.mouseXCoord, this.mouseZCoord);
                LOTRPacketHandler.sendToServer(packet);
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
            if (this.hasAreasOfInfluence() && this.isEscapeOrInventoryKey(key, scan)) {
                this.minecraft.func_147108_a((Screen)new MiddleEarthFactionsScreen());
                return true;
            }
        }
        return super.keyPressed(key, scan, param3);
    }

    private void handleMapKeyboardMovement() {
        this.prevPosX += this.posXMove;
        this.prevPosY += this.posYMove;
        this.posXMove = 0.0;
        this.posYMove = 0.0;
        if (!this.hasOverlay) {
            float move = 12.0f / (float)Math.pow(this.zoomScale, 0.8f);
            if (this.isKeyboardKeyDown(this.minecraft.field_71474_y.field_74370_x.getKey().func_197937_c()) || this.isKeyboardKeyDown(263)) {
                this.posXMove -= (double)move;
            }
            if (this.isKeyboardKeyDown(this.minecraft.field_71474_y.field_74366_z.getKey().func_197937_c()) || this.isKeyboardKeyDown(262)) {
                this.posXMove += (double)move;
            }
            if (this.isKeyboardKeyDown(this.minecraft.field_71474_y.field_74351_w.getKey().func_197937_c()) || this.isKeyboardKeyDown(265)) {
                this.posYMove -= (double)move;
            }
            if (this.isKeyboardKeyDown(this.minecraft.field_71474_y.field_74368_y.getKey().func_197937_c()) || this.isKeyboardKeyDown(264)) {
                this.posYMove += (double)move;
            }
            if (this.posXMove != 0.0 || this.posYMove != 0.0) {
                this.selectWaypoint(null);
            }
        }
    }

    private boolean isKeyboardKeyDown(int glfwKey) {
        return InputMappings.func_216506_a((long)this.minecraft.func_228018_at_().func_198092_i(), (int)glfwKey);
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        if (super.mouseScrolled(x, y, scroll)) {
            return true;
        }
        if (!this.hasOverlay && this.zoomTicks == 0) {
            if (scroll < 0.0 && zoomPower > -3.0f) {
                this.zoomOut();
                return true;
            }
            if (scroll > 0.0 && zoomPower < 4.0f) {
                this.zoomIn();
                return true;
            }
        }
        return false;
    }

    private void zoomOut() {
        if (this.isFineZoom()) {
            this.setZoom(zoomPower - 0.25f);
        } else {
            this.setZoom(MathHelper.func_76123_f((float)(zoomPower - 1.0f)));
        }
    }

    private void zoomIn() {
        if (this.isFineZoom()) {
            this.setZoom(zoomPower + 0.25f);
        } else {
            this.setZoom(MathHelper.func_76141_d((float)(zoomPower + 1.0f)));
        }
    }

    private boolean isFineZoom() {
        return this.isKeyboardKeyDown(this.minecraft.field_71474_y.field_228046_af_.getKey().func_197937_c());
    }

    private void setZoom(float newZoomPower) {
        this.prevZoomPower = zoomPower;
        zoomPower = MathHelper.func_76131_a((float)newZoomPower, (float)-3.0f, (float)4.0f);
        this.zoomTicks = 6;
        this.prevZoomTicks = 6;
        this.zoomingMessageDisplayTicks = 30;
        this.zoomingMessageIsZoomIn = zoomPower > this.prevZoomPower;
        this.selectWaypoint(null);
    }

    private String getZoomingDisplayMessage() {
        int numLevels = 7;
        float currentRelativeLevel = zoomPower - -3.0f;
        return I18n.func_135052_a((String)(this.zoomingMessageIsZoomIn ? "gui.lotr.map.zoomingIn" : "gui.lotr.map.zoomingOut"), (Object[])new Object[]{ZOOM_DISPLAY_FORMAT.format(currentRelativeLevel), numLevels});
    }

    private boolean isMiddleEarth() {
        return this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_71093_bK == LOTRDimensions.middleEarth();
    }

    private boolean canTeleport() {
        if (!this.isMiddleEarth()) {
            return false;
        }
        if (!this.minecraft.field_71441_e.func_72863_F().func_217204_a((Entity)this.minecraft.field_71439_g)) {
            return false;
        }
        this.requestIsOp();
        return this.isPlayerOp;
    }

    private void requestIsOp() {
        if (!this.sentOpRequestPacket) {
            CPacketIsOpRequest packet = new CPacketIsOpRequest();
            LOTRPacketHandler.sendToServer(packet);
            this.sentOpRequestPacket = true;
        }
    }

    public void receiveIsOp(boolean isOp) {
        this.isPlayerOp = isOp;
    }

    public void setFakeMapProperties(double x, double y, float scale, float scaleExp, float scaleStable) {
        this.posX = x;
        this.posY = y;
        this.zoomScale = scale;
        this.zoomExp = scaleExp;
        this.zoomScaleStable = scaleStable;
        this.keepMapPositionWithinBounds();
    }

    public static StaticMapProperties setFakeStaticPropertiesAndSaveCurrent(int width, int height, int xMin, int xMax, int yMin, int yMax) {
        StaticMapProperties ret = new StaticMapProperties(mapWidth, mapHeight, mapXMin, mapXMax, mapYMin, mapYMax);
        mapWidth = width;
        mapHeight = height;
        mapXMin = xMin;
        mapXMax = xMax;
        mapYMin = yMin;
        mapYMax = yMax;
        return ret;
    }

    public static void restoreFakeStaticProperties(StaticMapProperties statics) {
        MiddleEarthMapScreen.setFakeStaticPropertiesAndSaveCurrent(statics.width, statics.height, statics.xMin, statics.xMax, statics.yMin, statics.yMax);
    }

    private static boolean isOSRS() {
        return false;
    }

    static {
        zoomPower = 0.0f;
        ZOOM_DISPLAY_FORMAT = new DecimalFormat("0.##");
    }

    public static class StaticMapProperties {
        public final int width;
        public final int height;
        public final int xMin;
        public final int xMax;
        public final int yMin;
        public final int yMax;

        public StaticMapProperties(int width, int height, int xMin, int xMax, int yMin, int yMax) {
            this.width = width;
            this.height = height;
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMin = yMin;
            this.yMax = yMax;
        }
    }

    public class MapDragListener
    implements IGuiEventListener {
        private boolean mouseDown;
        private double prevX;
        private double prevY;

        public boolean isMouseOver(double x, double y) {
            if (MiddleEarthMapScreen.this.isMouseWithinMap) {
                return !MiddleEarthMapScreen.this.hasOverlay && !MiddleEarthMapScreen.this.isFacScrolling;
            }
            return false;
        }

        public boolean mouseClicked(double x, double y, int code) {
            if (code == 0 && this.isMouseOver(x, y)) {
                this.mouseDown = true;
                MiddleEarthMapScreen.this.selectWaypoint(null);
                double distanceSelectedWP = Double.MAX_VALUE;
                List waypoints = MiddleEarthMapScreen.this.getAllDisplayedWaypoints();
                for (Waypoint waypoint : waypoints) {
                    double wpY;
                    double dy;
                    double[] pos = MiddleEarthMapScreen.this.transformWorldCoords(waypoint.getWorldX(), waypoint.getWorldZ());
                    double wpX = pos[0];
                    double dx = wpX - x;
                    double distToWP = Math.sqrt(dx * dx + (dy = (wpY = pos[1]) - y) * dy);
                    if (!(distToWP <= 5.0) || !(distToWP <= distanceSelectedWP)) continue;
                    MiddleEarthMapScreen.this.selectWaypoint(waypoint);
                    distanceSelectedWP = distToWP;
                }
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double x, double y, int code) {
            if (code == 0) {
                this.mouseDown = false;
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double x, double y, int code, double dx, double dy) {
            if (this.mouseDown && code == 0) {
                MiddleEarthMapScreen.this.posX = MiddleEarthMapScreen.this.posX - dx / (double)MiddleEarthMapScreen.this.zoomScale;
                MiddleEarthMapScreen.this.posY = MiddleEarthMapScreen.this.posY - dy / (double)MiddleEarthMapScreen.this.zoomScale;
                if (dx != 0.0 || dy != 0.0) {
                    MiddleEarthMapScreen.this.selectWaypoint(null);
                }
                this.prevX = x;
                this.prevY = y;
                return true;
            }
            return false;
        }
    }
}

