/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import java.util.ArrayList;
import lotr.client.gui.BasicIngameScreen;
import lotr.client.gui.MiddleEarthFactionsScreen;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.widget.button.MiddleEarthMenuButton;
import lotr.common.init.LOTRDimensions;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class MiddleEarthMasterMenuScreen
extends BasicIngameScreen {
    public static final ResourceLocation MENU_ICONS = new ResourceLocation("lotr", "textures/gui/menu_icons.png");
    public static Class<? extends MiddleEarthMenuScreen> lastMenuScreen = null;

    public MiddleEarthMasterMenuScreen() {
        super((ITextComponent)new StringTextComponent("MENU"));
    }

    public void init() {
        super.init();
        MiddleEarthMasterMenuScreen.resetLastMenuScreen();
        int midX = this.width / 2;
        int midY = this.height / 2;
        int buttonGap = 10;
        int buttonSize = 32;
        this.addButton((Widget)new MiddleEarthMenuButton(0, 0, MiddleEarthMapScreen.class, I18n.func_135052_a((String)"gui.lotr.menu.map", (Object[])new Object[0]), 3, 77));
        this.addButton((Widget)new MiddleEarthMenuButton(0, 0, MiddleEarthFactionsScreen.class, I18n.func_135052_a((String)"gui.lotr.menu.factions", (Object[])new Object[0]), 4, 70));
        this.addButton((Widget)new MiddleEarthMenuButton(0, 0, null, "?", 0, -1));
        ArrayList<MiddleEarthMenuButton> menuButtonsToArrange = new ArrayList<MiddleEarthMenuButton>();
        for (Widget widget : this.buttons) {
            if (!(widget instanceof MiddleEarthMenuButton)) continue;
            MiddleEarthMenuButton menuButton = (MiddleEarthMenuButton)widget;
            menuButton.active = menuButton.canDisplayMenu();
            menuButtonsToArrange.add(menuButton);
        }
        int numButtons = menuButtonsToArrange.size();
        int numTopRowButtons = (numButtons - 1) / 2 + 1;
        int numBtmRowButtons = numButtons - numTopRowButtons;
        int topRowLeft = midX - (numTopRowButtons * buttonSize + (numTopRowButtons - 1) * buttonGap) / 2;
        int btmRowLeft = midX - (numBtmRowButtons * buttonSize + (numBtmRowButtons - 1) * buttonGap) / 2;
        for (int l = 0; l < numButtons; ++l) {
            MiddleEarthMenuButton button = (MiddleEarthMenuButton)((Object)menuButtonsToArrange.get(l));
            if (l < numTopRowButtons) {
                button.x = topRowLeft + l * (buttonSize + buttonGap);
                button.y = midY - buttonGap / 2 - buttonSize;
                continue;
            }
            button.x = btmRowLeft + (l - numTopRowButtons) * (buttonSize + buttonGap);
            button.y = midY + buttonGap / 2;
        }
    }

    public static void resetLastMenuScreen() {
        lastMenuScreen = null;
    }

    public void render(int mouseX, int mouseY, float tick) {
        this.renderBackground();
        String dimensionName = LOTRDimensions.getDisplayName(LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.minecraft.field_71441_e)).func_150254_d();
        String title = I18n.func_135052_a((String)"gui.lotr.menu", (Object[])new Object[]{dimensionName});
        this.font.func_175063_a(title, (float)(this.width / 2 - this.font.func_78256_a(title) / 2), (float)(this.height / 2 - 80), 0xFFFFFF);
        super.render(mouseX, mouseY, tick);
        for (Widget widget : this.buttons) {
            MiddleEarthMenuButton menuButton;
            if (!(widget instanceof MiddleEarthMenuButton) || !(menuButton = (MiddleEarthMenuButton)widget).isHovered() || menuButton.getMessage() == null) continue;
            this.renderTooltip(menuButton.getMessage(), mouseX, mouseY);
        }
    }

    @Override
    public boolean keyPressed(int key, int scan, int param3) {
        for (Widget widget : this.buttons) {
            if (!(widget instanceof MiddleEarthMenuButton)) continue;
            MiddleEarthMenuButton menuButton = (MiddleEarthMenuButton)widget;
            if (!menuButton.visible || !menuButton.active || menuButton.menuKeyCode < 0 || key != menuButton.menuKeyCode) continue;
            menuButton.onPress();
            return true;
        }
        return super.keyPressed(key, scan, param3);
    }

    public static Screen openMenu(PlayerEntity player) {
        if (lastMenuScreen != null) {
            try {
                return lastMenuScreen.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new MiddleEarthMasterMenuScreen();
    }
}

