/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lotr.client.gui.AlignmentRenderer;
import lotr.client.gui.BasicIngameScreen;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.data.PlayerMessageType;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PlayerMessageScreen
extends BasicIngameScreen {
    private static final ResourceLocation MESSAGE_TEXTURE = new ResourceLocation("lotr", "textures/gui/message.png");
    private final PlayerMessageType messageType;
    private final boolean isCommandSent;
    private final String customText;
    private final int xSize = 240;
    private final int ySize = 160;
    private final int border = 12;
    private int guiLeft;
    private int guiTop;
    private Button buttonDismiss;
    private static final int TIME_UNTIL_DISMISS = 60;
    private int buttonTimer = 60;
    private final AlignmentRenderer alignmentRenderer = new AlignmentRenderer();

    public PlayerMessageScreen(PlayerMessageType type, boolean command, String custom) {
        super((ITextComponent)new StringTextComponent("MESSAGE"));
        this.messageType = type;
        this.isCommandSent = command;
        this.customText = custom;
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - 240) / 2;
        this.guiTop = (this.height - 160) / 2;
        this.buttonDismiss = (Button)this.addButton((Widget)new RedBookButton(this.guiLeft + 120 - 40, this.guiTop + 160 + 20, 80, 20, I18n.func_135052_a((String)"gui.lotr.message.dismiss", (Object[])new Object[0]), b -> this.minecraft.field_71439_g.func_71053_j()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonTimer > 0) {
            --this.buttonTimer;
        }
        this.buttonDismiss.active = this.buttonTimer == 0;
    }

    private String getFormattedMessageText() {
        if (this.customText != null) {
            return this.customText;
        }
        return this.messageType.getDisplayMessage().func_150254_d();
    }

    public void render(int mouseX, int mouseY, float f) {
        this.renderBackground();
        this.minecraft.func_110434_K().func_110577_a(MESSAGE_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.guiLeft, this.guiTop, 0, 0, 240, 160);
        String message = this.getFormattedMessageText();
        int pageWidth = 216;
        String[] splitNewline = message.split(Pattern.quote("\\n"));
        ArrayList messageLines = new ArrayList();
        for (String line : splitNewline) {
            messageLines.addAll(this.font.func_78271_c(line, pageWidth));
        }
        int x = this.guiLeft + 12;
        int y = this.guiTop + 12;
        for (String line : messageLines) {
            this.font.func_211126_b(line, (float)x, (float)y, 8019267);
            this.font.getClass();
            y += 9;
        }
        if (!this.isCommandSent) {
            String bottomText = I18n.func_135052_a((String)"gui.lotr.message.notDisplayedAgain", (Object[])new Object[0]);
            this.font.getClass();
            this.drawCenteredStringNoShadow(this.font, bottomText, this.guiLeft + 120, this.guiTop + 160 - 6 - 9, 9666921);
        }
        if (this.messageType == PlayerMessageType.ALIGN_DRAIN) {
            int numIcons = 3;
            int iconGap = 40;
            for (int l = 0; l < numIcons; ++l) {
                int iconX = this.guiLeft + 120;
                iconX -= (numIcons - 1) * iconGap / 2;
                int iconY = this.guiTop + 12 + 14;
                int numFactions = l + 1;
                this.alignmentRenderer.renderAlignmentDrain(this.minecraft, iconX += l * iconGap - 8, iconY, numFactions);
            }
        }
        super.render(mouseX, mouseY, f);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

