/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import lotr.client.gui.CustomWaypointScreen;
import lotr.client.gui.DestroyCustomWaypointScreen;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.network.CPacketUpdateCustomWaypoint;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.world.map.CustomWaypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class UpdateCustomWaypointScreen
extends CustomWaypointScreen {
    private final CustomWaypoint theWaypoint;
    private final String initialName;
    private final String initialLore;
    private final boolean initialIsPublic;
    private Button updateButton;
    private TextFieldWidget nameField;
    private TextFieldWidget loreField;
    private boolean isPublic;
    private Button publicButton;
    private Button destroyButton;

    public UpdateCustomWaypointScreen(CustomWaypoint wp) {
        super((ITextComponent)new StringTextComponent("CWP"));
        this.theWaypoint = wp;
        this.initialName = this.theWaypoint.getRawName();
        this.initialLore = this.theWaypoint.getRawLore();
        this.initialIsPublic = this.isPublic = this.theWaypoint.isPublic();
    }

    public void init() {
        super.init();
        this.updateButton = (Button)this.addButton((Widget)new RedBookButton(this.width / 2 - 100, this.height / 2 + 65, 97, 20, I18n.func_135052_a((String)"gui.lotr.cwp.update.do", (Object[])new Object[0]), b -> {
            LOTRPacketHandler.sendToServer(new CPacketUpdateCustomWaypoint(this.theWaypoint, this.nameField.func_146179_b(), this.loreField.func_146179_b(), this.isPublic));
            this.minecraft.field_71439_g.func_71053_j();
        }));
        this.updateButton.active = false;
        this.nameField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 2 - 40, 200, 20, "");
        this.nameField.func_146203_f(40);
        this.nameField.func_146180_a(this.initialName);
        this.addTextFieldAndSetFocused(this.nameField);
        this.loreField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 2, 200, 20, "");
        this.loreField.func_146203_f(160);
        this.loreField.func_146180_a(this.initialLore);
        this.addTextField(this.loreField);
        this.nameField.func_212954_a(text -> this.checkChangesForUpdate());
        this.loreField.func_212954_a(text -> this.checkChangesForUpdate());
        this.checkChangesForUpdate();
        this.publicButton = (Button)this.addButton((Widget)new RedBookButton(this.width / 2 - 30, this.height / 2 + 30, 60, 20, I18n.func_135052_a((String)"gui.lotr.cwp.create.public.no", (Object[])new Object[0]), b -> {
            this.isPublic = !this.isPublic;
            this.checkChangesForUpdate();
        }));
        if (this.initialIsPublic) {
            this.publicButton.active = false;
        }
        this.updatePublicButton();
        this.destroyButton = (Button)this.addButton((Widget)new RedBookButton(this.width / 2 + 4, this.height / 2 + 65, 97, 20, I18n.func_135052_a((String)"gui.lotr.cwp.update.destroy", (Object[])new Object[0]), b -> this.minecraft.func_147108_a((Screen)new DestroyCustomWaypointScreen(this, this.theWaypoint))));
    }

    private void checkChangesForUpdate() {
        boolean anyChanges;
        this.updateButton.active = anyChanges = !this.nameField.func_146179_b().trim().equals(this.initialName.trim()) || !this.loreField.func_146179_b().trim().equals(this.initialLore.trim()) || this.isPublic != this.initialIsPublic;
    }

    public void resize(Minecraft mc, int w, int h) {
        String name = this.nameField.func_146179_b();
        String lore = this.loreField.func_146179_b();
        super.resize(mc, w, h);
        this.nameField.func_146180_a(name);
        this.loreField.func_146180_a(lore);
    }

    @Override
    public void tick() {
        super.tick();
        this.nameField.func_146178_a();
        this.loreField.func_146178_a();
        this.updatePublicButton();
    }

    private void updatePublicButton() {
        this.publicButton.setMessage(this.isPublic ? I18n.func_135052_a((String)"gui.lotr.cwp.create.public.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.lotr.cwp.create.public.no", (Object[])new Object[0]));
        this.publicButton.setFGColor(this.isPublic ? 0xFF0000 : 8019267);
    }

    public void render(int mouseX, int mouseY, float f) {
        this.renderBackground();
        String title = I18n.func_135052_a((String)"gui.lotr.cwp.update.title", (Object[])new Object[0]);
        this.drawCenteredString(this.font, title, this.width / 2, this.height / 2 - 90, 0xFFFFFF);
        this.nameField.render(mouseX, mouseY, f);
        String nameFieldLabel = I18n.func_135052_a((String)"gui.lotr.cwp.update.name", (Object[])new Object[0]);
        float f2 = this.nameField.x;
        int n = this.nameField.y;
        this.font.getClass();
        this.font.func_211126_b(nameFieldLabel, f2, (float)(n - 9 - 3), 0xFFFFFF);
        this.loreField.render(mouseX, mouseY, f);
        String loreFieldLabel = I18n.func_135052_a((String)"gui.lotr.cwp.update.lore", (Object[])new Object[0]);
        float f3 = this.loreField.x;
        int n2 = this.loreField.y;
        this.font.getClass();
        this.font.func_211126_b(loreFieldLabel, f3, (float)(n2 - 9 - 3), 0xFFFFFF);
        String publicLabel = I18n.func_135052_a((String)"gui.lotr.cwp.create.public", (Object[])new Object[0]);
        float f4 = this.publicButton.x - 4 - this.font.func_78256_a(publicLabel);
        int n3 = this.publicButton.y + this.publicButton.getHeight() / 2;
        this.font.getClass();
        this.font.func_211126_b(publicLabel, f4, (float)(n3 - 9 / 2), 0xFFFFFF);
        super.render(mouseX, mouseY, f);
        this.renderPublicButtonTooltip(this.publicButton, mouseX, mouseY);
    }
}

