/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.List;
import lotr.client.LOTRClientUtil;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRWorldTypes;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class WorldTypeHelpScreen
extends Screen {
    private static final int DISPLAY_WIDTH = 320;
    private static final int DISPLAY_HEIGHT = 200;
    private static final int WORLD_TYPE_BUTTON_Y = 70;
    private final CreateWorldScreen parentScreen;
    private Button buttonNormalWorld;
    private Button buttonMiddleEarthWorld;
    private Button buttonDismiss;
    private WorldType selectedWorldType = null;
    private int selectionCloseScreenTimer;
    private static final int SELECTION_CLOSE_SCREEN_TIME = 100;
    private static final int SELECTION_CLOSE_SCREEN_FADEOUT_TIME = 20;

    public WorldTypeHelpScreen(CreateWorldScreen parent) {
        super((ITextComponent)new StringTextComponent("WORLD_TYPE_HELP"));
        this.parentScreen = parent;
    }

    public void init() {
        super.init();
        int xMid = this.width / 2;
        int yMid = this.height / 2;
        int yTop = yMid - 100;
        int yBottom = yMid + 100;
        int buttonW = 150;
        int buttonH = 20;
        int buttonY = yTop + 70;
        this.buttonNormalWorld = (Button)this.addButton((Widget)new Button(xMid - 155, buttonY, buttonW, buttonH, this.getSelectWorldTypeDisplayString(WorldType.field_77137_b), b -> this.selectWorldType(b, WorldType.field_77137_b)));
        this.buttonMiddleEarthWorld = (Button)this.addButton((Widget)new Button(xMid + 5, buttonY, buttonW, buttonH, this.getSelectWorldTypeDisplayString(LOTRWorldTypes.MIDDLE_EARTH), b -> this.selectWorldType(b, LOTRWorldTypes.MIDDLE_EARTH)));
        this.buttonDismiss = (Button)this.addButton((Widget)new Button(xMid - 75, yBottom - 10, buttonW, buttonH, I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.dismiss", (Object[])new Object[0]), b -> this.onClose()));
    }

    private String getSelectWorldTypeDisplayString(WorldType worldType) {
        return I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0]) + ' ' + this.getWorldTypeDisplayName(worldType);
    }

    private String getWorldTypeDisplayName(WorldType worldType) {
        return I18n.func_135052_a((String)worldType.func_77128_b(), (Object[])new Object[0]);
    }

    private void selectWorldType(Button selectedButton, WorldType worldType) {
        if (this.selectedWorldType == null) {
            this.selectedWorldType = worldType;
            try {
                Field f_worldTypeIndex = ObfuscationReflectionHelper.findField(CreateWorldScreen.class, (String)"field_146331_K");
                f_worldTypeIndex.set(this.parentScreen, this.selectedWorldType.func_82747_f());
            }
            catch (Exception e) {
                LOTRLog.error("Error setting world type in world creation screen");
                e.printStackTrace();
            }
            this.selectionCloseScreenTimer = 100;
            selectedButton.x = this.width / 2 - selectedButton.getWidth() / 2;
            this.deactivateButtonIfNotSelected(this.buttonNormalWorld, selectedButton);
            this.deactivateButtonIfNotSelected(this.buttonMiddleEarthWorld, selectedButton);
        }
    }

    private void deactivateButtonIfNotSelected(Button button, Button selectedButton) {
        if (button != selectedButton) {
            button.active = false;
            button.visible = false;
        }
    }

    public void onClose() {
        LOTRConfig.CLIENT.showWorldTypeHelp.setAndSave(false);
        this.minecraft.func_147108_a((Screen)this.parentScreen);
    }

    public void tick() {
        super.tick();
        if (this.selectionCloseScreenTimer > 0) {
            --this.selectionCloseScreenTimer;
            if (this.selectionCloseScreenTimer <= 0) {
                this.onClose();
            }
        }
    }

    private float getFadeoutAlpha() {
        if (this.selectedWorldType == null) {
            return 1.0f;
        }
        float f = (float)this.selectionCloseScreenTimer / 20.0f;
        return MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
    }

    public void render(int mouseX, int mouseY, float f) {
        int xMid = this.width / 2;
        int yMid = this.height / 2;
        int x0 = xMid - 160;
        int x1 = xMid + 160;
        int y0 = yMid - 100;
        int y1 = yMid + 100;
        float alpha = this.getFadeoutAlpha();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-100.0f);
        this.parentScreen.render(-1000, -1000, f);
        RenderSystem.popMatrix();
        WorldTypeHelpScreen.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)LOTRClientUtil.getRGBA(0x101010, alpha * 0.75f));
        int border = 1;
        WorldTypeHelpScreen.fill((int)x0, (int)y0, (int)x1, (int)y1, (int)LOTRClientUtil.getRGBA(0, alpha));
        this.hLine(x0 - border, x1 + border, y0 - border, LOTRClientUtil.getRGBA(0xFFFFFF, alpha));
        this.hLine(x0 - border, x1 + border, y1 + border, LOTRClientUtil.getRGBA(0xFFFFFF, alpha));
        this.vLine(x0 - border, y0 - border, y1 + border, LOTRClientUtil.getRGBA(0xFFFFFF, alpha));
        this.vLine(x1 + border, y0 - border, y1 + border, LOTRClientUtil.getRGBA(0xFFFFFF, alpha));
        int fontBorder = 6;
        int maxFontWidth = 320 - fontBorder * 2;
        String title = I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.title", (Object[])new Object[0]);
        List titleLines = this.font.func_78271_c(title, maxFontWidth);
        int y = y0 + fontBorder;
        for (String line : titleLines) {
            this.font.func_211126_b(line, (float)(xMid - this.font.func_78256_a(line) / 2), (float)y, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            this.font.getClass();
            y += 9;
        }
        if (this.selectedWorldType == null) {
            this.renderTextBelowButton(this.buttonNormalWorld, I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.normal", (Object[])new Object[]{this.getWorldTypeDisplayName(WorldType.field_77137_b)}), alpha);
            this.renderTextBelowButton(this.buttonMiddleEarthWorld, I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.me", (Object[])new Object[]{this.getWorldTypeDisplayName(LOTRWorldTypes.MIDDLE_EARTH)}), alpha);
        } else {
            this.font.getClass();
            y = y0 + 70 + 20 + 9;
            String line1 = I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.selected.1", (Object[])new Object[]{this.getWorldTypeDisplayName(this.selectedWorldType)});
            String line2 = I18n.func_135052_a((String)"gui.lotr.worldTypeHelp.selected.2", (Object[])new Object[]{I18n.func_135052_a((String)"selectWorld.moreWorldOptions", (Object[])new Object[0])});
            this.font.func_211126_b(line1, (float)(xMid - this.font.func_78256_a(line1) / 2), (float)y, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            float f2 = xMid - this.font.func_78256_a(line2) / 2;
            this.font.getClass();
            this.font.func_211126_b(line2, f2, (float)(y + 9 * 2), LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
        }
        this.renderItemIconAboveButton(this.buttonNormalWorld, new ItemStack((IItemProvider)LOTRItems.GOLD_RING.get()), -10, 0, alpha);
        this.renderItemIconAboveButton(this.buttonNormalWorld, new ItemStack((IItemProvider)Items.field_151033_d), 10, 0, alpha);
        this.renderItemIconAboveButton(this.buttonMiddleEarthWorld, new ItemStack((IItemProvider)LOTRItems.RED_BOOK.get()), 0, 0, alpha);
        this.buttons.forEach(button -> button.setAlpha(alpha));
        super.render(mouseX, mouseY, f);
    }

    private void renderTextBelowButton(Button button, String text, float alpha) {
        int buttonBorder = 4;
        if (button.visible) {
            List belowLines = this.font.func_78271_c(text, button.getWidth());
            int y = button.y + button.getHeight() + buttonBorder;
            for (String line : belowLines) {
                this.font.func_211126_b(line, (float)button.x, (float)y, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                this.font.getClass();
                y += 9;
            }
        }
    }

    private void renderItemIconAboveButton(Button button, ItemStack icon, int xOffset, int yOffset, float alpha) {
        if (button.visible && alpha >= 1.0f) {
            int x = button.x + button.getWidth() / 2 + xOffset;
            int y = button.y - 19 + yOffset;
            this.itemRenderer.func_175042_a(icon, x -= 8, y);
        }
    }
}

