/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.widget.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lotr.client.gui.AlignmentRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;

public class PledgeButton
extends Button {
    private final Screen parentScreen;
    private boolean isBroken;
    private List<String> tooltipLines = new ArrayList<String>();

    public PledgeButton(Screen parent, int xIn, int yIn, boolean broken, Button.IPressable onPressIn) {
        super(xIn, yIn, 32, 32, "", onPressIn);
        this.parentScreen = parent;
        this.isBroken = broken;
    }

    public void setDisplayAsBroken(boolean flag) {
        this.isBroken = flag;
    }

    public void setTooltipLines(String ... lines) {
        if (lines == null) {
            lines = new String[]{};
        }
        this.tooltipLines = Arrays.asList(lines);
    }

    public void renderButton(int mouseX, int mouseY, float f) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fr = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(AlignmentRenderer.ALIGNMENT_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int yOffset = this.getYImage(this.isHovered());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.blit(this.x, this.y, 0 + yOffset * this.width, 180, this.width, this.height);
        this.renderBg(minecraft, mouseX, mouseY);
        if (!this.tooltipLines.isEmpty() && this.isHovered()) {
            this.parentScreen.renderTooltip(this.tooltipLines, mouseX, mouseY);
        }
    }

    protected int getYImage(boolean hovered) {
        if (this.isBroken) {
            return hovered ? 4 : 3;
        }
        if (!this.active) {
            return 0;
        }
        return hovered ? 2 : 1;
    }
}

