/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.widget.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import lotr.client.gui.MiddleEarthFactionsScreen;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.RankGender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;

public class PreferredRankGenderButton
extends Button {
    private final RankGender rankGender;

    public PreferredRankGenderButton(int xIn, int yIn, RankGender gender, Button.IPressable onPress) {
        super(xIn, yIn, 12, 12, "", onPress);
        this.rankGender = gender;
    }

    private static LOTRPlayerData getClientPlayerData() {
        Minecraft mc = Minecraft.func_71410_x();
        return LOTRLevelData.clientInstance().getData((PlayerEntity)mc.field_71439_g);
    }

    public static void sendPreferenceToServer(Button button) {
        PreferredRankGenderButton thisButton = (PreferredRankGenderButton)button;
        PreferredRankGenderButton.getClientPlayerData().getMiscData().setPreferredRankGenderAndSendToServer(thisButton.rankGender);
    }

    public void renderButton(int mouseX, int mouseY, float f) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(MiddleEarthFactionsScreen.FACTIONS_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int uMin = 60 + this.rankGender.ordinal() * this.width;
        int yOffset = this.getYImage(this.isHovered());
        this.blit(this.x, this.y, uMin, 142 + yOffset * this.height, this.width, this.height);
        this.renderBg(mc, mouseX, mouseY);
    }

    protected int getYImage(boolean hovered) {
        return hovered ? 2 : (this.isCurrentlyPreferredGender() ? 1 : 0);
    }

    private boolean isCurrentlyPreferredGender() {
        return PreferredRankGenderButton.getClientPlayerData().getMiscData().getPreferredRankGender() == this.rankGender;
    }
}

