/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import java.awt.Color;
import lotr.common.LOTRLog;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.WaterLatitudeSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class GeographicalWaterColors {
    private static final Color waterColorNorth = new Color(602979);
    private static final Color waterColorSouth = new Color(4973293);
    private static double lastViewerPosX;
    private static double lastViewerPosZ;

    public static int getGeographicalWaterColorAtViewerPosition(Minecraft mc) {
        Entity viewer = mc.field_175622_Z;
        if (viewer != null) {
            lastViewerPosX = viewer.func_226277_ct_();
            lastViewerPosZ = viewer.func_226281_cx_();
        }
        return GeographicalWaterColors.calcGeographicalWaterColor(mc, lastViewerPosX, lastViewerPosZ);
    }

    private static int calcGeographicalWaterColor(Minecraft mc, double x, double z) {
        MapSettings loadedMapSettings = MapSettingsManager.clientInstance().getLoadedMapOrLoadDefault(mc.func_195551_G());
        if (loadedMapSettings == null) {
            LOTRLog.error("No MapSettings instance is loaded on the client! This should not happen and is very bad!");
        }
        WaterLatitudeSettings waterLatitudes = loadedMapSettings.getWaterLatitudes();
        int northZ = waterLatitudes.getNorthLimitZ_world();
        int southZ = waterLatitudes.getSouthLimitZ_world();
        boolean min = false;
        int max = southZ - northZ;
        float latitude = MathHelper.func_76131_a((float)((float)z - (float)northZ), (float)((float)min), (float)max) / (float)max;
        float[] northColors = waterColorNorth.getColorComponents(null);
        float[] southColors = waterColorSouth.getColorComponents(null);
        float dR = southColors[0] - northColors[0];
        float dG = southColors[1] - northColors[1];
        float dB = southColors[2] - northColors[2];
        float r = dR * latitude;
        float g = dG * latitude;
        float b = dB * latitude;
        Color water = new Color(r += northColors[0], g += northColors[1], b += northColors[2]);
        int waterRGB = water.getRGB();
        return waterRGB;
    }

    public static void setupAndReplace() {
    }
}

