/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import com.google.common.math.IntMath;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import lotr.client.render.ProjectionUtil;
import lotr.common.LOTRMod;
import lotr.common.config.LOTRConfig;
import lotr.common.dim.LOTRDimension;
import lotr.common.time.LOTRDate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.CloudRenderHandler;

public class MiddleEarthCloudRenderer
implements CloudRenderHandler {
    private static final ResourceLocation CLOUD_TEXTURE = new ResourceLocation("lotr", "textures/sky/clouds.png");
    private static final Random CLOUD_RNG = new Random(81747493362629326L);
    private final CloudProperty cloudOpacitySeed = new CloudProperty(233591206262L, 0.0f, 1.0f, 0.1f);
    private final CloudProperty cloudSpeed = new CloudProperty(6283905602629L, 0.0f, 0.5f, 0.001f);
    private final CloudProperty cloudAngle = new CloudProperty(360360635650636L, 0.0f, (float)Math.PI * 2, 0.01f);
    private double cloudPosXPre;
    private double cloudPosX;
    private double cloudPosZPre;
    private double cloudPosZ;
    private final LOTRDimension dimension;

    public MiddleEarthCloudRenderer(LOTRDimension dim) {
        this.dimension = dim;
    }

    public void updateClouds(World world) {
        this.cloudOpacitySeed.update(world);
        this.cloudSpeed.update(world);
        this.cloudAngle.update(world);
        float angle = this.cloudAngle.getValue(1.0f);
        float speed = this.cloudSpeed.getValue(1.0f);
        this.cloudPosXPre = this.cloudPosX;
        this.cloudPosX += (double)(MathHelper.func_76134_b((float)angle) * speed);
        this.cloudPosZPre = this.cloudPosZ;
        this.cloudPosZ += (double)(MathHelper.func_76126_a((float)angle) * speed);
    }

    public void resetClouds() {
        this.cloudOpacitySeed.reset();
        this.cloudSpeed.reset();
        this.cloudAngle.reset();
    }

    public void render(int ticks, float partialTicks, MatrixStack matStack, ClientWorld world, Minecraft mc) {
        BlockPos viewPos;
        float cloudOpacity;
        world.func_217381_Z().func_76320_a("lotrClouds");
        if (world.func_201675_m().func_76569_d() && (cloudOpacity = this.getCloudOpacity(world, viewPos = mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks)) > 0.0f) {
            int cloudRange = (Integer)LOTRConfig.CLIENT.cloudRange.get();
            Matrix4f projectMatrix = ProjectionUtil.getProjection(mc, partialTicks, cloudRange);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.multMatrix((Matrix4f)projectMatrix);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            matStack.func_227860_a_();
            RenderSystem.multMatrix((Matrix4f)matStack.func_227866_c_().func_227870_a_());
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.fogMode((int)9729);
            RenderSystem.fogStart((float)((float)cloudRange * 0.9f));
            RenderSystem.fogEnd((float)cloudRange);
            RenderSystem.setupNvFogDistance();
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            mc.func_110434_K().func_110577_a(CLOUD_TEXTURE);
            Vec3d cloudColor = this.getCloudColor(world, viewPos, partialTicks);
            float r = (float)cloudColor.field_72450_a;
            float g = (float)cloudColor.field_72448_b;
            float b = (float)cloudColor.field_72449_c;
            Vec3d pos = mc.field_71460_t.func_215316_n().func_216785_c();
            for (int pass = 0; pass < 2; ++pass) {
                float alpha = (0.8f - (float)pass * 0.5f) * cloudOpacity;
                if (!((alpha *= 1.0f - LOTRMod.proxy.getCurrentSandstormFogStrength()) > 0.0f)) continue;
                int scale = 4096 * IntMath.pow((int)2, (int)pass);
                double invScaleD = 1.0 / (double)scale;
                double posX = pos.field_72450_a;
                double posY = pos.field_72448_b;
                double posZ = pos.field_72449_c;
                double cloudPosXAdd = this.cloudPosXPre + (this.cloudPosX - this.cloudPosXPre) * (double)partialTicks;
                double cloudPosZAdd = this.cloudPosZPre + (this.cloudPosZ - this.cloudPosZPre) * (double)partialTicks;
                int x = MathHelper.func_76128_c((double)((posX += (cloudPosXAdd /= (double)(pass + 1))) / (double)scale));
                int z = MathHelper.func_76128_c((double)((posZ += (cloudPosZAdd /= (double)(pass + 1))) / (double)scale));
                double cloudX = posX - (double)(x * scale);
                double cloudZ = posZ - (double)(z * scale);
                float cloudY = world.func_201675_m().func_76571_f() - (float)posY + 0.33f + (float)pass * 50.0f;
                buf.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                int interval = cloudRange;
                for (int i = -cloudRange; i < cloudRange; i += interval) {
                    for (int k = -cloudRange; k < cloudRange; k += interval) {
                        int xMin = i + 0;
                        int xMax = i + interval;
                        int zMin = k + 0;
                        int zMax = k + interval;
                        float uMin = (float)(((double)xMin + cloudX) * invScaleD);
                        float uMax = (float)(((double)xMax + cloudX) * invScaleD);
                        float vMin = (float)(((double)zMin + cloudZ) * invScaleD);
                        float vMax = (float)(((double)zMax + cloudZ) * invScaleD);
                        buf.func_225582_a_((double)xMin, (double)cloudY, (double)zMax).func_227885_a_(r, g, b, alpha).func_225583_a_(uMin, vMax).func_181675_d();
                        buf.func_225582_a_((double)xMax, (double)cloudY, (double)zMax).func_227885_a_(r, g, b, alpha).func_225583_a_(uMax, vMax).func_181675_d();
                        buf.func_225582_a_((double)xMax, (double)cloudY, (double)zMin).func_227885_a_(r, g, b, alpha).func_225583_a_(uMax, vMin).func_181675_d();
                        buf.func_225582_a_((double)xMin, (double)cloudY, (double)zMin).func_227885_a_(r, g, b, alpha).func_225583_a_(uMin, vMin).func_181675_d();
                    }
                }
                tess.func_78381_a();
            }
            FogRenderer.func_228370_a_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableBlend();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            matStack.func_227865_b_();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
        }
        world.func_217381_Z().func_76319_b();
    }

    private Vec3d getCloudColor(ClientWorld world, BlockPos viewPos, float partialTicks) {
        if (world.func_201675_m() instanceof LOTRDimension) {
            LOTRDimension dim = (LOTRDimension)world.func_201675_m();
            return dim.getBlendedCompleteCloudColor(viewPos, partialTicks);
        }
        return world.func_228328_h_(partialTicks);
    }

    private float getCloudOpacity(ClientWorld world, BlockPos viewPos, float partialTicks) {
        float coverageHere;
        float opacitySeed = this.cloudOpacitySeed.getValue(partialTicks);
        if (world.func_201675_m() instanceof LOTRDimension) {
            LOTRDimension dim = (LOTRDimension)world.func_201675_m();
            coverageHere = dim.getCloudCoverage(viewPos, partialTicks);
        } else {
            coverageHere = 1.0f;
        }
        float maxOpacityAtFullCoverage = 1.0f;
        float maxOpacity = MathHelper.func_219799_g((float)coverageHere, (float)0.5f, (float)maxOpacityAtFullCoverage);
        float minOpacityAtFullCoverage = 0.2f;
        float x0 = 0.0f;
        float x1 = 1.0f;
        float dx = x1 - x0;
        float gradientAtFullCoverage = (maxOpacityAtFullCoverage - minOpacityAtFullCoverage) / dx;
        float yInterceptAtFullCoverage = minOpacityAtFullCoverage;
        float xInterceptAtFullCoverage = -yInterceptAtFullCoverage / gradientAtFullCoverage;
        float xInterceptAtNoCoverage = x1;
        float xIntercept = MathHelper.func_219799_g((float)coverageHere, (float)xInterceptAtNoCoverage, (float)xInterceptAtFullCoverage);
        float gradient = (maxOpacity - 0.0f) / Math.max(1.0f - xIntercept, 1.0E-7f);
        float opacity = gradient * (opacitySeed - xIntercept);
        return Math.max(opacity, 0.0f);
    }

    private class CloudProperty {
        private final long baseSeed;
        private float currentDayValue;
        private float value;
        private float prevValue;
        private final float minValue;
        private final float maxValue;
        private final float interval;

        public CloudProperty(long l, float min, float max, float i) {
            this.baseSeed = l;
            this.value = -1.0f;
            this.minValue = min;
            this.maxValue = max;
            this.interval = i;
        }

        public void reset() {
            this.value = -1.0f;
        }

        public float getValue(float f) {
            return this.prevValue + (this.value - this.prevValue) * f;
        }

        public void update(World world) {
            this.currentDayValue = this.getCurrentDayValue(world);
            if (this.value == -1.0f) {
                this.prevValue = this.value = this.currentDayValue;
            } else {
                this.prevValue = this.value;
                if (this.value > this.currentDayValue) {
                    this.value -= this.interval;
                    this.value = Math.max(this.value, this.currentDayValue);
                } else if (this.value < this.currentDayValue) {
                    this.value += this.interval;
                    this.value = Math.min(this.value, this.currentDayValue);
                }
            }
        }

        private float getCurrentDayValue(World world) {
            int day = LOTRDate.ShireReckoning.currentDay;
            long seed = (long)day * this.baseSeed + (long)day + 83025820626792L;
            CLOUD_RNG.setSeed(seed);
            float f = MathHelper.func_151240_a((Random)CLOUD_RNG, (float)this.minValue, (float)this.maxValue);
            return f;
        }
    }
}

