/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import lotr.client.render.RandomTextureVariants;
import lotr.common.dim.LOTRDimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.client.SkyRenderHandler;

public class MiddleEarthSkyRenderer
implements SkyRenderHandler {
    private static final ResourceLocation SUN_TEXTURE = new ResourceLocation("lotr", "textures/sky/sun.png");
    private static final ResourceLocation MOON_TEXTURE = new ResourceLocation("lotr", "textures/sky/moon.png");
    private static final ResourceLocation EARENDIL_TEXTURE = new ResourceLocation("lotr", "textures/sky/earendil.png");
    private RandomTextureVariants skyTextures;
    private ResourceLocation currentSkyTexture;
    private final LOTRDimension dimension;
    private final VertexFormat skyVertexFormat = DefaultVertexFormats.field_181705_e;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;

    public MiddleEarthSkyRenderer(LOTRDimension dim) {
        this.dimension = dim;
        this.skyTextures = RandomTextureVariants.loadSkinsList("lotr", "textures/sky/night");
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        this.skyVBO = new VertexBuffer(this.skyVertexFormat);
        this.preRenderSky(buf, 16.0f, false);
        this.skyVBO.func_227875_a_(buf);
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.sky2VBO = new VertexBuffer(this.skyVertexFormat);
        this.preRenderSky(buf, -16.0f, true);
        this.sky2VBO.func_227875_a_(buf);
    }

    private void preRenderSky(BufferBuilder buf, float posY, boolean reverseX) {
        int i = 64;
        int j = 6;
        buf.func_181668_a(7, this.skyVertexFormat);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                buf.func_225582_a_((double)f, (double)posY, (double)l).func_181675_d();
                buf.func_225582_a_((double)f1, (double)posY, (double)l).func_181675_d();
                buf.func_225582_a_((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                buf.func_225582_a_((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
        buf.func_178977_d();
    }

    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc) {
        if (this.skyVBO == null) {
            this.generateSky();
        }
        if (this.sky2VBO == null) {
            this.generateSky2();
        }
        TextureManager texMgr = mc.func_110434_K();
        long worldTime = world.func_72820_D();
        if (this.dimension.func_76569_d()) {
            RenderSystem.disableTexture();
            ActiveRenderInfo ari = mc.field_71460_t.func_215316_n();
            Vec3d skyColor = this.dimension.getBlendedCompleteSkyColor(ari.func_216780_d(), partialTicks);
            float skyR = (float)skyColor.field_72450_a;
            float skyG = (float)skyColor.field_72448_b;
            float skyB = (float)skyColor.field_72449_c;
            FogRenderer.func_228373_b_();
            BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableFog();
            RenderSystem.color3f((float)skyR, (float)skyG, (float)skyB);
            this.skyVBO.func_177359_a();
            this.skyVertexFormat.func_227892_a_(0L);
            this.skyVBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.skyVertexFormat.func_227895_d_();
            RenderSystem.disableFog();
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float celestialAngle = world.func_72826_c(partialTicks);
            float[] sunriseColors = this.dimension.func_76560_a(celestialAngle, partialTicks);
            if (sunriseColors != null) {
                RenderSystem.disableTexture();
                RenderSystem.shadeModel((int)7425);
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                float sunriseR = sunriseColors[0];
                float sunriseG = sunriseColors[1];
                float sunriseB = sunriseColors[2];
                float sunriseAlpha = sunriseColors[3];
                Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                buf.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(sunriseR, sunriseG *= 1.2f, sunriseB, sunriseAlpha).func_181675_d();
                for (int l = 0; l <= 16; ++l) {
                    float f7 = (float)l * ((float)Math.PI * 2) / 16.0f;
                    float f8 = MathHelper.func_76126_a((float)f7);
                    float f9 = MathHelper.func_76134_b((float)f7);
                    buf.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunriseAlpha).func_227885_a_(sunriseR, sunriseG, sunriseB, 0.0f).func_181675_d();
                }
                buf.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
                matrixStack.func_227865_b_();
                RenderSystem.shadeModel((int)7424);
            }
            float skyFeatureBrightness = this.dimension.getSkyFeatureBrightness(ari.func_216780_d(), partialTicks);
            float rainAlteredBrightness = 1.0f - world.func_72867_j(partialTicks);
            skyFeatureBrightness *= rainAlteredBrightness;
            RenderSystem.enableTexture();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(celestialAngle * 360.0f));
            float starBrightness = world.func_228330_j_(partialTicks) * skyFeatureBrightness;
            if (starBrightness > 0.0f) {
                if (this.currentSkyTexture == null) {
                    this.currentSkyTexture = this.skyTextures.getRandomSkin();
                }
                texMgr.func_110577_a(this.currentSkyTexture);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                this.renderSkyboxSide(buf, matrixStack, 4);
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                this.renderSkyboxSide(buf, matrixStack, 1);
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                this.renderSkyboxSide(buf, matrixStack, 0);
                matrixStack.func_227865_b_();
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                this.renderSkyboxSide(buf, matrixStack, 5);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                this.renderSkyboxSide(buf, matrixStack, 2);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                this.renderSkyboxSide(buf, matrixStack, 3);
                matrixStack.func_227865_b_();
            } else {
                this.currentSkyTexture = null;
            }
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            if (skyFeatureBrightness > 0.0f) {
                RenderSystem.defaultBlendFunc();
                float rSun = 12.5f;
                texMgr.func_110577_a(SUN_TEXTURE);
                for (int pass = 0; pass <= 1; ++pass) {
                    if (pass == 0) {
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)skyFeatureBrightness);
                    } else if (pass == 1) {
                        if (sunriseColors == null) continue;
                        float sunriseBlend = sunriseColors[3];
                        RenderSystem.color4f((float)1.0f, (float)0.9f, (float)0.2f, (float)((sunriseBlend *= 0.5f) * skyFeatureBrightness));
                    }
                    buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    buf.func_227888_a_(matrix, -rSun, 100.0f, -rSun).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    buf.func_227888_a_(matrix, rSun, 100.0f, -rSun).func_225583_a_(1.0f, 0.0f).func_181675_d();
                    buf.func_227888_a_(matrix, rSun, 100.0f, rSun).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    buf.func_227888_a_(matrix, -rSun, 100.0f, rSun).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    buf.func_178977_d();
                    WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
                }
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)skyFeatureBrightness);
                int phases = Dimension.field_111203_a.length;
                int moonPhase = this.dimension.func_76559_b(worldTime);
                boolean lunarEclipse = this.dimension.isLunarEclipse(worldTime);
                if (lunarEclipse) {
                    RenderSystem.color3f((float)1.0f, (float)0.6f, (float)0.4f);
                }
                texMgr.func_110577_a(MOON_TEXTURE);
                float rMoon = 12.5f;
                float moonUMin = (float)moonPhase / (float)phases;
                float moonUMax = (float)(moonPhase + 1) / (float)phases;
                float moonVMin = 0.0f;
                float moonVMax = 1.0f;
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_227888_a_(matrix, -rMoon, -100.0f, rMoon).func_225583_a_(moonUMax, moonVMax).func_181675_d();
                buf.func_227888_a_(matrix, rMoon, -100.0f, rMoon).func_225583_a_(moonUMin, moonVMax).func_181675_d();
                buf.func_227888_a_(matrix, rMoon, -100.0f, -rMoon).func_225583_a_(moonUMin, moonVMin).func_181675_d();
                buf.func_227888_a_(matrix, -rMoon, -100.0f, -rMoon).func_225583_a_(moonUMax, moonVMin).func_181675_d();
                buf.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
            }
            float celestialAngleMid = celestialAngle - 0.5f;
            float celestialAngleAbs = Math.abs(celestialAngleMid);
            float eMin = 0.15f;
            float eMax = 0.3f;
            if (celestialAngleAbs >= eMin && celestialAngleAbs <= eMax) {
                float eMid = (eMin + eMax) / 2.0f;
                float eHalfWidth = eMax - eMid;
                float eBright = MathHelper.func_76134_b((float)((celestialAngleAbs - eMid) / eHalfWidth * (float)Math.PI / 2.0f));
                eBright *= eBright;
                eBright = MathHelper.func_76131_a((float)eBright, (float)0.0f, (float)1.0f);
                float eAngle = Math.signum(celestialAngleMid) * 18.0f;
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(eAngle));
                Matrix4f matrixE = matrixStack.func_227866_c_().func_227870_a_();
                RenderSystem.defaultBlendFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)eBright);
                RenderSystem.enableAlphaTest();
                texMgr.func_110577_a(EARENDIL_TEXTURE);
                float rEarendil = 1.5f;
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_227888_a_(matrixE, -rEarendil, 100.0f, -rEarendil).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buf.func_227888_a_(matrixE, rEarendil, 100.0f, -rEarendil).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buf.func_227888_a_(matrixE, rEarendil, 100.0f, rEarendil).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buf.func_227888_a_(matrixE, -rEarendil, 100.0f, rEarendil).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buf.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
                matrixStack.func_227865_b_();
                RenderSystem.disableAlphaTest();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableFog();
            matrixStack.func_227865_b_();
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            double aboveHorizon = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_228331_m_();
            if (aboveHorizon < 0.0) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 12.0, 0.0);
                this.sky2VBO.func_177359_a();
                this.skyVertexFormat.func_227892_a_(0L);
                this.sky2VBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                this.skyVertexFormat.func_227895_d_();
                matrixStack.func_227865_b_();
            }
            if (this.dimension.func_76561_g()) {
                RenderSystem.color3f((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f));
            } else {
                RenderSystem.color3f((float)skyR, (float)skyG, (float)skyB);
            }
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableFog();
        }
    }

    private void renderSkyboxSide(BufferBuilder buf, MatrixStack matStack, int side) {
        int sideX = side % 3;
        int sideY = side / 3;
        float uMin = (float)sideX / 3.0f;
        float uMax = (float)(sideX + 1) / 3.0f;
        float vMin = (float)sideY / 2.0f;
        float vMax = (float)(sideY + 1) / 2.0f;
        float depth = 100.0f;
        Matrix4f matrix = matStack.func_227866_c_().func_227870_a_();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_227888_a_(matrix, -depth, -depth, -depth).func_225583_a_(uMin, vMin).func_181675_d();
        buf.func_227888_a_(matrix, -depth, -depth, depth).func_225583_a_(uMin, vMax).func_181675_d();
        buf.func_227888_a_(matrix, depth, -depth, depth).func_225583_a_(uMax, vMax).func_181675_d();
        buf.func_227888_a_(matrix, depth, -depth, -depth).func_225583_a_(uMax, vMin).func_181675_d();
        buf.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
    }
}

