/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTRClientUtil;
import lotr.client.render.entity.RingPortalRenderer;
import lotr.client.render.entity.model.OnScreenCompassModel;
import lotr.client.render.entity.model.RingPortalModel;
import lotr.common.config.LOTRConfig;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class OnScreenCompassRenderer
extends AbstractGui {
    private static final ResourceLocation COMPASS_TEXTURE = new ResourceLocation("lotr", "textures/gui/on_screen_compass.png");
    private OnScreenCompassModel compassModel = new OnScreenCompassModel();
    private Model ringModel = new RingPortalModel(false);
    private Model scriptModel = new RingPortalModel(true);

    public void renderCompassAndInformation(Minecraft mc, PlayerEntity player, World world, float renderTick) {
        MatrixStack matStack = new MatrixStack();
        MainWindow window = mc.func_228018_at_();
        int width = window.func_198107_o();
        int height = window.func_198087_p();
        int compassX = width - 60;
        int compassY = 44;
        matStack.func_227861_a_((double)compassX, (double)compassY, 0.0);
        float rotation = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * renderTick;
        rotation = 180.0f - rotation;
        this.renderCompassModel(mc, matStack, 16.0f, rotation);
        if (((Boolean)LOTRConfig.CLIENT.compassInfo.get()).booleanValue()) {
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.5f;
            float invScale = 1.0f / scale;
            compassX = (int)((float)compassX * invScale);
            compassY = (int)((float)compassY * invScale);
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            BlockPos playerPos = player.func_180425_c();
            String coords = new TranslationTextComponent("gui.lotr.compass.coords", new Object[]{playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()}).func_150254_d();
            FontRenderer fontRenderer = mc.field_71466_p;
            int coordsWidth = fontRenderer.func_78256_a(coords);
            int coordsY = compassY + 68;
            int rectBorder = 2;
            int rectColor = 0x3F000000;
            int n = compassX - coordsWidth / 2 - rectBorder;
            int n2 = compassX + coordsWidth / 2 + rectBorder;
            fontRenderer.getClass();
            OnScreenCompassRenderer.fill((int)n, (int)(coordsY - rectBorder), (int)n2, (int)(coordsY + 9 + rectBorder), (int)rectColor);
            fontRenderer.func_211126_b(coords, (float)(compassX - coordsWidth / 2), (float)coordsY, 0xFFFFFF);
            if (LOTRClientUtil.doesClientChunkExist(world, playerPos)) {
                Biome biome = world.func_226691_t_(playerPos);
                String biomeName = biome.func_205403_k().func_150254_d();
                int biomeNameWidth = fontRenderer.func_78256_a(biomeName);
                int biomeNameY = compassY - 74;
                int n3 = compassX - biomeNameWidth / 2 - rectBorder;
                int n4 = compassX + biomeNameWidth / 2 + rectBorder;
                fontRenderer.getClass();
                OnScreenCompassRenderer.fill((int)n3, (int)(biomeNameY - rectBorder), (int)n4, (int)(biomeNameY + 9 + rectBorder), (int)rectColor);
                fontRenderer.func_211126_b(biomeName, (float)(compassX - biomeNameWidth / 2), (float)biomeNameY, 0xFFFFFF);
            }
            RenderSystem.popMatrix();
        }
    }

    private void renderCompassModel(Minecraft mc, MatrixStack matStack, float scale, float rotation) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableCull();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.pushLightingAttributes();
        RenderSystem.setupGuiFlatDiffuseLighting();
        matStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(40.0f));
        matStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matStack.func_227862_a_(scale, scale, scale);
        IRenderTypeBuffer.Impl typeBuffer = mc.func_228019_au_().func_228487_b_();
        int packedLight = LOTRClientProxy.MAX_LIGHTMAP;
        int packedOverlay = LOTRClientUtil.getPackedNoOverlay();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        IVertexBuilder buf = typeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)COMPASS_TEXTURE));
        matStack.func_227860_a_();
        float compassScale = 2.0f;
        matStack.func_227862_a_(compassScale, compassScale, compassScale);
        this.compassModel.func_225598_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        buf = typeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)RingPortalRenderer.RING_TEXTURE));
        this.ringModel.func_225598_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        buf = typeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)RingPortalRenderer.SCRIPT_TEXTURE));
        matStack.func_227860_a_();
        float outerScriptScale = 1.05f;
        matStack.func_227862_a_(outerScriptScale, outerScriptScale, outerScriptScale);
        this.scriptModel.func_225598_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        float innerScriptScale = 0.85f;
        matStack.func_227862_a_(innerScriptScale, innerScriptScale, innerScriptScale);
        this.scriptModel.func_225598_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        RenderSystem.popAttributes();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.enableCull();
    }
}

