/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import lotr.common.LOTRLog;
import lotr.common.entity.IRandomTextureEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class RandomTextureVariants
implements ISelectiveResourceReloadListener {
    private static Random rand = new Random();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static Map<String, RandomTextureVariants> allRandomSkins = new HashMap<String, RandomTextureVariants>();
    protected String skinPath;
    protected List<ResourceLocation> skins;

    public static RandomTextureVariants loadSkinsList(String namespace, String path) {
        return RandomTextureVariants.loadSkinsList(new ResourceLocation(namespace, path).toString());
    }

    public static RandomTextureVariants loadSkinsList(String path) {
        RandomTextureVariants skins = allRandomSkins.get(path);
        if (skins == null) {
            skins = new RandomTextureVariants(path);
            allRandomSkins.put(path, skins);
        }
        return skins;
    }

    private RandomTextureVariants(String path) {
        this.skinPath = path;
        IReloadableResourceManager resMgr = (IReloadableResourceManager)mc.func_195551_G();
        resMgr.func_219534_a((IFutureReloadListener)this);
        this.loadAllRandomSkins((IResourceManager)resMgr);
    }

    private void loadAllRandomSkins(IResourceManager resMgr) {
        this.skins = new ArrayList<ResourceLocation>();
        int skinCount = 0;
        int skips = 0;
        int maxSkips = 10;
        boolean foundAfterSkip = false;
        while (true) {
            ResourceLocation skin = new ResourceLocation(this.skinPath + "/" + skinCount + ".png");
            boolean noFile = false;
            try {
                if (resMgr.func_199002_a(skin) == null) {
                    noFile = true;
                }
            }
            catch (Exception e) {
                noFile = true;
            }
            if (noFile) {
                if (++skips >= maxSkips) break;
                ++skinCount;
                continue;
            }
            this.skins.add(skin);
            ++skinCount;
            if (skips <= 0) continue;
            foundAfterSkip = true;
        }
        if (this.skins.isEmpty()) {
            LOTRLog.warn("No random skins for %s", this.skinPath);
        }
        if (foundAfterSkip) {
            LOTRLog.warn("Random skins %s skipped a number. This is not good - please number your skins from 0 and upwards, with no gaps!", this.skinPath);
        }
    }

    public ResourceLocation getRandomSkin(IRandomTextureEntity rsEntity) {
        if (this.skins == null || this.skins.isEmpty()) {
            return MissingTextureSprite.func_195675_b();
        }
        Entity entity = (Entity)rsEntity;
        long l = entity.func_110124_au().getLeastSignificantBits();
        long hash = this.skinPath.hashCode();
        l = l * 39603773L ^ l * 6583690632L ^ hash;
        l = l * hash * 2906920L + l * 65936063L;
        rand.setSeed(l);
        int i = rand.nextInt(this.skins.size());
        return this.skins.get(i);
    }

    public ResourceLocation getRandomSkin() {
        if (this.skins == null || this.skins.isEmpty()) {
            return MissingTextureSprite.func_195675_b();
        }
        int i = rand.nextInt(this.skins.size());
        return this.skins.get(i);
    }

    public static int nextInt(IRandomTextureEntity rsEntity, int n) {
        Entity entity = (Entity)rsEntity;
        long l = entity.func_110124_au().getLeastSignificantBits();
        l = l * 29506206L * (l ^ 0x6429C58L) + 25859L;
        l = l * l * 426430295004L + 25925025L * l;
        rand.setSeed(l);
        return rand.nextInt(n);
    }

    public List<ResourceLocation> getAllSkins() {
        return this.skins;
    }

    public void onResourceManagerReload(IResourceManager resMgr, Predicate<IResourceType> resPredicate) {
        if (resPredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            this.loadAllRandomSkins(resMgr);
        }
    }
}

