/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lotr.client.render.model.DynamicTextureResourcePack;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.common.LOTRLog;
import lotr.common.item.VesselType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class DynamicTextureRepository {
    public static final DynamicTextureRepository INSTANCE = new DynamicTextureRepository();
    private final Map<String, DynamicTextureResourcePack> virtualPacks = new HashMap<String, DynamicTextureResourcePack>();
    private final Map<ResourceLocation, List<ResourceLocation>> cachedConnectedLocations = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private final Map<ResourceLocation, Map<VesselType, ResourceLocation>> cachedVesselLocations = new HashMap<ResourceLocation, Map<VesselType, ResourceLocation>>();
    private static final int VESSEL_FILL_COLOR = 0xFF00FF;

    private DynamicTextureRepository() {
    }

    public ResourceLocation getConnectedTexture(ResourceLocation base, Set<ConnectedTextureElement> elements) {
        if (!this.cachedConnectedLocations.containsKey(base)) {
            return MissingTextureSprite.func_195675_b();
        }
        return DynamicTextureRepository.getConnectedTextureLocation(base, elements);
    }

    private static ResourceLocation getConnectedTextureLocation(ResourceLocation base, Set<ConnectedTextureElement> elements) {
        int key = ConnectedTextureElement.getIconSetKey(elements);
        return new ResourceLocation(base.func_110624_b(), base.func_110623_a() + "_" + key);
    }

    public List<ResourceLocation> generateAllConnectedTextures(ResourceLocation base) {
        return this.generateAllConnectedTextures(base, false);
    }

    public List<ResourceLocation> generateAllConnectedTextures(ResourceLocation base, boolean includeNoBase) {
        boolean checkResourceExists;
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resMgr = mc.func_195551_G();
        String namespace = base.func_110624_b();
        if (this.cachedConnectedLocations.containsKey(base) && (checkResourceExists = resMgr.func_219533_b(DynamicTextureResourcePack.createDynamicTextureSetIsLoadedMarker(base)))) {
            return this.cachedConnectedLocations.get(base);
        }
        ArrayList<ResourceLocation> allList = new ArrayList<ResourceLocation>();
        try {
            ResourceLocation baseTextureFullPath = DynamicTextureRepository.convertTextureFullPath(base);
            NativeImage baseImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(baseTextureFullPath).func_199027_b());
            int iconWidth = baseImage.func_195702_a();
            int iconHeight = baseImage.func_195714_b();
            HashMap<ConnectedTextureElement, NativeImage> elementImages = new HashMap<ConnectedTextureElement, NativeImage>();
            for (ConnectedTextureElement elem : ConnectedTextureElement.values()) {
                if (elem == ConnectedTextureElement.BASE) {
                    elementImages.put(elem, baseImage);
                    continue;
                }
                ResourceLocation elementPath = DynamicTextureRepository.convertTextureFullPath(new ResourceLocation(base + elem.iconName));
                NativeImage elementImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(elementPath).func_199027_b());
                if (elementImage.func_195702_a() != iconWidth || elementImage.func_195714_b() != iconHeight) {
                    LOTRLog.error("All connected texture icons for %s must have the same dimensions!", base);
                    LOTRLog.error("%s: base icon is %dx%d, but %s icon is %dx%d", base, iconWidth, iconHeight, elem.iconName, elementImage.func_195702_a(), elementImage.func_195714_b());
                    elementImages.put(elem, DynamicTextureRepository.createErroredImage(iconWidth, iconHeight));
                    continue;
                }
                elementImages.put(elem, elementImage);
            }
            for (Map.Entry entry : ConnectedTextureElement.allPermutations.entrySet()) {
                int key = (Integer)entry.getKey();
                Set elementSet = (Set)entry.getValue();
                if (!includeNoBase && !elementSet.contains((Object)ConnectedTextureElement.BASE)) continue;
                List<ConnectedTextureElement> sortedList = ConnectedTextureElement.sortIconSet(elementSet);
                NativeImage connectedImage = new NativeImage(baseImage.func_211678_c(), baseImage.func_195702_a(), baseImage.func_195714_b(), true);
                connectedImage.func_195703_a(baseImage);
                for (ConnectedTextureElement elem : sortedList) {
                    NativeImage elementImage = (NativeImage)elementImages.get((Object)elem);
                    for (int x = 0; x < connectedImage.func_195702_a(); ++x) {
                        for (int y = 0; y < connectedImage.func_195714_b(); ++y) {
                            int rgba = elementImage.func_195709_a(x, y);
                            int alpha = rgba >> 24 & 0xFF;
                            if (alpha == 0) continue;
                            connectedImage.func_195700_a(x, y, rgba);
                        }
                    }
                }
                DynamicTexture dynamic = new DynamicTexture(connectedImage);
                ResourceLocation connectedRes = DynamicTextureRepository.getConnectedTextureLocation(base, elementSet);
                ResourceLocation connectedFullPath = DynamicTextureRepository.convertTextureFullPath(connectedRes);
                mc.func_110434_K().func_229263_a_(connectedFullPath, (Texture)dynamic);
                this.getVirtualPack(namespace).addDynamicTexture(base, connectedFullPath, dynamic);
                allList.add(connectedRes);
            }
        }
        catch (IOException e) {
            LOTRLog.error("Error generating connected textures for %s", base);
            e.printStackTrace();
        }
        this.cachedConnectedLocations.put(base, allList);
        return allList;
    }

    public ResourceLocation getFilledVesselTexture(ResourceLocation liquidTex, VesselType vessel) {
        if (!this.cachedVesselLocations.containsKey(liquidTex)) {
            return MissingTextureSprite.func_195675_b();
        }
        return DynamicTextureRepository.getFilledVesselLocation(liquidTex, vessel);
    }

    public Map<VesselType, ResourceLocation> generateVesselDrinkTextures(ResourceLocation liquidTex) {
        boolean checkResourceExists;
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resMgr = mc.func_195551_G();
        String namespace = liquidTex.func_110624_b();
        if (this.cachedVesselLocations.containsKey(liquidTex) && (checkResourceExists = resMgr.func_219533_b(DynamicTextureResourcePack.createDynamicTextureSetIsLoadedMarker(liquidTex)))) {
            return this.cachedVesselLocations.get(liquidTex);
        }
        HashMap<VesselType, ResourceLocation> allMap = new HashMap<VesselType, ResourceLocation>();
        try {
            ResourceLocation liquidTexFullPath = DynamicTextureRepository.convertTextureFullPath(liquidTex);
            NativeImage liquidImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(liquidTexFullPath).func_199027_b());
            int iconWidth = liquidImage.func_195702_a();
            int iconHeight = liquidImage.func_195714_b();
            for (VesselType ves : VesselType.values()) {
                ResourceLocation vesPath = DynamicTextureRepository.convertTextureFullPath(ves.getEmptySpritePath());
                NativeImage vesImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(vesPath).func_199027_b());
                if (iconWidth < vesImage.func_195702_a() || iconHeight < vesImage.func_195714_b()) {
                    LOTRLog.error("The loaded drink liquid icon %s is too small! Must be at least the size of loaded vessel icons, and ideally 2x2x", liquidTex);
                    LOTRLog.error("%s: liquid icon is %dx%d, but %s icon is %dx%d", liquidTex, iconWidth, iconHeight, ves.getEmptyIconName(), vesImage.func_195702_a(), vesImage.func_195714_b());
                    vesImage = DynamicTextureRepository.createErroredImage(iconWidth, iconHeight);
                }
                NativeImage filledDrinkImage = new NativeImage(vesImage.func_211678_c(), vesImage.func_195702_a(), vesImage.func_195714_b(), true);
                filledDrinkImage.func_195703_a(vesImage);
                for (int x = 0; x < filledDrinkImage.func_195702_a(); ++x) {
                    for (int y = 0; y < filledDrinkImage.func_195714_b(); ++y) {
                        int rgb = filledDrinkImage.func_195709_a(x, y) & 0xFFFFFF;
                        if (rgb != 0xFF00FF) continue;
                        int liquidRgba = liquidImage.func_195709_a(x, y);
                        filledDrinkImage.func_195700_a(x, y, liquidRgba);
                    }
                }
                DynamicTexture dynamic = new DynamicTexture(filledDrinkImage);
                ResourceLocation filledRes = DynamicTextureRepository.getFilledVesselLocation(liquidTex, ves);
                ResourceLocation filledFullPath = DynamicTextureRepository.convertTextureFullPath(filledRes);
                mc.func_110434_K().func_229263_a_(filledFullPath, (Texture)dynamic);
                this.getVirtualPack(namespace).addDynamicTexture(liquidTex, filledFullPath, dynamic);
                allMap.put(ves, filledRes);
            }
        }
        catch (IOException e) {
            LOTRLog.error("Error generating filled vessel textures for %s", liquidTex);
            e.printStackTrace();
        }
        this.cachedVesselLocations.put(liquidTex, allMap);
        return allMap;
    }

    private static ResourceLocation getFilledVesselLocation(ResourceLocation liquidTex, VesselType vessel) {
        return new ResourceLocation(liquidTex.func_110624_b(), liquidTex.func_110623_a() + "_" + vessel.getCodeName());
    }

    private static ResourceLocation convertTextureFullPath(ResourceLocation texture) {
        return new ResourceLocation(texture.func_110624_b(), String.format("textures/%s%s", texture.func_110623_a(), ".png"));
    }

    private static NativeImage createErroredImage(int width, int height) {
        NativeImage errored = new NativeImage(width, height, true);
        for (int x = 0; x < errored.func_195702_a(); ++x) {
            for (int y = 0; y < errored.func_195714_b(); ++y) {
                int rgb = 0;
                rgb = (x + y) % 2 == 0 ? 0xFF0000 : 0;
                errored.func_195700_a(x, y, 0xFF000000 | rgb);
            }
        }
        return errored;
    }

    private DynamicTextureResourcePack getVirtualPack(String namespace) {
        Minecraft mc = Minecraft.func_71410_x();
        SimpleReloadableResourceManager resMgr = (SimpleReloadableResourceManager)mc.func_195551_G();
        DynamicTextureResourcePack pack = this.virtualPacks.get(namespace);
        if (pack == null || pack != null && !resMgr.func_219533_b(pack.packIsLoadedMarkerResource)) {
            pack = new DynamicTextureResourcePack(namespace);
            this.virtualPacks.put(namespace, pack);
            resMgr.func_199021_a((IResourcePack)pack);
        }
        return pack;
    }
}

