/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class DynamicTextureResourcePack
implements IResourcePack {
    private final String namespace;
    private final Map<ResourceLocation, Supplier<InputStream>> inputStreams = new HashMap<ResourceLocation, Supplier<InputStream>>();
    public final ResourceLocation packIsLoadedMarkerResource;
    private final Map<ResourceLocation, ResourceLocation> textureSetsLoadedMarkers = new HashMap<ResourceLocation, ResourceLocation>();

    public DynamicTextureResourcePack(String s) {
        this.namespace = s;
        this.packIsLoadedMarkerResource = new ResourceLocation(this.namespace, "dynamic_tex_virtual_resource_pack_is_loaded_marker");
    }

    public void addDynamicTexture(ResourceLocation baseSpritePath, final ResourceLocation dynamicFullPath, DynamicTexture tex) {
        final NativeImage image = tex.func_195414_e();
        Supplier sup = new Supplier(){

            public InputStream get() {
                try {
                    return new ByteArrayInputStream(image.func_227796_e_());
                }
                catch (IOException e) {
                    LOTRLog.error("Failed to setup dynamic texture resource: %s", dynamicFullPath);
                    e.printStackTrace();
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
        this.inputStreams.put(dynamicFullPath, sup);
        if (!this.textureSetsLoadedMarkers.containsKey(baseSpritePath)) {
            this.textureSetsLoadedMarkers.put(baseSpritePath, DynamicTextureResourcePack.createDynamicTextureSetIsLoadedMarker(baseSpritePath));
        }
    }

    public static ResourceLocation createDynamicTextureSetIsLoadedMarker(ResourceLocation baseSpritePath) {
        return new ResourceLocation(baseSpritePath.func_110624_b(), baseSpritePath.func_110623_a() + "set_loaded_marker");
    }

    public void close() throws IOException {
        this.inputStreams.clear();
    }

    public InputStream func_195763_b(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        return this.inputStreams.get(location).get();
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        return this.inputStreams.keySet();
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return this.inputStreams.containsKey(location) || this.packIsLoadedMarkerResource.equals((Object)location);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return Sets.newHashSet((Object[])new String[]{this.namespace});
    }

    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        return null;
    }

    public String func_195762_a() {
        return String.format("%s:%s virtual pack for dynamic textures", "lotr", this.namespace);
    }
}

