/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRItems;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.RegistryObject;

public class SpecialItemModels {
    private static final String HANDHELD = "_handheld";
    private static List<Item> specialHandheldItems = new ArrayList<Item>();

    public static void detectSpecials() {
        for (RegistryObject ro : LOTRItems.ITEMS.getEntries()) {
            Item item = (Item)ro.get();
            ResourceLocation handheldModel = new ResourceLocation("lotr", "models/item/" + item.getRegistryName().func_110623_a() + HANDHELD + ".json");
            if (!LOTRMod.modResourceExists(ResourcePackType.CLIENT_RESOURCES, handheldModel)) continue;
            SpecialItemModels.addSpecialHandheld(item);
        }
        LOTRLog.info("Automatically detected and registered %d special handheld items!", specialHandheldItems.size());
    }

    public static void addSpecialHandheld(Item item) {
        specialHandheldItems.add(item);
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(item.getRegistryName() + HANDHELD, "inventory"));
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map map = event.getModelRegistry();
        for (Item item : specialHandheldItems) {
            ResourceLocation itemRes = item.getRegistryName();
            ModelResourceLocation modelName = new ModelResourceLocation(itemRes, "inventory");
            ModelResourceLocation handheldModelName = new ModelResourceLocation(itemRes + HANDHELD, "inventory");
            final IBakedModel defaultModel = (IBakedModel)map.get(modelName);
            final IBakedModel handheldModel = (IBakedModel)map.get(handheldModelName);
            IBakedModel wrapperModel = new IBakedModel(){

                public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
                    return defaultModel.func_200117_a(state, side, rand);
                }

                public boolean func_177555_b() {
                    return defaultModel.func_177555_b();
                }

                public boolean func_177556_c() {
                    return defaultModel.func_177556_c();
                }

                public boolean func_230044_c_() {
                    return defaultModel.func_230044_c_();
                }

                public boolean func_188618_c() {
                    return defaultModel.func_188618_c();
                }

                public TextureAtlasSprite func_177554_e() {
                    return defaultModel.func_177554_e();
                }

                public ItemOverrideList func_188617_f() {
                    return handheldModel.func_188617_f();
                }

                public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack mat) {
                    IBakedModel modelToUse = defaultModel;
                    if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                        modelToUse = handheldModel;
                    }
                    return ForgeHooksClient.handlePerspective((IBakedModel)modelToUse, (ItemCameraTransforms.TransformType)transformType, (MatrixStack)mat);
                }
            };
            map.put(modelName, wrapperModel);
        }
    }
}

