/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConnectedTexture3DContext
implements IModelData {
    private final PositionOfInterest[] positionsOfInterest;
    private final boolean[] positionofInterestFlags;

    private ConnectedTexture3DContext(PositionOfInterest[] pois) {
        this.positionsOfInterest = pois;
        this.positionofInterestFlags = new boolean[pois.length];
    }

    public static ConnectedTexture3DContext newEmptyContext() {
        return new ConnectedTexture3DContext(PositionOfInterest.values());
    }

    public static ConnectedTexture3DContext gatherFromWorld(ILightReader world, BlockPos pos, BlockState state) {
        ConnectedTexture3DContext data = ConnectedTexture3DContext.newEmptyContext();
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (PositionOfInterest poi : data.positionsOfInterest) {
            movingPos.func_189533_g((Vec3i)pos);
            for (Direction dir : poi.offsets) {
                movingPos.func_189536_c(dir);
            }
            boolean blockMatch = world.func_180495_p((BlockPos)movingPos).func_177230_c() == state.func_177230_c();
            data.set(poi, blockMatch);
        }
        return data;
    }

    public boolean get(PositionOfInterest poi) {
        int id = poi.id;
        if (id < 0 || id >= this.positionofInterestFlags.length) {
            throw new IllegalArgumentException("Connected Texture Model: requested position id " + id + "is out of bounds of array length " + this.positionofInterestFlags.length + "!");
        }
        return this.positionofInterestFlags[id];
    }

    public void set(PositionOfInterest poi, boolean flag) {
        int id = poi.id;
        if (id < 0 || id >= this.positionofInterestFlags.length) {
            throw new IllegalArgumentException("Connected Texture Model: requested position id " + id + "is out of bounds of array length " + this.positionofInterestFlags.length + "!");
        }
        this.positionofInterestFlags[id] = flag;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            ConnectedTexture3DContext otherData = (ConnectedTexture3DContext)other;
            return Arrays.equals(this.positionofInterestFlags, otherData.positionofInterestFlags);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.positionofInterestFlags);
    }

    public String toString() {
        String s = "ConnectedTexture3DContext[";
        int added = 0;
        for (PositionOfInterest poi : PositionOfInterest.values()) {
            if (!this.get(poi)) continue;
            if (added > 0) {
                s = s + ", ";
            }
            s = s + poi.name();
            ++added;
        }
        s = s + "]";
        return s;
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        return false;
    }

    public <T> T getData(ModelProperty<T> prop) {
        return null;
    }

    public <T> T setData(ModelProperty<T> prop, T data) {
        return null;
    }

    public static enum PositionOfInterest {
        DOWN(0, "down", Direction.DOWN),
        UP(1, "up", Direction.UP),
        NORTH(2, "north", Direction.NORTH),
        SOUTH(3, "south", Direction.SOUTH),
        WEST(4, "west", Direction.WEST),
        EAST(5, "east", Direction.EAST),
        DOWN_NORTH(6, "down_north", Direction.DOWN, Direction.NORTH),
        DOWN_SOUTH(7, "down_south", Direction.DOWN, Direction.SOUTH),
        DOWN_WEST(8, "down_west", Direction.DOWN, Direction.WEST),
        DOWN_EAST(9, "down_east", Direction.DOWN, Direction.EAST),
        UP_NORTH(10, "up_north", Direction.UP, Direction.NORTH),
        UP_SOUTH(11, "up_south", Direction.UP, Direction.SOUTH),
        UP_WEST(12, "up_west", Direction.UP, Direction.WEST),
        UP_EAST(13, "up_east", Direction.UP, Direction.EAST),
        NORTH_WEST(14, "north_west", Direction.NORTH, Direction.WEST),
        NORTH_EAST(15, "north_east", Direction.NORTH, Direction.EAST),
        SOUTH_WEST(16, "south_west", Direction.SOUTH, Direction.WEST),
        SOUTH_EAST(17, "south_east", Direction.SOUTH, Direction.EAST);

        public final int id;
        public final String nameInJson;
        public final Direction[] offsets;

        private PositionOfInterest(int id, String s, Direction ... offs) {
            this.id = id;
            this.nameInJson = s;
            this.offsets = offs;
        }

        public static PositionOfInterest getByJsonName(String name) {
            for (PositionOfInterest poi : PositionOfInterest.values()) {
                if (!poi.nameInJson.equals(name)) continue;
                return poi;
            }
            return null;
        }
    }
}

