/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.client.render.model.BlockModelQuadsHolder;
import lotr.client.render.model.connectedtex.ConnectedTexture2DContext;
import lotr.client.render.model.connectedtex.ConnectedTexture3DContext;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.client.render.model.connectedtex.ConnectedTextureFaceMapper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ConnectedTextureBlockModel
extends SimpleBakedModel {
    private final Map<Integer, BlockModelQuadsHolder> connectedQuadsMap;
    private final ConnectedTexture3DContext itemRenderContext;

    public ConnectedTextureBlockModel(Map<Integer, BlockModelQuadsHolder> connections, boolean ambOcc, boolean sideLight, boolean g3d, TextureAtlasSprite partTex, ItemCameraTransforms transform, ItemOverrideList overrides, ConnectedTexture3DContext itemCtx) {
        super(new ArrayList(), new HashMap(), ambOcc, sideLight, g3d, partTex, transform, overrides);
        this.connectedQuadsMap = connections;
        this.itemRenderContext = itemCtx;
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.getQuads(state, side, rand, this.itemRenderContext);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        if (extraData instanceof ConnectedTexture3DContext) {
            ConnectedTexture3DContext ctx3d = (ConnectedTexture3DContext)extraData;
            ConnectedTexture2DContext ctx2d = ConnectedTextureFaceMapper.get2dFrom3d(ctx3d, Optional.ofNullable(side).orElse(Direction.UP));
            Set<ConnectedTextureElement> elementSet = ctx2d.getTextureElements();
            int key = ConnectedTextureElement.getIconSetKey(elementSet);
            if (this.connectedQuadsMap.containsKey(key)) {
                return this.connectedQuadsMap.get(key).getQuads(side);
            }
            throw new IllegalArgumentException("ConnectedTextureBlockModel has no matching state for " + ctx2d.toString());
        }
        if (extraData instanceof EmptyModelData) {
            return this.getQuads(state, side, rand, this.itemRenderContext);
        }
        throw new IllegalArgumentException("ConnectedTextureBlockModel can only take ConnectedTexture3DContext model data or EmptyModelData, but " + extraData.getClass().getName() + " was supplied");
    }

    public IModelData getModelData(ILightReader world, BlockPos pos, BlockState state, IModelData tileData) {
        return ConnectedTexture3DContext.gatherFromWorld(world, pos, state);
    }
}

