/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.HashMap;
import java.util.Map;
import lotr.client.render.model.connectedtex.ConnectedTexture2DContext;
import lotr.client.render.model.connectedtex.ConnectedTexture3DContext;
import net.minecraft.util.Direction;

public abstract class ConnectedTextureFaceMapper {
    public static final Map<Direction, ConnectedTextureFaceMapper> faceMappers = new HashMap<Direction, ConnectedTextureFaceMapper>();

    private ConnectedTextureFaceMapper() {
    }

    abstract ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition var1);

    public static ConnectedTexture2DContext get2dFrom3d(ConnectedTexture3DContext modelData, Direction face) {
        ConnectedTexture2DContext ctx = new ConnectedTexture2DContext();
        ConnectedTextureFaceMapper faceMapper = faceMappers.get(face);
        for (ConnectedTexture2DContext.RelativePosition rPos : ConnectedTexture2DContext.RelativePosition.values()) {
            if (rPos == ConnectedTexture2DContext.RelativePosition.CENTRE) {
                ctx.set(rPos, true);
                continue;
            }
            ctx.set(rPos, modelData.get(faceMapper.getPositionToCheck(rPos)));
        }
        return ctx;
    }

    static {
        faceMappers.put(Direction.DOWN, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        faceMappers.put(Direction.UP, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        faceMappers.put(Direction.NORTH, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_EAST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_WEST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_EAST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_WEST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        faceMappers.put(Direction.SOUTH, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        faceMappers.put(Direction.WEST, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_NORTH;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_SOUTH;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_NORTH;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_SOUTH;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        faceMappers.put(Direction.EAST, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_SOUTH;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_NORTH;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_SOUTH;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_NORTH;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
    }
}

