/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lotr.client.render.model.BlockModelQuadsHolder;
import lotr.client.render.model.DynamicTextureRepository;
import lotr.client.render.model.connectedtex.ConnectedTexture3DContext;
import lotr.client.render.model.connectedtex.ConnectedTextureBlockModel;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.common.LOTRLog;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;

public class ConnectedTextureUnbakedModel
implements ISimpleModelGeometry<ConnectedTextureUnbakedModel> {
    private final List<BlockPart> elements;
    private final List<ConnectedTexture3DContext.PositionOfInterest> itemConnectedContextPoints;

    public ConnectedTextureUnbakedModel(List<BlockPart> list, List<ConnectedTexture3DContext.PositionOfInterest> itemCtx) {
        this.elements = list;
        this.itemConnectedContextPoints = itemCtx;
    }

    public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        for (Map.Entry<Integer, Set<ConnectedTextureElement>> entry : ConnectedTextureElement.allPermutations.entrySet()) {
            int key = entry.getKey();
            Set<ConnectedTextureElement> elementSet = entry.getValue();
            if (!elementSet.contains((Object)ConnectedTextureElement.BASE)) continue;
            ArrayList generalQuads = Lists.newArrayList();
            EnumMap builderFaceQuads = Maps.newEnumMap(Direction.class);
            for (Direction dir : Direction.values()) {
                builderFaceQuads.put(dir, Lists.newArrayList());
            }
            for (BlockPart blockpart : this.elements) {
                for (Direction direction : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                    Material material = owner.resolveTexture(blockpartface.field_178242_d);
                    ResourceLocation texture = material.func_229313_b_();
                    ResourceLocation connectedTexture = DynamicTextureRepository.INSTANCE.getConnectedTexture(texture, elementSet);
                    TextureAtlasSprite icon = spriteGetter.apply(new Material(material.func_229310_a_(), connectedTexture));
                    if (blockpartface.field_178244_b == null) {
                        generalQuads.add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                        continue;
                    }
                    ((List)builderFaceQuads.get(modelTransform.func_225615_b_().rotateTransform(blockpartface.field_178244_b))).add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                }
            }
            BlockModelQuadsHolder holder = new BlockModelQuadsHolder(generalQuads, builderFaceQuads);
            ((Builder)modelBuilder).addConnectionStateHolder(key, holder);
        }
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (BlockPart part : this.elements) {
            for (BlockPartFace face : part.field_178240_c.values()) {
                Material texture = owner.resolveTexture(face.field_178242_d);
                if (Objects.equals(texture.func_229310_a_().toString(), MissingTextureSprite.func_195675_b().toString())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
        }
        HashSet allConnectedTextures = Sets.newHashSet();
        for (Material texture : textures) {
            if (Objects.equals(texture.func_229310_a_().toString(), MissingTextureSprite.func_195675_b().toString())) continue;
            List<ResourceLocation> connected = DynamicTextureRepository.INSTANCE.generateAllConnectedTextures(texture.func_229313_b_());
            connected.forEach(connectedRes -> {
                Material connectedMaterial = new Material(texture.func_229310_a_(), connectedRes);
                allConnectedTextures.add(connectedMaterial);
            });
        }
        textures.addAll(allConnectedTextures);
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        Builder builder = new Builder(owner, overrides).setParticle(particle);
        this.addQuads(owner, builder, bakery, spriteGetter, modelTransform, modelLocation);
        builder.createItemConnectedContext(this.itemConnectedContextPoints);
        return builder.build();
    }

    public static final class Builder
    implements IModelBuilder {
        private Map<Integer, BlockModelQuadsHolder> connectedQuadsMap = new HashMap<Integer, BlockModelQuadsHolder>();
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite particleTexture;
        private final boolean isSideLight;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;
        private ConnectedTexture3DContext itemContext;

        public Builder(IModelConfiguration model, ItemOverrideList overrides) {
            this(model.useSmoothLighting(), model.isShadedInGui(), model.isSideLit(), model.getCameraTransforms(), overrides);
        }

        public Builder(BlockModel model, ItemOverrideList overrides, boolean g3d) {
            this(model.func_178309_b(), model.func_230176_c_().func_230178_a_(), g3d, model.func_181682_g(), overrides);
        }

        private Builder(boolean ambOcc, boolean sideLight, boolean g3d, ItemCameraTransforms transform, ItemOverrideList overrides) {
            this.builderItemOverrideList = overrides;
            this.builderAmbientOcclusion = ambOcc;
            this.isSideLight = sideLight;
            this.builderGui3d = g3d;
            this.builderCameraTransforms = transform;
        }

        public void addConnectionStateHolder(int key, BlockModelQuadsHolder holder) {
            this.connectedQuadsMap.put(key, holder);
        }

        public Builder addFaceQuad(Direction facing, BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder map instead");
        }

        public Builder addGeneralQuad(BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder map instead");
        }

        public Builder setParticle(TextureAtlasSprite texture) {
            this.particleTexture = texture;
            return this;
        }

        public Builder createItemConnectedContext(List<ConnectedTexture3DContext.PositionOfInterest> points) {
            this.itemContext = ConnectedTexture3DContext.newEmptyContext();
            if (points != null) {
                for (ConnectedTexture3DContext.PositionOfInterest poi : points) {
                    this.itemContext.set(poi, true);
                }
            }
            return this;
        }

        public IBakedModel build() {
            if (this.particleTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new ConnectedTextureBlockModel(this.connectedQuadsMap, this.builderAmbientOcclusion, this.isSideLight, this.builderGui3d, this.particleTexture, this.builderCameraTransforms, this.builderItemOverrideList, this.itemContext);
        }
    }

    public static final class Loader
    implements IModelLoader<ConnectedTextureUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ConnectedTextureUnbakedModel read(JsonDeserializationContext deserializationContext, JsonObject modelObj) {
            ArrayList parts = Lists.newArrayList();
            List itemContextPoints = null;
            if (modelObj.has("elements")) {
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)modelObj, (String)"elements")) {
                    parts.add(deserializationContext.deserialize(element, BlockPart.class));
                }
            }
            if (modelObj.has("item_connected_context")) {
                itemContextPoints = this.loadItemContextParts(modelObj, "item_connected_context");
            }
            if (modelObj.has("parent")) {
                IUnbakedModel parentModel;
                String parent = modelObj.get("parent").getAsString();
                ResourceLocation parentLocation = new ResourceLocation(parent);
                HashSet<ResourceLocation> parentModels = new HashSet<ResourceLocation>();
                parentModels.add(parentLocation);
                while (parentLocation != null && (parentModel = ModelLoader.instance().func_209597_a(parentLocation)) instanceof BlockModel) {
                    ConnectedTextureUnbakedModel parentCTM;
                    BlockModel blockModel = (BlockModel)parentModel;
                    parts.addAll(blockModel.func_178298_a());
                    if (itemContextPoints == null && blockModel.customData.getCustomGeometry() instanceof ConnectedTextureUnbakedModel && (parentCTM = (ConnectedTextureUnbakedModel)blockModel.customData.getCustomGeometry()).itemConnectedContextPoints != null) {
                        itemContextPoints = parentCTM.itemConnectedContextPoints;
                    }
                    if (!parentModels.contains(parentLocation = blockModel.getParentLocation())) continue;
                    LOTRLog.error("Circular reference in connected texture model 'parent' tree: %s already present", parentLocation);
                    break;
                }
            }
            return new ConnectedTextureUnbakedModel(parts, itemContextPoints);
        }

        private List<ConnectedTexture3DContext.PositionOfInterest> loadItemContextParts(JsonObject modelObj, String arrayName) {
            ArrayList parts = Lists.newArrayList();
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)modelObj, (String)arrayName)) {
                String poiName = element.getAsString();
                ConnectedTexture3DContext.PositionOfInterest poi = ConnectedTexture3DContext.PositionOfInterest.getByJsonName(poiName);
                if (poi == null) {
                    LOTRLog.error("Error in connected texture model item_connected_context: no 'point of interest' named %s", poiName);
                    continue;
                }
                parts.add(poi);
            }
            return parts;
        }
    }
}

