/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.scatter;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class ScatterModelGenerator {
    private final Random rand = new Random();
    private final int minElements;
    private final int maxElements;
    private final int minXSize;
    private final int maxXSize;
    private final int minZSize;
    private final int maxZSize;

    private ScatterModelGenerator(int minElements, int maxElements, int minXSize, int maxXSize, int minZSize, int maxZSize) {
        this.minElements = minElements;
        this.maxElements = maxElements;
        this.minXSize = minXSize;
        this.maxXSize = maxXSize;
        this.minZSize = minZSize;
        this.maxZSize = maxZSize;
        if (minElements < 0 || minElements > maxElements) {
            throw new IllegalArgumentException("Invalid num-elements range");
        }
        if (minXSize < 0 || maxXSize > 16 || minXSize > maxXSize) {
            throw new IllegalArgumentException("Invalid x-size range");
        }
        if (minZSize < 0 || maxZSize > 16 || minZSize > maxZSize) {
            throw new IllegalArgumentException("Invalid z-size range");
        }
    }

    public static ScatterModelGenerator parse(JsonObject json) {
        int[] elementsRange = ScatterModelGenerator.parseIntRange(json.get("num_elements_range").getAsJsonArray());
        int[] xSizeRange = ScatterModelGenerator.parseIntRange(json.get("x_size_range").getAsJsonArray());
        int[] zSizeRange = ScatterModelGenerator.parseIntRange(json.get("z_size_range").getAsJsonArray());
        return new ScatterModelGenerator(elementsRange[0], elementsRange[1], xSizeRange[0], xSizeRange[1], zSizeRange[0], zSizeRange[1]);
    }

    private static int[] parseIntRange(JsonArray array) {
        if (array.size() != 2) {
            throw new IllegalArgumentException("Range should contain 2 values");
        }
        int min = array.get(0).getAsInt();
        int max = array.get(1).getAsInt();
        return new int[]{min, max};
    }

    private static float[] parseFloatRange(JsonArray array) {
        if (array.size() != 2) {
            throw new IllegalArgumentException("Range should contain 2 values");
        }
        float min = array.get(0).getAsFloat();
        float max = array.get(1).getAsFloat();
        return new float[]{min, max};
    }

    public List<List<BlockPart>> generateNRandomModels(int n, String texture) {
        this.rand.setSeed(5251224673490637827L);
        this.rand.setSeed(this.rand.nextLong() ^ (long)(texture.hashCode() * (1156258289 + n)));
        return IntStream.range(0, n).mapToObj(i -> {
            int elements = MathHelper.func_76136_a((Random)this.rand, (int)this.minElements, (int)this.maxElements);
            return IntStream.range(0, elements).mapToObj(e -> {
                float elementFrac = (float)e / (float)elements;
                float posX = MathHelper.func_151240_a((Random)this.rand, (float)0.0f, (float)16.0f);
                float posZ = MathHelper.func_151240_a((Random)this.rand, (float)0.0f, (float)16.0f);
                float posY = 0.16f + elementFrac * 1.6f;
                Direction cullFace = null;
                int tintIndex = 0;
                int xSize = MathHelper.func_76136_a((Random)this.rand, (int)this.minXSize, (int)this.maxXSize);
                int zSize = MathHelper.func_76136_a((Random)this.rand, (int)this.minZSize, (int)this.maxZSize);
                int minU = MathHelper.func_76136_a((Random)this.rand, (int)0, (int)(16 - xSize));
                int minV = MathHelper.func_76136_a((Random)this.rand, (int)0, (int)(16 - zSize));
                int maxU = minU + xSize;
                int maxV = minV + zSize;
                BlockFaceUV faceUV = new BlockFaceUV(new float[]{minU, minV, maxU, maxV}, 0);
                BlockPartFace upFace = new BlockPartFace(cullFace, tintIndex, texture, faceUV);
                ImmutableMap mapFaces = ImmutableMap.of((Object)Direction.UP, (Object)upFace);
                float halfXSize = (float)xSize / 2.0f;
                float halfZSize = (float)zSize / 2.0f;
                Vector3f posFrom = new Vector3f(posX - halfXSize, posY, posX - halfZSize);
                Vector3f posTo = new Vector3f(posX + halfXSize, posY, posX + halfZSize);
                float rotAngle = this.rand.nextFloat() * 360.0f;
                Vector3f rotOrigin = new Vector3f(0.5f, 0.5f, 0.5f);
                boolean rescale = false;
                BlockPartRotation rotation = new BlockPartRotation(rotOrigin, Direction.Axis.Y, rotAngle, rescale);
                boolean shade = false;
                return new BlockPart(posFrom, posTo, (Map)mapFaces, rotation, shade);
            }).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }
}

