/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.scatter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lotr.client.render.model.BlockModelQuadsHolder;
import lotr.client.render.model.scatter.ScatterBlockModel;
import lotr.client.render.model.scatter.ScatterModelGenerator;
import lotr.common.LOTRLog;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;

public class ScatterUnbakedModel
implements ISimpleModelGeometry<ScatterUnbakedModel> {
    private static final String ALL_TEXTURE = "all";
    private final ScatterModelGenerator scatterModelGenerator;
    private final int numVariants = 100;

    public ScatterUnbakedModel(ScatterModelGenerator scatterModelGenerator) {
        this.scatterModelGenerator = scatterModelGenerator;
    }

    public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        List<List<BlockPart>> unbakedModelVariants = this.scatterModelGenerator.generateNRandomModels(100, ALL_TEXTURE);
        for (List<BlockPart> variant : unbakedModelVariants) {
            ArrayList generalQuads = Lists.newArrayList();
            EnumMap builderFaceQuads = Maps.newEnumMap(Direction.class);
            for (Direction dir : Direction.values()) {
                builderFaceQuads.put(dir, Lists.newArrayList());
            }
            for (BlockPart blockpart : variant) {
                for (Direction direction : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                    Material material = owner.resolveTexture(blockpartface.field_178242_d);
                    TextureAtlasSprite icon = spriteGetter.apply(material);
                    if (blockpartface.field_178244_b == null) {
                        generalQuads.add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                        continue;
                    }
                    ((List)builderFaceQuads.get(modelTransform.func_225615_b_().rotateTransform(blockpartface.field_178244_b))).add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                }
            }
            BlockModelQuadsHolder bakedVariant = new BlockModelQuadsHolder(generalQuads, builderFaceQuads);
            ((Builder)modelBuilder).addVariantModel(bakedVariant);
        }
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Material allTexture = owner.resolveTexture(ALL_TEXTURE);
        if (Objects.equals(allTexture.func_229310_a_().toString(), MissingTextureSprite.func_195675_b().toString())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)ALL_TEXTURE, (Object)owner.getModelName()));
        }
        return ImmutableSet.of((Object)allTexture);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        Builder builder = new Builder(owner, overrides).setParticle(particle);
        this.addQuads(owner, builder, bakery, spriteGetter, modelTransform, modelLocation);
        return builder.build();
    }

    public static final class Builder
    implements IModelBuilder {
        private final List<BlockModelQuadsHolder> scatterVariantModels = new ArrayList<BlockModelQuadsHolder>();
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite particleTexture;
        private final boolean isSideLight;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;

        public Builder(IModelConfiguration model, ItemOverrideList overrides) {
            this(model.useSmoothLighting(), model.isShadedInGui(), model.isSideLit(), model.getCameraTransforms(), overrides);
        }

        public Builder(BlockModel model, ItemOverrideList overrides, boolean g3d) {
            this(model.func_178309_b(), model.func_230176_c_().func_230178_a_(), g3d, model.func_181682_g(), overrides);
        }

        private Builder(boolean ambOcc, boolean sideLight, boolean g3d, ItemCameraTransforms transform, ItemOverrideList overrides) {
            this.builderItemOverrideList = overrides;
            this.builderAmbientOcclusion = false;
            this.isSideLight = sideLight;
            this.builderGui3d = g3d;
            this.builderCameraTransforms = transform;
        }

        public Builder addFaceQuad(Direction facing, BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder list instead");
        }

        public Builder addGeneralQuad(BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder list instead");
        }

        public Builder addVariantModel(BlockModelQuadsHolder variantModel) {
            this.scatterVariantModels.add(variantModel);
            return this;
        }

        public Builder setParticle(TextureAtlasSprite texture) {
            this.particleTexture = texture;
            return this;
        }

        public IBakedModel build() {
            if (this.particleTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new ScatterBlockModel(this.scatterVariantModels, this.builderAmbientOcclusion, this.isSideLight, this.builderGui3d, this.particleTexture, this.builderCameraTransforms, this.builderItemOverrideList);
        }
    }

    public static final class Loader
    implements IModelLoader<ScatterUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ScatterUnbakedModel read(JsonDeserializationContext deserializationContext, JsonObject modelObj) {
            ScatterModelGenerator modelGenerator = null;
            if (modelObj.has("scatter_properties")) {
                modelGenerator = ScatterModelGenerator.parse(modelObj.get("scatter_properties").getAsJsonObject());
            }
            if (modelObj.has("parent")) {
                IUnbakedModel parentModel;
                String parent = modelObj.get("parent").getAsString();
                ResourceLocation parentLocation = new ResourceLocation(parent);
                HashSet<ResourceLocation> parentModels = new HashSet<ResourceLocation>();
                parentModels.add(parentLocation);
                while (parentLocation != null && (parentModel = ModelLoader.instance().func_209597_a(parentLocation)) instanceof BlockModel) {
                    ScatterUnbakedModel parentScatterModel;
                    BlockModel blockModel = (BlockModel)parentModel;
                    if (modelGenerator == null && blockModel.customData.getCustomGeometry() instanceof ScatterUnbakedModel && (parentScatterModel = (ScatterUnbakedModel)blockModel.customData.getCustomGeometry()).scatterModelGenerator != null) {
                        modelGenerator = parentScatterModel.scatterModelGenerator;
                    }
                    if (!parentModels.contains(parentLocation = blockModel.getParentLocation())) continue;
                    LOTRLog.error("Circular reference in scatter model 'parent' tree: %s already present", parentLocation);
                    break;
                }
            }
            if (modelGenerator == null) {
                throw new IllegalArgumentException("Model does not define any scatter_properties or inherit from parent");
            }
            return new ScatterUnbakedModel(modelGenerator);
        }
    }
}

