/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.util.LOTRUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;

public class LOTRGameRules {
    public static GameRules.RuleKey<GameRules.BooleanValue> ORC_SKIRMISH;
    public static GameRules.RuleKey<GameRules.BooleanValue> MIDDLE_EARTH_RESPAWNING;
    public static GameRules.RuleKey<GameRules.BooleanValue> FAST_TRAVEL;
    public static GameRules.RuleKey<GameRules.BooleanValue> CUSTOM_WAYPOINT_CREATION;
    public static GameRules.RuleKey<GameRules.IntegerValue> GONDOR_BEACON_RANGE;
    public static GameRules.RuleKey<GameRules.IntegerValue> GONDOR_BEACON_LIGHTING_TIME;

    public static void registerAll() {
        ORC_SKIRMISH = LOTRGameRules.register("orc_skirmish", LOTRGameRules.createBoolean(true));
        MIDDLE_EARTH_RESPAWNING = LOTRGameRules.register("middle_earth_respawning", LOTRGameRules.createBoolean(true));
        FAST_TRAVEL = LOTRGameRules.register("fast_travel", LOTRGameRules.createBoolean(true));
        CUSTOM_WAYPOINT_CREATION = LOTRGameRules.register("custom_waypoint_creation", LOTRGameRules.createBoolean(true));
        GONDOR_BEACON_RANGE = LOTRGameRules.register("gondor_beacon_range", LOTRGameRules.createInt(80));
        GONDOR_BEACON_LIGHTING_TIME = LOTRGameRules.register("gondor_beacon_lighting_time", LOTRGameRules.createInt(100));
    }

    private static <T extends GameRules.RuleValue<T>> GameRules.RuleKey<T> register(String ruleName, GameRules.RuleType<T> type) {
        String namespacedName = new ResourceLocation("lotr", ruleName).toString();
        GameRules.RuleKey ruleKey = GameRules.func_223595_a((String)namespacedName, type);
        return ruleKey;
    }

    private static GameRules.RuleType<GameRules.BooleanValue> createBoolean(boolean defaultValue) {
        Supplier<ArgumentType<?>> argTypeSupplier = () -> BoolArgumentType.bool();
        Function<GameRules.RuleType, GameRules.BooleanValue> valueCreator = type -> new GameRules.BooleanValue(type, defaultValue);
        BiConsumer<MinecraftServer, GameRules.BooleanValue> changeListener = (server, boolVal) -> {};
        return LOTRGameRules.createRuleType(argTypeSupplier, valueCreator, changeListener);
    }

    private static GameRules.RuleType<GameRules.IntegerValue> createInt(int defaultValue) {
        Supplier<ArgumentType<?>> argTypeSupplier = () -> IntegerArgumentType.integer();
        Function<GameRules.RuleType, GameRules.IntegerValue> valueCreator = type -> new GameRules.IntegerValue(type, defaultValue);
        BiConsumer<MinecraftServer, GameRules.IntegerValue> changeListener = (server, intVal) -> {};
        return LOTRGameRules.createRuleType(argTypeSupplier, valueCreator, changeListener);
    }

    private static <T extends GameRules.RuleValue<T>> GameRules.RuleType<T> createRuleType(Supplier<ArgumentType<?>> argTypeSupplier, Function<GameRules.RuleType<T>, T> valueCreator, BiConsumer<MinecraftServer, T> changeListener) {
        try {
            Constructor ctr = GameRules.RuleType.class.getDeclaredConstructor(Supplier.class, Function.class, BiConsumer.class);
            LOTRUtil.unlockConstructor(ctr);
            return (GameRules.RuleType)ctr.newInstance(argTypeSupplier, valueCreator, changeListener);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOTRLog.error("Error creating new gamerule");
            throw new RuntimeException(e);
        }
    }
}

