/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import lotr.client.LOTRClientProxy;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.LOTRProxy;
import lotr.common.LOTRServerProxy;
import lotr.common.command.LOTRArgumentTypes;
import lotr.common.config.LOTRConfig;
import lotr.common.datafix.LOTRItemRemappings;
import lotr.common.event.LOTREventHandler;
import lotr.common.event.LOTRTickHandlerServer;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRCommands;
import lotr.common.init.LOTRContainers;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRLootModifiers;
import lotr.common.init.LOTRParticles;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.init.LOTRTileEntities;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.stat.LOTRStats;
import lotr.common.world.fac.FactionSettingsManager;
import lotr.common.world.gen.carver.LOTRWorldCarvers;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;

@Mod(value="lotr")
public class LOTRMod {
    public static final String MOD_ID = "lotr";
    public static LOTRProxy proxy = (LOTRProxy)DistExecutor.safeRunForDist(() -> LOTRClientProxy::new, () -> LOTRServerProxy::new);
    private static LOTREventHandler eventHandler;
    public static LOTRTickHandlerServer serverTickHandler;

    public LOTRMod() {
        LOTRLog.find();
        IEventBus fmlBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        fmlBus.register((Object)this);
        forgeBus.register((Object)this);
        fmlBus.register((Object)proxy);
        forgeBus.register((Object)proxy);
        LOTRConfig.register(fmlBus);
        LOTRBlocks.register();
        LOTRItems.register();
        LOTREntities.register();
        LOTRTileEntities.register();
        LOTRParticles.register();
        LOTRContainers.register();
        LOTRRecipes.register();
        LOTRBiomes.register();
        LOTRWorldCarvers.register();
        LOTRFeatures.register();
        LOTRDimensions.register();
        LOTRWorldTypes.create();
        LOTRArgumentTypes.registerTypes();
        LOTRPacketHandler.register();
        LOTRStats.setup();
        LOTRGameRules.registerAll();
        LOTRSoundEvents.register();
        LOTRLootModifiers.register();
        eventHandler = new LOTREventHandler();
        serverTickHandler = new LOTRTickHandlerServer();
    }

    @SubscribeEvent
    public void missingMappings(RegistryEvent.MissingMappings event) {
        LOTRItemRemappings.handle(event);
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        MapSettingsManager.serverInstance().registerToServer(server);
        FactionSettingsManager.serverInstance().registerToServer(server);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        LOTRCommands.registerCommands(event.getServer(), (CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public static ModContainer getModContainer() {
        return (ModContainer)ModList.get().getModContainerById(MOD_ID).get();
    }

    public static InputStream getModResourceStream(ResourcePackType type, ResourceLocation res) {
        try {
            ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)MOD_ID).get();
            return lotrAsPack.func_195761_a(type, res);
        }
        catch (NoSuchElementException e) {
            LOTRLog.error("Error loading mod resource - resource does not exist!");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            LOTRLog.error("IOException loading mod resource");
            e.printStackTrace();
            return null;
        }
    }

    public static boolean modResourceExists(ResourcePackType type, ResourceLocation res) {
        ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)MOD_ID).get();
        return lotrAsPack.func_195764_b(type, res);
    }
}

