/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.block.LOTRBlockStates;
import lotr.common.block.LOTRSlabBlock;
import lotr.common.block.VerticalOnlySlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class AxialSlabBlock
extends LOTRSlabBlock {
    public static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AxialSlabBlock(Block block) {
        super(block);
        Direction.Axis defaultAxis = this.getSlabAxisProperty().func_177700_c().contains(Direction.Axis.Y) ? Direction.Axis.Y : Direction.Axis.X;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(this.getSlabAxisProperty(), (Comparable)defaultAxis));
    }

    public AxialSlabBlock(Supplier<Block> block) {
        this(block.get());
    }

    protected EnumProperty<Direction.Axis> getSlabAxisProperty() {
        return LOTRBlockStates.SLAB_AXIS;
    }

    protected boolean canDoubleSlabBeWaterlogged() {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{this.getSlabAxisProperty()});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        SlabType slabType = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        if (slabType == SlabType.DOUBLE) {
            return VoxelShapes.func_197868_b();
        }
        boolean top = slabType == SlabType.TOP;
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(this.getSlabAxisProperty());
        if (axis == Direction.Axis.Y) {
            return top ? SlabBlock.field_196507_c : SlabBlock.field_196506_b;
        }
        if (axis == Direction.Axis.X) {
            return top ? EAST_SHAPE : WEST_SHAPE;
        }
        if (axis == Direction.Axis.Z) {
            return top ? SOUTH_SHAPE : NORTH_SHAPE;
        }
        return VoxelShapes.func_197868_b();
    }

    private static Direction.Axis getSlabAxis(BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof SlabBlock) {
            for (IProperty prop : state.func_206869_a()) {
                if (!(prop instanceof EnumProperty) || ((EnumProperty)prop).func_177699_b() != Direction.Axis.class) continue;
                return (Direction.Axis)state.func_177229_b(prop);
            }
            if (block.getClass() == SlabBlock.class) {
                return Direction.Axis.Y;
            }
            LOTRLog.warn("Unknown SlabBlock subclass: %s with no axis-based property. Assuming axis = Y", block.getClass().toString());
            return Direction.Axis.Y;
        }
        throw new IllegalArgumentException("This method should only get called on known instances of SlabBlock");
    }

    protected boolean isSameSlab(SlabBlock otherSlab) {
        return otherSlab == this;
    }

    protected final boolean isSameSlab(BlockState otherBlockState) {
        Block otherBlock = otherBlockState.func_177230_c();
        return otherBlock instanceof SlabBlock && this.isSameSlab((SlabBlock)otherBlock);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        AxialSlabPlacement placement = this.getSlabPlacementState(context);
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(this.getSlabAxisProperty(), (Comparable)placement.axis)).func_206870_a((IProperty)field_196505_a, (Comparable)placement.slabType)).func_206870_a((IProperty)field_204512_b, (Comparable)Boolean.valueOf(placement.waterlogged));
    }

    protected final AxialSlabPlacement getSlabPlacementState(BlockItemUseContext context) {
        boolean waterlogged;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Direction dir = context.func_196000_l();
        Direction.Axis axis = dir.func_176740_k();
        IFluidState fluid = context.func_195991_k().func_204610_c(pos);
        boolean bl = waterlogged = fluid.func_206886_c() == Fluids.field_204546_a;
        if (this.isSameSlab(state)) {
            return AxialSlabPlacement.of(AxialSlabBlock.getSlabAxis(state), SlabType.DOUBLE, waterlogged &= this.canDoubleSlabBeWaterlogged());
        }
        BlockPos clickedPos = pos.func_177972_a(dir.func_176734_d());
        BlockState clickedState = world.func_180495_p(clickedPos);
        boolean sneaking = context.func_225518_g_();
        if (sneaking) {
            if (axis.func_176722_c()) {
                axis = Direction.Axis.Y;
            } else if (!(!axis.func_200128_b() || clickedState.func_177230_c() instanceof SlabBlock && AxialSlabBlock.getSlabAxis(clickedState).func_176722_c())) {
                dir = context.func_195992_f();
                axis = dir.func_176740_k();
            }
        } else if (clickedState.func_177230_c() instanceof SlabBlock && clickedState.func_177229_b((IProperty)field_196505_a) != SlabType.DOUBLE) {
            axis = AxialSlabBlock.getSlabAxis(clickedState);
        }
        Direction axisPosDir = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Direction axisNegDir = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
        double relevantHitVecCoord = axis.func_196051_a(context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c);
        double relevantPosCoord = axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (!(dir == axisNegDir || dir != axisPosDir && relevantHitVecCoord - relevantPosCoord > 0.5)) {
            return AxialSlabPlacement.of(axis, SlabType.BOTTOM, waterlogged);
        }
        return AxialSlabPlacement.of(axis, SlabType.TOP, waterlogged);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return this.isSlabReplaceable(state, context);
    }

    protected final boolean isSlabReplaceable(BlockState state, BlockItemUseContext context) {
        BlockPos offsetPos;
        Block itemBlock;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack itemstack = context.func_195996_i();
        boolean holdingSameSlab = false;
        if (itemstack.func_77973_b() instanceof BlockItem && (itemBlock = ((BlockItem)itemstack.func_77973_b()).func_179223_d()) instanceof SlabBlock) {
            holdingSameSlab = this.isSameSlab((SlabBlock)itemBlock);
        }
        Direction dir = context.func_196000_l();
        boolean sneaking = context.func_225518_g_();
        SlabType slabType = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        Direction.Axis existingAxis = AxialSlabBlock.getSlabAxis(state);
        if (sneaking && existingAxis != Direction.Axis.Y && world.func_180495_p(offsetPos = pos.func_177972_a(dir)).func_196953_a((BlockItemUseContext)AxialSlabUseContext.makeReplacementContext(context, offsetPos, dir))) {
            return false;
        }
        if (slabType != SlabType.DOUBLE && holdingSameSlab) {
            if (context.func_196012_c()) {
                double relevantPosCoord;
                boolean flag;
                double relevantHitVecCoord = existingAxis.func_196051_a(context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c);
                boolean bl = flag = relevantHitVecCoord - (relevantPosCoord = (double)existingAxis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) > 0.5;
                if (slabType == SlabType.BOTTOM) {
                    return dir == Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)existingAxis) || flag && dir.func_176740_k() != existingAxis;
                }
                return dir == Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)existingAxis) || !flag && dir.func_176740_k() != existingAxis;
            }
            return true;
        }
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        SlabType slabType = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(this.getSlabAxisProperty());
        Direction.AxisDirection axisDir = slabType == SlabType.BOTTOM ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE;
        Direction dir = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)axisDir);
        Direction rotatedDir = rot.func_185831_a(dir);
        Direction.Axis rotatedAxis = rotatedDir.func_176740_k();
        Direction.AxisDirection rotatedAxisDir = rotatedDir.func_176743_c();
        if (this.getSlabAxisProperty().func_177700_c().contains(rotatedAxis)) {
            SlabType rotatedSlabType = slabType == SlabType.DOUBLE ? slabType : (rotatedAxisDir == Direction.AxisDirection.NEGATIVE ? SlabType.BOTTOM : (rotatedAxisDir == Direction.AxisDirection.POSITIVE ? SlabType.TOP : slabType));
            return (BlockState)((BlockState)state.func_206870_a(this.getSlabAxisProperty(), (Comparable)rotatedAxis)).func_206870_a((IProperty)field_196505_a, (Comparable)rotatedSlabType);
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(this.getSlabAxisProperty());
        SlabType type = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        if (mirror == Mirror.LEFT_RIGHT && axis == Direction.Axis.Z || mirror == Mirror.FRONT_BACK && axis == Direction.Axis.X) {
            if (type == SlabType.BOTTOM) {
                type = SlabType.TOP;
            } else if (type == SlabType.TOP) {
                type = SlabType.BOTTOM;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)field_196505_a, (Comparable)type);
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidState) {
        if (this.canDoubleSlabBeWaterlogged()) {
            return new DefaultImplWaterLoggable().func_204509_a(world, pos, state, fluidState);
        }
        return super.func_204509_a(world, pos, state, fluidState);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.canDoubleSlabBeWaterlogged()) {
            return new DefaultImplWaterLoggable().func_204510_a(world, pos, state, fluid);
        }
        return super.func_204510_a(world, pos, state, fluid);
    }

    private final class DefaultImplWaterLoggable
    implements IWaterLoggable {
        private DefaultImplWaterLoggable() {
        }
    }

    protected static class AxialSlabUseContext
    extends BlockItemUseContext {
        protected AxialSlabUseContext(World w, PlayerEntity pl, Hand h, ItemStack stack, BlockRayTraceResult rayTrace) {
            super(w, pl, h, stack, rayTrace);
            SlabBlock slabBlock;
            VerticalOnlySlabBlock verticalSlab;
            BlockState state = this.field_196006_g.func_180495_p(rayTrace.func_216350_a());
            if (state.func_177230_c() instanceof SlabBlock && (verticalSlab = VerticalOnlySlabBlock.getVerticalSlabFor(slabBlock = (SlabBlock)state.func_177230_c())) != null) {
                this.field_196013_a = verticalSlab.func_196253_a(state, this);
            }
        }

        public AxialSlabUseContext(ItemUseContext context) {
            super(context);
        }

        public static AxialSlabUseContext makeReplacementContext(BlockItemUseContext context, BlockPos pos, Direction dir) {
            Vec3d blockVec = new Vec3d((double)pos.func_177958_n() + 0.5 + (double)dir.func_82601_c() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)dir.func_96559_d() * 0.5, (double)pos.func_177952_p() + 0.5 + (double)dir.func_82599_e() * 0.5);
            BlockRayTraceResult rayTrace = new BlockRayTraceResult(blockVec, dir, pos, false);
            return new AxialSlabUseContext(context.func_195991_k(), context.func_195999_j(), context.func_221531_n(), context.func_195996_i(), rayTrace);
        }
    }

    public static class AxialSlabPlacement {
        public final Direction.Axis axis;
        public final SlabType slabType;
        public final boolean waterlogged;

        private AxialSlabPlacement(Direction.Axis ax, SlabType type, boolean water) {
            this.axis = ax;
            this.slabType = type;
            this.waterlogged = water;
        }

        public static AxialSlabPlacement of(Direction.Axis ax, SlabType type, boolean water) {
            return new AxialSlabPlacement(ax, type, water);
        }
    }
}

