/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.function.Supplier;
import lotr.common.block.LOTRBlockStates;
import lotr.common.block.LOTRStoneBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BrickWithAboveBlock
extends LOTRStoneBlock {
    public static final BooleanProperty ABOVE = LOTRBlockStates.BRICK_ABOVE;
    private final Tag<Block> alikeBlocks;

    public BrickWithAboveBlock(MaterialColor materialColor, Tag<Block> blocks) {
        super(materialColor);
        this.alikeBlocks = blocks;
        this.initBrickWithAbove();
    }

    public BrickWithAboveBlock(Supplier<Block> blockSup, Tag<Block> blocks) {
        super(blockSup);
        this.alikeBlocks = blocks;
        this.initBrickWithAbove();
    }

    private void initBrickWithAbove() {
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)ABOVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{ABOVE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(abovePos);
        return this.checkAboveBlock((IWorld)world, pos, state, abovePos, aboveState);
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (dir == Direction.UP) {
            return this.checkAboveBlock(world, currentPos, state, facingPos, facingState);
        }
        return super.func_196271_a(state, dir, facingState, world, currentPos, facingPos);
    }

    private BlockState checkAboveBlock(IWorld world, BlockPos pos, BlockState state, BlockPos abovePos, BlockState aboveState) {
        boolean hasAbove = aboveState.func_203425_a(this.alikeBlocks) && aboveState.func_224755_d((IBlockReader)world, abovePos, Direction.DOWN);
        return (BlockState)state.func_206870_a((IProperty)ABOVE, (Comparable)Boolean.valueOf(hasAbove));
    }
}

