/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import lotr.common.block.LOTRBlockMaterial;
import lotr.common.init.LOTRBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBeaconBeamColorProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class CrystalBlock
extends Block
implements IWaterLoggable,
IBeaconBeamColorProvider {
    public static final EnumProperty<Direction> CRYSTAL_FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE_UP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)1.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)15.0);
    private final DyeColor beaconBeamColor;

    public CrystalBlock(Block.Properties properties, DyeColor color) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(CRYSTAL_FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.beaconBeamColor = color;
    }

    public CrystalBlock(int light, int harvestLvl, DyeColor color) {
        this(Block.Properties.func_200945_a((Material)LOTRBlockMaterial.CRYSTAL).func_200948_a(3.0f, 3.0f).func_226896_b_().func_200951_a(light).func_200947_a(SoundType.field_185853_f).harvestTool(ToolType.PICKAXE).harvestLevel(harvestLvl), color);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CRYSTAL_FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction crystalFacing = (Direction)state.func_177229_b(CRYSTAL_FACING);
        switch (crystalFacing) {
            default: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: 
        }
        return SHAPE_SOUTH;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(CRYSTAL_FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction crystalFacing;
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == (crystalFacing = (Direction)state.func_177229_b(CRYSTAL_FACING)).func_176734_d() && !this.func_196260_a(state, (IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction crystalFacing = (Direction)state.func_177229_b(CRYSTAL_FACING);
        BlockPos supportPos = pos.func_177972_a(crystalFacing.func_176734_d());
        BlockState supportState = world.func_180495_p(supportPos);
        return Block.func_220056_d((BlockState)supportState, (IBlockReader)world, (BlockPos)supportPos, (Direction)crystalFacing);
    }

    protected int getExperience(Random rand) {
        if (this == LOTRBlocks.GLOWSTONE_CRYSTAL.get()) {
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)4);
        }
        if (this == LOTRBlocks.EDHELVIR_CRYSTAL.get()) {
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        }
        if (this == LOTRBlocks.GULDURIL_CRYSTAL.get()) {
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        }
        return 0;
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? this.getExperience(this.RANDOM) : 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a(CRYSTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b(CRYSTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b(CRYSTAL_FACING)));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public DyeColor func_196457_d() {
        return this.beaconBeamColor;
    }
}

