/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import lotr.common.block.LOTRBlockStates;
import lotr.common.init.LOTRDamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DripstoneBlock
extends Block
implements IWaterLoggable {
    public static final Map<Block, DripstoneBlock> BLOCK_TO_DRIPSTONE = new HashMap<Block, DripstoneBlock>();
    public static final EnumProperty<Type> DRIPSTONE_TYPE = LOTRBlockStates.DRIPSTONE_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape STALACTITE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.5, (double)8.0, (double)5.5, (double)10.5, (double)12.0, (double)10.5), Block.func_208617_a((double)6.5, (double)4.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5), Block.func_208617_a((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)4.0, (double)8.5)});
    private static final VoxelShape STALAGMITE_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)4.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.5, (double)4.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5), Block.func_208617_a((double)6.5, (double)8.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)7.5, (double)12.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5)});
    private static final VoxelShape STALACTITE_DOUBLE_BASE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0));
    private static final VoxelShape STALACTITE_DOUBLE_POINT_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0));
    private static final VoxelShape STALAGMITE_DOUBLE_BASE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    private static final VoxelShape STALAGMITE_DOUBLE_POINT_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    private final Block modelBlock;
    private final IParticleData particleType;
    public final boolean isWaterloggable;

    public DripstoneBlock(Block block, IParticleData particle, boolean waterlog) {
        super(Block.Properties.func_200950_a((Block)block).func_226896_b_());
        this.modelBlock = block;
        this.particleType = particle;
        this.isWaterloggable = waterlog;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BLOCK_TO_DRIPSTONE.put(block, this);
    }

    public DripstoneBlock(Block block) {
        this(block, true);
    }

    public DripstoneBlock(Block block, IParticleData particle) {
        this(block, particle, true);
    }

    public DripstoneBlock(Block block, boolean waterlog) {
        this(block, (IParticleData)ParticleTypes.field_197618_k, waterlog);
    }

    public DripstoneBlock(Supplier<Block> blockSup) {
        this(blockSup.get());
    }

    public DripstoneBlock(Supplier<Block> blockSup, IParticleData particle) {
        this(blockSup.get(), particle);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{DRIPSTONE_TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Type)((Object)state.func_177229_b(DRIPSTONE_TYPE))) {
            case STALACTITE: {
                return STALACTITE_SHAPE;
            }
            default: {
                return STALAGMITE_SHAPE;
            }
            case STALACTITE_DOUBLE_BASE: {
                return STALACTITE_DOUBLE_BASE_SHAPE;
            }
            case STALACTITE_DOUBLE_POINT: {
                return STALACTITE_DOUBLE_POINT_SHAPE;
            }
            case STALAGMITE_DOUBLE_BASE: {
                return STALAGMITE_DOUBLE_BASE_SHAPE;
            }
            case STALAGMITE_DOUBLE_POINT: 
        }
        return STALAGMITE_DOUBLE_POINT_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction hitFace;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        BlockState placeState = this.func_176223_P();
        if (this.isWaterloggable) {
            IFluidState fluid = context.func_195991_k().func_204610_c(pos);
            placeState = (BlockState)placeState.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        }
        boolean pointingDown = !((hitFace = context.func_196000_l()) == Direction.DOWN || hitFace != Direction.UP && context.func_221532_j().field_72448_b - (double)pos.func_177956_o() > 0.5);
        BlockState stalagmiteDouble = (BlockState)placeState.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALAGMITE_DOUBLE_POINT));
        BlockState stalactiteDouble = (BlockState)placeState.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE_DOUBLE_POINT));
        boolean stalagmiteDoubleValid = stalagmiteDouble.func_196955_c((IWorldReader)world, pos);
        boolean stalactiteDoubleValid = stalactiteDouble.func_196955_c((IWorldReader)world, pos);
        if (stalagmiteDoubleValid && stalactiteDoubleValid) {
            if (pointingDown) {
                return stalagmiteDouble;
            }
            return stalactiteDouble;
        }
        if (stalagmiteDoubleValid && pointingDown) {
            return stalagmiteDouble;
        }
        if (stalactiteDoubleValid && !pointingDown) {
            return stalactiteDouble;
        }
        BlockState stalagmite = (BlockState)placeState.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALAGMITE));
        BlockState stalactite = (BlockState)placeState.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE));
        boolean stalagmiteValid = stalagmite.func_196955_c((IWorldReader)world, pos);
        boolean stalactiteValid = stalactite.func_196955_c((IWorldReader)world, pos);
        if (stalagmiteValid && stalactiteValid) {
            if (pointingDown) {
                return stalagmite;
            }
            return stalactite;
        }
        if (stalagmiteValid) {
            return stalagmite;
        }
        if (stalactiteValid) {
            return stalactite;
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (this.isWaterloggable && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        boolean check = false;
        Type type = (Type)((Object)state.func_177229_b(DRIPSTONE_TYPE));
        if (type == Type.STALACTITE && facing == Direction.UP) {
            check = true;
        } else if (type == Type.STALAGMITE && facing == Direction.DOWN) {
            check = true;
        } else if (!(type != Type.STALACTITE_DOUBLE_BASE && type != Type.STALACTITE_DOUBLE_POINT && type != Type.STALAGMITE_DOUBLE_BASE && type != Type.STALAGMITE_DOUBLE_POINT || facing != Direction.DOWN && facing != Direction.UP)) {
            check = true;
        }
        if (check && !state.func_196955_c((IWorldReader)world, currentPos)) {
            BlockState singleState;
            if (type == Type.STALACTITE_DOUBLE_BASE) {
                BlockState singleState2 = (BlockState)state.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE));
                if (singleState2.func_196955_c((IWorldReader)world, currentPos)) {
                    return singleState2;
                }
            } else if (type == Type.STALAGMITE_DOUBLE_BASE && (singleState = (BlockState)state.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALAGMITE))).func_196955_c((IWorldReader)world, currentPos)) {
                return singleState;
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (type == Type.STALAGMITE && facing == Direction.UP && this.matchType((IWorldReader)world, currentPos.func_177984_a(), Type.STALAGMITE_DOUBLE_POINT)) {
            return (BlockState)state.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALAGMITE_DOUBLE_BASE));
        }
        if (type == Type.STALACTITE && facing == Direction.DOWN && this.matchType((IWorldReader)world, currentPos.func_177977_b(), Type.STALACTITE_DOUBLE_POINT)) {
            return (BlockState)state.func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE_DOUBLE_BASE));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        boolean isPresent = world.func_180495_p(pos).func_177230_c() == this;
        Type type = (Type)((Object)state.func_177229_b(DRIPSTONE_TYPE));
        if (type == Type.STALACTITE) {
            return this.checkSolidSide(world, pos.func_177984_a(), Direction.DOWN);
        }
        if (type == Type.STALAGMITE) {
            return this.checkSolidSide(world, pos.func_177977_b(), Direction.UP);
        }
        if (type == Type.STALACTITE_DOUBLE_BASE) {
            return this.checkSolidSide(world, pos.func_177984_a(), Direction.DOWN) && this.matchType(world, pos.func_177977_b(), Type.STALACTITE_DOUBLE_POINT);
        }
        if (type == Type.STALACTITE_DOUBLE_POINT) {
            return isPresent ? this.matchType(world, pos.func_177984_a(), Type.STALACTITE_DOUBLE_BASE) : this.matchType(world, pos.func_177984_a(), Type.STALACTITE);
        }
        if (type == Type.STALAGMITE_DOUBLE_BASE) {
            return this.checkSolidSide(world, pos.func_177977_b(), Direction.UP) && this.matchType(world, pos.func_177984_a(), Type.STALAGMITE_DOUBLE_POINT);
        }
        if (type == Type.STALAGMITE_DOUBLE_POINT) {
            return isPresent ? this.matchType(world, pos.func_177977_b(), Type.STALAGMITE_DOUBLE_BASE) : this.matchType(world, pos.func_177977_b(), Type.STALAGMITE);
        }
        return true;
    }

    private boolean checkSolidSide(IWorldReader world, BlockPos pos, Direction dir) {
        BlockState state = world.func_180495_p(pos);
        return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)dir) || dir.func_176740_k().func_200128_b() && state.func_177230_c() instanceof WallBlock;
    }

    private boolean matchType(IWorldReader world, BlockPos pos, Type type) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && state.func_177229_b(DRIPSTONE_TYPE) == type;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() == this.func_199767_j()) {
            boolean canDouble;
            BlockItemUseContext useContext = new BlockItemUseContext(new ItemUseContext(player, hand, trace));
            Type type = (Type)((Object)state.func_177229_b(DRIPSTONE_TYPE));
            BlockPos placePos = null;
            BlockState placeState = null;
            if (type == Type.STALACTITE) {
                placePos = pos.func_177977_b();
                placeState = (BlockState)this.func_176223_P().func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALACTITE_DOUBLE_POINT));
            } else if (type == Type.STALAGMITE) {
                placePos = pos.func_177984_a();
                placeState = (BlockState)this.func_176223_P().func_206870_a(DRIPSTONE_TYPE, (Comparable)((Object)Type.STALAGMITE_DOUBLE_POINT));
            }
            if (placePos != null && placeState != null && (canDouble = world.func_180495_p(placePos).func_196953_a(useContext))) {
                BlockState placeStateFull = placeState;
                if (this.isWaterloggable) {
                    placeStateFull = (BlockState)placeStateFull.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(placePos).func_206886_c() == Fluids.field_204546_a));
                }
                world.func_180501_a(placePos, placeStateFull, 3);
                SoundType sound = this.getSoundType(placeStateFull, (IWorldReader)world, placePos, (Entity)player);
                world.func_184133_a(player, placePos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, trace);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        BlockPos belowPos;
        BlockState below;
        BlockPos abovePos;
        BlockState above;
        this.modelBlock.func_180655_c(state, world, pos, rand);
        Type type = (Type)((Object)state.func_177229_b(DRIPSTONE_TYPE));
        if (!(type != Type.STALACTITE && type != Type.STALACTITE_DOUBLE_POINT || rand.nextInt(50) != 0 || !(above = world.func_180495_p(abovePos = pos.func_177984_a())).func_200015_d((IBlockReader)world, abovePos) || above.func_185904_a() != Material.field_151576_e || (below = world.func_180495_p(belowPos = pos.func_177977_b())).func_200132_m() && below.func_224755_d((IBlockReader)world, belowPos, Direction.UP))) {
            world.func_195594_a(this.particleType, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.05, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        Type type;
        if (entity instanceof LivingEntity && ((type = (Type)((Object)world.func_180495_p(pos).func_177229_b(DRIPSTONE_TYPE))) == Type.STALAGMITE || type == Type.STALAGMITE_DOUBLE_POINT)) {
            float damage = fallDistance * 2.0f + 1.0f;
            entity.func_70097_a(LOTRDamageSources.STALAGMITE, damage);
        }
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        if (!this.isWaterloggable) {
            return true;
        }
        return super.func_225541_a_(state, fluid);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public IFluidState func_204507_t(BlockState state) {
        if (this.isWaterloggable && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.isWaterloggable) {
            return super.func_204510_a(world, pos, state, fluid);
        }
        return false;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluid) {
        if (this.isWaterloggable) {
            return super.func_204509_a(world, pos, state, fluid);
        }
        return false;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (this.isWaterloggable) {
            return super.func_204508_a(world, pos, state);
        }
        return Fluids.field_204541_a;
    }

    public static enum Type implements IStringSerializable
    {
        STALACTITE("stalactite"),
        STALAGMITE("stalagmite"),
        STALACTITE_DOUBLE_BASE("stalactite_double_base"),
        STALACTITE_DOUBLE_POINT("stalactite_double_point"),
        STALAGMITE_DOUBLE_BASE("stalagmite_double_base"),
        STALAGMITE_DOUBLE_POINT("stalagmite_double_point");

        private final String typeName;

        private Type(String s) {
            this.typeName = s;
        }

        public String func_176610_l() {
            return this.typeName;
        }
    }
}

