/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import java.util.function.Supplier;
import lotr.common.event.CompostingHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LOTRLeavesBlock
extends LeavesBlock {
    private Supplier<? extends IParticleData> fallingParticle;
    private int fallingChance;

    public LOTRLeavesBlock(MaterialColor materialColor) {
        super(Block.Properties.func_200949_a((Material)Material.field_151584_j, (MaterialColor)materialColor).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_());
        ((FireBlock)Blocks.field_150480_ab).func_180686_a((Block)this, 30, 60);
        CompostingHelper.prepareCompostable((IItemProvider)this, 0.3f);
    }

    public LOTRLeavesBlock() {
        this(Material.field_151584_j.func_151565_r());
    }

    public LOTRLeavesBlock setFallingParticle(Supplier<? extends IParticleData> particle, int chance) {
        this.fallingParticle = particle;
        this.fallingChance = chance;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (this.fallingParticle != null && rand.nextInt(this.fallingChance) == 0) {
            IParticleData particle = this.fallingParticle.get();
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (double)pos.func_177956_o() - 0.05;
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double xSpeed = MathHelper.func_151240_a((Random)rand, (float)-0.1f, (float)0.1f);
            double ySpeed = MathHelper.func_151240_a((Random)rand, (float)-0.03f, (float)-0.01f);
            double zSpeed = MathHelper.func_151240_a((Random)rand, (float)-0.1f, (float)0.1f);
            world.func_195594_a(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

