/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import lotr.common.block.LOTRBlockStates;
import lotr.common.event.CompostingHelper;
import lotr.common.init.LOTRTags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class ReedsBlock
extends Block
implements IWaterLoggable,
IGrowable {
    public static final EnumProperty<Type> REEDS_TYPE = LOTRBlockStates.REEDS_TYPE;
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    private static final int MAX_AGE = 15;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final boolean canReedGrow;

    protected ReedsBlock(Block.Properties properties, boolean canGrow) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.ONE))).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.canReedGrow = canGrow;
        ((FireBlock)Blocks.field_150480_ab).func_180686_a((Block)this, 60, 100);
        CompostingHelper.prepareCompostable((IItemProvider)this, 0.5f);
    }

    protected ReedsBlock(boolean canGrow) {
        this(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c), canGrow);
    }

    public ReedsBlock() {
        this(true);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{REEDS_TYPE, AGE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluid;
        BlockPos pos;
        BlockState placeState = this.func_176223_P();
        World world = context.func_195991_k();
        BlockState belowState = world.func_180495_p((pos = context.func_195995_a()).func_177977_b());
        if (belowState.func_177230_c() == this) {
            Type reedType = (Type)((Object)belowState.func_177229_b(REEDS_TYPE));
            if (reedType == Type.ONE) {
                placeState = (BlockState)placeState.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.TWO_TOP));
            } else if (reedType == Type.TWO_TOP) {
                placeState = (BlockState)placeState.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.THREE_TOP));
            }
        }
        return (BlockState)placeState.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf((fluid = context.func_195991_k().func_204610_c(context.func_195995_a())).func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        } else if (facing == Direction.UP) {
            Type thisReedType = (Type)((Object)state.func_177229_b(REEDS_TYPE));
            if (facingState.func_177230_c() == this) {
                Type aboveReedType = (Type)((Object)facingState.func_177229_b(REEDS_TYPE));
                if (thisReedType == Type.ONE && aboveReedType == Type.TWO_TOP) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.TWO_BOTTOM));
                }
                if (thisReedType == Type.TWO_TOP && aboveReedType == Type.THREE_TOP) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.THREE_MIDDLE));
                }
                if (thisReedType == Type.TWO_BOTTOM && aboveReedType == Type.THREE_MIDDLE) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.THREE_BOTTOM));
                }
                if (thisReedType == Type.THREE_BOTTOM && aboveReedType == Type.TWO_TOP) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.TWO_BOTTOM));
                }
            } else {
                if (thisReedType == Type.TWO_BOTTOM || thisReedType == Type.THREE_BOTTOM) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.ONE));
                }
                if (thisReedType == Type.THREE_MIDDLE) {
                    return (BlockState)state.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.TWO_TOP));
                }
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Type reedType = (Type)((Object)state.func_177229_b(REEDS_TYPE));
        BlockPos belowPos = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(belowPos);
        if (reedType == Type.ONE || reedType == Type.TWO_BOTTOM || reedType == Type.THREE_BOTTOM) {
            if (belowState.func_203425_a(LOTRTags.Blocks.REEDS_PLACEABLE_ON)) {
                if (world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a) {
                    boolean canPotentiallyReachAir = false;
                    if (this.isAirOrReedsInAir(world, pos.func_177984_a())) {
                        canPotentiallyReachAir = true;
                    } else if (this.isWaterOrReedsInWater(world, pos.func_177984_a()) && this.isAirOrReedsInAir(world, pos.func_177981_b(2))) {
                        canPotentiallyReachAir = true;
                    }
                    return canPotentiallyReachAir;
                }
                for (Direction horizontalDir : Direction.Plane.HORIZONTAL) {
                    BlockState adjacentBelowState = world.func_180495_p(belowPos.func_177972_a(horizontalDir));
                    IFluidState fluid = adjacentBelowState.func_204520_s();
                    if (!fluid.func_206884_a(FluidTags.field_206959_a) && adjacentBelowState.func_177230_c() != Blocks.field_185778_de) continue;
                    return true;
                }
            }
            return false;
        }
        if (reedType == Type.THREE_TOP && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            return false;
        }
        return belowState.func_177230_c() == this;
    }

    private boolean isAirOrReedsInAir(IWorldReader world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    private boolean isWaterOrReedsInWater(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_204520_s().func_206886_c() == Fluids.field_204546_a) {
            return true;
        }
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else if (this.canReedGrow && this.canReedGrowUpwards((IBlockReader)world, pos, state)) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                if (age == 15) {
                    this.growReedAbove((World)world, pos, state);
                } else {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                }
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private boolean canReedGrowUpwards(IBlockReader world, BlockPos pos, BlockState state) {
        Type reedType = (Type)((Object)state.func_177229_b(REEDS_TYPE));
        if (reedType == Type.ONE || reedType == Type.TWO_TOP) {
            BlockPos abovePos = pos.func_177984_a();
            if (world.func_180495_p(abovePos).isAir(world, abovePos)) {
                return true;
            }
            BlockPos twoAbovePos = abovePos.func_177984_a();
            if (world.func_204610_c(abovePos).func_206886_c() == Fluids.field_204546_a && world.func_180495_p(twoAbovePos).isAir(world, twoAbovePos)) {
                return true;
            }
        }
        return false;
    }

    private void growReedAbove(World world, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.func_177984_a();
        BlockState growAboveState = (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(abovePos).func_206886_c() == Fluids.field_204546_a));
        Type reedType = (Type)((Object)state.func_177229_b(REEDS_TYPE));
        if (reedType == Type.ONE) {
            world.func_175656_a(pos.func_177984_a(), (BlockState)growAboveState.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.TWO_TOP)));
        } else if (reedType == Type.TWO_TOP) {
            world.func_175656_a(pos.func_177984_a(), (BlockState)growAboveState.func_206870_a(REEDS_TYPE, (Comparable)((Object)Type.THREE_TOP)));
        }
        BlockState updatedStateHere = world.func_180495_p(pos);
        world.func_180501_a(pos, (BlockState)updatedStateHere.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.canReedGrow && this.canReedGrowUpwards(world, pos, state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if ((age += MathHelper.func_76136_a((Random)rand, (int)7, (int)15)) >= 15) {
            BlockState aboveState;
            BlockPos abovePos;
            this.growReedAbove((World)world, pos, state);
            int ageRemaining = age - 15;
            if (ageRemaining > 0 && this.canReedGrowUpwards((IBlockReader)world, abovePos = pos.func_177984_a(), aboveState = world.func_180495_p(abovePos))) {
                int aboveAge = (Integer)aboveState.func_177229_b((IProperty)AGE);
                world.func_180501_a(abovePos, (BlockState)aboveState.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(aboveAge += ageRemaining)), 4);
            }
        } else {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 4);
        }
    }

    public static enum Type implements IStringSerializable
    {
        ONE("1"),
        TWO_BOTTOM("2_bottom"),
        TWO_TOP("2_top"),
        THREE_BOTTOM("3_bottom"),
        THREE_MIDDLE("3_middle"),
        THREE_TOP("3_top");

        private final String typeName;

        private Type(String s) {
            this.typeName = s;
        }

        public String func_176610_l() {
            return this.typeName;
        }
    }
}

