/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block.trees;

import java.util.Random;
import lotr.common.world.biome.LOTRBiomeFeatures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.trees.Tree;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class MallornTree
extends Tree {
    public boolean func_225545_a_(IWorld world, ChunkGenerator<?> chunkGen, BlockPos pos, BlockState sapling, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x != 0 && z != 0 || !MallornTree.canCrossTreeSpawnAt(sapling, (IBlockReader)world, pos.func_177982_a(x, 0, z))) continue;
                return this.growCrossTree(world, chunkGen, pos, sapling, rand, x, z);
            }
        }
        return super.func_225545_a_(world, chunkGen, pos, sapling, rand);
    }

    public boolean growCrossTree(IWorld world, ChunkGenerator<?> chunkGen, BlockPos pos, BlockState sapling, Random rand, int xOffset, int zoffset) {
        ConfiguredFeature<BaseTreeFeatureConfig, ?> crossTree = this.getCrossTreeFeature(rand);
        if (crossTree == null) {
            return false;
        }
        BlockState air = Blocks.field_150350_a.func_176223_P();
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset), air, 4);
        world.func_180501_a(pos.func_177982_a(xOffset - 1, 0, zoffset), air, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zoffset), air, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset - 1), air, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset + 1), air, 4);
        if (crossTree.func_222734_a(world, chunkGen, rand, pos.func_177982_a(xOffset, 0, zoffset))) {
            return true;
        }
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset), sapling, 4);
        world.func_180501_a(pos.func_177982_a(xOffset - 1, 0, zoffset), sapling, 4);
        world.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zoffset), sapling, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset - 1), sapling, 4);
        world.func_180501_a(pos.func_177982_a(xOffset, 0, zoffset + 1), sapling, 4);
        return false;
    }

    public static boolean canCrossTreeSpawnAt(BlockState sapling, IBlockReader world, BlockPos pos) {
        Block block = sapling.func_177230_c();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x != 0 && z != 0 || block == world.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c()) continue;
                return false;
            }
        }
        return true;
    }

    protected ConfiguredFeature<TreeFeatureConfig, ?> func_225546_b_(Random rand, boolean bees) {
        return bees ? LOTRBiomeFeatures.mallornBees() : LOTRBiomeFeatures.mallorn();
    }

    protected ConfiguredFeature<BaseTreeFeatureConfig, ?> getCrossTreeFeature(Random rand) {
        return LOTRBiomeFeatures.mallornBoughs();
    }
}

