/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.time.LOTRDate;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DateCommand
extends LOTRBaseCommand {
    public static final int MAX_DATE = 1000000;
    public static final int MIN_DATE = -1000000;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lotr_date").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"get").executes(context -> DateCommand.queryCurrentDate((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"date", (ArgumentType)IntegerArgumentType.integer((int)-1000000, (int)1000000)).executes(context -> DateCommand.setCurrentDate((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"date")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"date", (ArgumentType)IntegerArgumentType.integer()).executes(context -> DateCommand.addToCurrentDate((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"date")))))).then(Commands.func_197057_a((String)"display").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> DateCommand.displayCurrentDate((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))));
    }

    private static int queryCurrentDate(CommandSource source) {
        int date = LOTRDate.ShireReckoning.currentDay;
        ITextComponent dateName = LOTRDate.ShireReckoning.getShireDate().getDisplayName(false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.get", new Object[]{date, dateName}), false);
        return date;
    }

    private static int setCurrentDate(CommandSource source, int date) {
        LOTRDate.setDate(source.func_197023_e(), date);
        ITextComponent dateName = LOTRDate.ShireReckoning.getShireDate().getDisplayName(false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.set", new Object[]{date, dateName}), true);
        return date;
    }

    private static int addToCurrentDate(CommandSource source, int addDate) {
        int currentDate = LOTRDate.ShireReckoning.currentDay;
        int newDate = currentDate + addDate;
        if (newDate < -1000000 || newDate > 1000000) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.add.failure.outOfBounds", new Object[]{newDate}));
        }
        LOTRDate.setDate(source.func_197023_e(), newDate);
        ITextComponent dateName = LOTRDate.ShireReckoning.getShireDate().getDisplayName(false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.add", new Object[]{addDate, newDate, dateName}), true);
        return newDate;
    }

    private static int displayCurrentDate(CommandSource source, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            LOTRDate.sendUpdatePacket(player, true);
        }
        int numPlayers = players.size();
        if (numPlayers == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.display.single", new Object[]{players.iterator().next().func_145748_c_()}), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.lotr_date.display.multiple", new Object[]{numPlayers}), true);
        return numPlayers;
    }
}

