/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.command.arguments.WaypointRegionArgument;
import lotr.common.data.FastTravelDataModule;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointRegionsCommand
extends LOTRBaseCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"wpregion").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"unlock").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"region", (ArgumentType)WaypointRegionArgument.waypointRegion()).executes(context -> WaypointRegionsCommand.unlockRegion((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), WaypointRegionArgument.getRegion(context, "region"))))).then(Commands.func_197057_a((String)"all").executes(context -> WaypointRegionsCommand.unlockAllRegions((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))))).then(Commands.func_197057_a((String)"lock").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"region", (ArgumentType)WaypointRegionArgument.waypointRegion()).executes(context -> WaypointRegionsCommand.lockRegion((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), WaypointRegionArgument.getRegion(context, "region"))))).then(Commands.func_197057_a((String)"all").executes(context -> WaypointRegionsCommand.lockAllRegions((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets")))))));
    }

    private static int unlockRegion(CommandSource source, Collection<ServerPlayerEntity> players, WaypointRegion region) throws CommandSyntaxException {
        int unlocked = 0;
        for (ServerPlayerEntity player : players) {
            FastTravelDataModule ftData = WaypointRegionsCommand.getLevelData().getData((PlayerEntity)player).getFastTravelData();
            if (ftData.isWaypointRegionUnlocked(region)) continue;
            ftData.unlockWaypointRegion(region);
            ++unlocked;
        }
        if (unlocked == 0) {
            if (players.size() == 1) {
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.failure.single", new Object[]{players.iterator().next().func_145748_c_(), region.namespacedID}));
            }
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.failure.multiple", new Object[]{players.size(), region.namespacedID}));
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.success.single", new Object[]{players.iterator().next().func_145748_c_(), region.namespacedID}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.success.multiple", new Object[]{players.size(), region.namespacedID}), true);
        }
        return unlocked;
    }

    private static int lockRegion(CommandSource source, Collection<ServerPlayerEntity> players, WaypointRegion region) throws CommandSyntaxException {
        int locked = 0;
        for (ServerPlayerEntity player : players) {
            FastTravelDataModule ftData = WaypointRegionsCommand.getLevelData().getData((PlayerEntity)player).getFastTravelData();
            if (!ftData.isWaypointRegionUnlocked(region)) continue;
            ftData.lockWaypointRegion(region);
            ++locked;
        }
        if (locked == 0) {
            if (players.size() == 1) {
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.failure.single", new Object[]{players.iterator().next().func_145748_c_(), region.namespacedID}));
            }
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.failure.multiple", new Object[]{players.size(), region.namespacedID}));
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.success.single", new Object[]{players.iterator().next().func_145748_c_(), region.namespacedID}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.success.multiple", new Object[]{players.size(), region.namespacedID}), true);
        }
        return locked;
    }

    private static int unlockAllRegions(CommandSource source, Collection<ServerPlayerEntity> players) throws CommandSyntaxException {
        int unlocked = 0;
        for (ServerPlayerEntity player : players) {
            FastTravelDataModule ftData = WaypointRegionsCommand.getLevelData().getData((PlayerEntity)player).getFastTravelData();
            boolean unlockedAny = false;
            for (WaypointRegion region : WaypointRegion.values()) {
                if (ftData.isWaypointRegionUnlocked(region)) continue;
                ftData.unlockWaypointRegion(region);
                unlockedAny = true;
            }
            if (!unlockedAny) continue;
            ++unlocked;
        }
        if (unlocked == 0) {
            if (players.size() == 1) {
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.all.failure.single", new Object[]{players.iterator().next().func_145748_c_()}));
            }
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.all.failure.multiple", new Object[]{players.size()}));
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.all.success.single", new Object[]{players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.unlock.all.success.multiple", new Object[]{players.size()}), true);
        }
        return unlocked;
    }

    private static int lockAllRegions(CommandSource source, Collection<ServerPlayerEntity> players) throws CommandSyntaxException {
        int locked = 0;
        for (ServerPlayerEntity player : players) {
            FastTravelDataModule ftData = WaypointRegionsCommand.getLevelData().getData((PlayerEntity)player).getFastTravelData();
            boolean lockedAny = false;
            for (WaypointRegion region : WaypointRegion.values()) {
                if (!ftData.isWaypointRegionUnlocked(region)) continue;
                ftData.lockWaypointRegion(region);
                lockedAny = true;
            }
            if (!lockedAny) continue;
            ++locked;
        }
        if (locked == 0) {
            if (players.size() == 1) {
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.all.failure.single", new Object[]{players.iterator().next().func_145748_c_()}));
            }
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.all.failure.multiple", new Object[]{players.size()}));
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.all.success.single", new Object[]{players.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpregion.lock.all.success.multiple", new Object[]{players.size()}), true);
        }
        return locked;
    }
}

