/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lotr.common.LOTRMod;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import lotr.common.world.fac.FactionSettingsManager;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;

public class FactionArgument
implements ArgumentType<Faction> {
    private static final Collection<String> EXAMPLES = Arrays.asList("lotr:rohan", "lotr:isengard");
    public static final DynamicCommandExceptionType FACTION_BAD_ID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("argument.lotr.faction.id.invalid", new Object[]{arg}));

    public static FactionArgument faction() {
        return new FactionArgument();
    }

    private FactionSettings getCurrentFactionSettings() {
        LogicalSide safeSideToUse = LOTRMod.proxy.isClient() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        return FactionSettingsManager.sidedInstance(safeSideToUse).getCurrentLoadedFactions();
    }

    public Faction parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        Faction faction = this.getCurrentFactionSettings().getFactionByName(name);
        if (faction != null) {
            return faction;
        }
        reader.setCursor(cursor);
        throw FACTION_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)name.toString());
    }

    public static <S> Faction getFaction(CommandContext<S> context, String name) {
        return (Faction)context.getArgument(name, Faction.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(this.getCurrentFactionSettings().getFactionNames(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

