/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lotr.common.data.PlayerMessageType;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.TranslationTextComponent;

public class PlayerMessageTypeArgument
implements ArgumentType<PlayerMessageType> {
    private static final Collection<String> EXAMPLES = Arrays.asList(PlayerMessageType.ALIGN_DRAIN.getSaveName(), PlayerMessageType.FRIENDLY_FIRE.getSaveName());
    public static final DynamicCommandExceptionType MESSAGE_BAD_ID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("argument.lotr.playerMessage.id.invalid", new Object[]{arg}));

    public static PlayerMessageTypeArgument messageType() {
        return new PlayerMessageTypeArgument();
    }

    public PlayerMessageType parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String name = reader.readUnquotedString();
        PlayerMessageType message = PlayerMessageType.forSaveName(name);
        if (message != null && message != PlayerMessageType.CUSTOM) {
            return message;
        }
        reader.setCursor(cursor);
        throw MESSAGE_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)name.toString());
    }

    public static <S> PlayerMessageType getMessageType(CommandContext<S> context, String name) {
        return (PlayerMessageType)((Object)context.getArgument(name, PlayerMessageType.class));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(PlayerMessageType.getAllPresetNamesForCommand(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

