/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointRegionArgument
implements ArgumentType<WaypointRegion> {
    private static final Collection<String> EXAMPLES = Arrays.asList("lotr:shire", "lotr:gondor");
    public static final DynamicCommandExceptionType REGION_BAD_ID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("argument.lotr.waypointRegion.id.invalid", new Object[]{arg}));

    public static WaypointRegionArgument waypointRegion() {
        return new WaypointRegionArgument();
    }

    public WaypointRegion parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        WaypointRegion region = WaypointRegion.forName(name);
        if (region != null) {
            return region;
        }
        reader.setCursor(cursor);
        throw REGION_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)name.toString());
    }

    public static <S> WaypointRegion getRegion(CommandContext<S> context, String name) {
        return (WaypointRegion)((Object)context.getArgument(name, WaypointRegion.class));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(WaypointRegion.getAllNames(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

