/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRConfig {
    public static final ClientConfig CLIENT;
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static void register(IEventBus fmlBus) {
        fmlBus.register(LOTRConfig.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
    }

    @SubscribeEvent
    public static void onModConfig(ModConfig.ModConfigEvent event) {
        ForgeConfigSpec spec = event.getConfig().getSpec();
        if (spec == CLIENT_SPEC) {
            CLIENT.bakeFields();
        } else if (spec == COMMON_SPEC) {
            COMMON.bakeFields();
        } else if (spec == SERVER_SPEC) {
            SERVER.bakeFields();
        }
    }

    private static final IntHolder makeInt(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, int def, String comment) {
        return LOTRConfig.makeIntBounded(collection, builder, key, def, Integer.MIN_VALUE, Integer.MAX_VALUE, comment);
    }

    private static final IntHolder makeIntBounded(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, int def, int min, int max, String comment) {
        return LOTRConfig.makeInt(collection, builder, key, def, min, max, false, comment);
    }

    private static final IntHolder makeIntBoundedRestart(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, int def, int min, int max, String comment) {
        return LOTRConfig.makeInt(collection, builder, key, def, min, max, true, comment);
    }

    private static final IntHolder makeInt(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, int def, int min, int max, boolean worldRestart, String comment) {
        builder.comment(comment).translation(String.format("config.%s.%s", "lotr", key));
        if (worldRestart) {
            builder.worldRestart();
        }
        ForgeConfigSpec.IntValue intVal = builder.defineInRange(key, def, min, max);
        IntHolder holder = new IntHolder((ForgeConfigSpec.ConfigValue<Integer>)intVal);
        collection.add(holder);
        return holder;
    }

    private static final BoolHolder makeBool(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, boolean def, String comment) {
        return LOTRConfig.makeBool(collection, builder, key, def, false, comment);
    }

    private static final BoolHolder makeBoolRestart(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, boolean def, String comment) {
        return LOTRConfig.makeBool(collection, builder, key, def, true, comment);
    }

    private static final BoolHolder makeBool(List<ConfigValueHolder<?>> collection, ForgeConfigSpec.Builder builder, String key, boolean def, boolean worldRestart, String comment) {
        builder.comment(comment).translation(String.format("config.%s.%s", "lotr", key));
        if (worldRestart) {
            builder.worldRestart();
        }
        ForgeConfigSpec.BooleanValue boolVal = builder.define(key, def);
        BoolHolder holder = new BoolHolder((ForgeConfigSpec.ConfigValue<Boolean>)boolVal);
        collection.add(holder);
        return holder;
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        Pair commonPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        Pair serverPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CLIENT = (ClientConfig)clientPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)serverPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
    }

    public static class BoolHolder
    extends ConfigValueHolder<Boolean> {
        public BoolHolder(ForgeConfigSpec.ConfigValue<Boolean> cfgVal) {
            super(cfgVal);
        }

        public void toggleAndSave() {
            this.setAndSave((Boolean)this.get() == false);
        }
    }

    public static class IntHolder
    extends ConfigValueHolder<Integer> {
        public IntHolder(ForgeConfigSpec.ConfigValue<Integer> cfgVal) {
            super(cfgVal);
        }
    }

    public static abstract class ConfigValueHolder<T> {
        public final ForgeConfigSpec.ConfigValue<T> configValue;
        private T value;

        public ConfigValueHolder(ForgeConfigSpec.ConfigValue<T> cfgVal) {
            this.configValue = cfgVal;
        }

        public void bake() {
            this.value = this.configValue.get();
        }

        public T get() {
            return this.value;
        }

        public void setAndSave(T newValue) {
            this.value = newValue;
            this.configValue.set(this.value);
            this.configValue.save();
        }
    }

    public static class ServerConfig {
        private final List<ConfigValueHolder<?>> serverFields = new ArrayList();

        public ServerConfig(ForgeConfigSpec.Builder builder) {
        }

        public void bakeFields() {
            this.serverFields.forEach(holder -> holder.bake());
        }
    }

    public static class CommonConfig {
        private final List<ConfigValueHolder<?>> commonFields = new ArrayList();
        public final BoolHolder drunkSpeech;
        public final BoolHolder areasOfInfluence;
        public final BoolHolder alignmentDraining;
        public final IntHolder forceMapLocations;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("gameplay");
            this.drunkSpeech = LOTRConfig.makeBool(this.commonFields, builder, "drunkSpeech", true, "");
            this.areasOfInfluence = LOTRConfig.makeBool(this.commonFields, builder, "areasOfInfluence", true, "Alignment gains depend on factions' areas of influence");
            this.alignmentDraining = LOTRConfig.makeBool(this.commonFields, builder, "alignmentDraining", true, "Factions dislike if a player has + alignment with enemy factions");
            builder.pop();
            builder.push("admin");
            this.forceMapLocations = LOTRConfig.makeIntBounded(this.commonFields, builder, "forceMapLocations", 0, 0, 2, "Force hide or show players' map locations. 0 = per-player (default), 1 = force hide, 2 = force show");
            builder.pop();
        }

        public void bakeFields() {
            this.commonFields.forEach(holder -> holder.bake());
        }
    }

    public static class ClientConfig {
        private final List<ConfigValueHolder<?>> clientFields = new ArrayList();
        public final BoolHolder modSky;
        public final BoolHolder modClouds;
        public final IntHolder cloudRange;
        public final BoolHolder northernLights;
        public final BoolHolder sunGlare;
        public final BoolHolder rainMist;
        public final BoolHolder mistyMountainsMist;
        public final BoolHolder newWeatherRendering;
        public final BoolHolder newRainGroundParticles;
        public final BoolHolder sepiaMap;
        public final BoolHolder mapLabels;
        public final BoolHolder showWorldTypeHelp;
        public final BoolHolder compass;
        public final BoolHolder compassInfo;
        public final BoolHolder showAlignmentEverywhere;
        public final IntHolder alignmentXOffset;
        public final IntHolder alignmentYOffset;
        public final IntHolder dolAmrothChestplateWings;
        public final BoolHolder windAmbience;
        public final BoolHolder newRainSounds;
        public final BoolHolder newThunderSounds;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("environment");
            this.modSky = LOTRConfig.makeBoolRestart(this.clientFields, builder, "modSky", true, "Toggle the Middle-earth sky renderer");
            this.modClouds = LOTRConfig.makeBoolRestart(this.clientFields, builder, "modClouds", true, "Toggle the Middle-earth cloud renderer");
            this.cloudRange = LOTRConfig.makeIntBounded(this.clientFields, builder, "cloudRange", 1024, 0, Integer.MAX_VALUE, "");
            this.northernLights = LOTRConfig.makeBool(this.clientFields, builder, "northernLights", true, "The Aurora, or Northern Lights! May be a slightly performance-intensive feature for some users");
            this.sunGlare = LOTRConfig.makeBool(this.clientFields, builder, "sunGlare", true, "");
            this.rainMist = LOTRConfig.makeBool(this.clientFields, builder, "rainMist", true, "");
            this.mistyMountainsMist = LOTRConfig.makeBool(this.clientFields, builder, "mistyMountainsMist", true, "");
            this.newWeatherRendering = LOTRConfig.makeBoolRestart(this.clientFields, builder, "newWeatherRendering", true, "New rain and snow textures (in Middle-earth), ash, and sandstorms");
            this.newRainGroundParticles = LOTRConfig.makeBoolRestart(this.clientFields, builder, "newRainGroundParticles", true, "Replace rain ground particles in Middle-earth, to match the new rain textures");
            builder.pop();
            builder.push("gui");
            this.sepiaMap = LOTRConfig.makeBool(this.clientFields, builder, "sepiaMap", false, "");
            this.mapLabels = LOTRConfig.makeBool(this.clientFields, builder, "mapLabels", true, "");
            this.showWorldTypeHelp = LOTRConfig.makeBool(this.clientFields, builder, "showWorldTypeHelp", true, "Will be automatically set to false after the world type help display has been shown once");
            builder.pop();
            builder.push("hud");
            this.compass = LOTRConfig.makeBool(this.clientFields, builder, "compass", true, "Middle-earth on-screen compass");
            this.compassInfo = LOTRConfig.makeBool(this.clientFields, builder, "compassInfo", true, "On-screen compass: coordinates and biome name");
            this.showAlignmentEverywhere = LOTRConfig.makeBool(this.clientFields, builder, "showAlignmentEverywhere", false, "Display the alignment meter even in non-mod dimensions");
            this.alignmentXOffset = LOTRConfig.makeInt(this.clientFields, builder, "alignmentXOffset", 0, "Configure the x-position of the alignment meter on-screen. Negative values move it left, positive values right");
            this.alignmentYOffset = LOTRConfig.makeInt(this.clientFields, builder, "alignmentYOffset", 0, "Configure the y-position of the alignment meter on-screen. Negative values move it up, positive values down");
            builder.pop();
            builder.push("model");
            this.dolAmrothChestplateWings = LOTRConfig.makeIntBounded(this.clientFields, builder, "dolAmrothChestplateWings", 12, 0, 24, "The number of wings on the swan knights' chestplates");
            builder.pop();
            builder.push("sound");
            this.windAmbience = LOTRConfig.makeBool(this.clientFields, builder, "windAmbience", true, "");
            this.newRainSounds = LOTRConfig.makeBool(this.clientFields, builder, "newRainSounds", true, "");
            this.newThunderSounds = LOTRConfig.makeBool(this.clientFields, builder, "newThunderSounds", true, "");
            builder.pop();
        }

        public void bakeFields() {
            this.clientFields.forEach(holder -> holder.bake());
        }

        public void toggleSepia() {
            this.sepiaMap.toggleAndSave();
        }

        public void toggleMapLabels() {
            this.mapLabels.toggleAndSave();
        }
    }
}

