/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lotr.common.util.TriConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class DataUtil {
    public static <T> ListNBT saveCollectionAsCompoundListNBT(Collection<T> collection, BiConsumer<CompoundNBT, T> elementToNbt) {
        ListNBT tagList = new ListNBT();
        for (T t : collection) {
            CompoundNBT nbt = new CompoundNBT();
            elementToNbt.accept(nbt, (CompoundNBT)t);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public static <T, N extends INBT> ListNBT saveCollectionAsPrimitiveListNBT(Collection<T> collection, Function<T, N> elementToNbt) {
        ListNBT tagList = new ListNBT();
        for (T t : collection) {
            tagList.add(elementToNbt.apply(t));
        }
        return tagList;
    }

    public static <T> void loadCollectionFromCompoundListNBT(Collection<T> collection, ListNBT tagList, Function<CompoundNBT, T> nbtToElement) {
        collection.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            T element = nbtToElement.apply(nbt);
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <T, P> void loadCollectionFromPrimitiveListNBT(Collection<T> collection, ListNBT tagList, BiFunction<ListNBT, Integer, P> listNbtToPrimitive, Function<P, T> primitiveToElement) {
        collection.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            P value = listNbtToPrimitive.apply(tagList, i);
            T element = primitiveToElement.apply(value);
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <K, V> ListNBT saveMapAsListNBT(Map<K, V> map, TriConsumer<CompoundNBT, K, V> entryToNbt) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<K, V> e : map.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            CompoundNBT nbt = new CompoundNBT();
            entryToNbt.accept(nbt, key, value);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public static <K, V> void loadMapFromListNBT(Map<K, V> map, ListNBT tagList, Function<CompoundNBT, Pair<K, V>> nbtToEntry) {
        map.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            Pair<K, V> entry = nbtToEntry.apply(nbt);
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <T> void writeCollectionToBuffer(PacketBuffer buf, Collection<T> collection, Consumer<T> elementToBuffer) {
        buf.func_150787_b(collection.size());
        collection.forEach(elementToBuffer);
    }

    public static <T> void readCollectionFromBuffer(PacketBuffer buf, Collection<T> collection, Supplier<T> bufferToElement) {
        collection.clear();
        int collectionSize = buf.func_150792_a();
        for (int i = 0; i < collectionSize; ++i) {
            T element = bufferToElement.get();
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <K, V> void writeMapToBuffer(PacketBuffer buf, Map<K, V> map, BiConsumer<K, V> entryToBuffer) {
        buf.func_150787_b(map.size());
        map.forEach(entryToBuffer);
    }

    public static <K, V> void readMapFromBuffer(PacketBuffer buf, Map<K, V> map, Supplier<Pair<K, V>> bufferToEntry) {
        map.clear();
        int mapSize = buf.func_150792_a();
        for (int i = 0; i < mapSize; ++i) {
            Pair<K, V> entry = bufferToEntry.get();
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }
}

