/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;

public abstract class InstancedJsonReloadListener
extends JsonReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected static final String JSON_EXTENSION = ".json";
    private final String rootFolder;
    protected final String settingsNameForLogging;
    protected final LogicalSide side;

    public InstancedJsonReloadListener(String folder, String name, LogicalSide side) {
        super(GSON, folder);
        this.rootFolder = folder;
        this.settingsNameForLogging = name;
        this.side = side;
    }

    public LogicalSide getSide() {
        return this.side;
    }

    public final void registerToServer(MinecraftServer server) {
        server.func_195570_aG().func_219534_a((IFutureReloadListener)this);
    }

    protected JsonObject loadDataJsonIfExists(Map<ResourceLocation, JsonObject> jsons, ResourceLocation targetPath) {
        Optional<Map.Entry> optEntry = jsons.entrySet().stream().filter(entry -> {
            ResourceLocation shortenedPath = (ResourceLocation)entry.getKey();
            return this.getPreparedPath(shortenedPath).equals((Object)targetPath);
        }).findFirst();
        if (optEntry.isPresent()) {
            return (JsonObject)optEntry.get().getValue();
        }
        LOTRLog.error("%s datapack load missing %s", this.settingsNameForLogging, targetPath);
        return null;
    }

    protected Map<ResourceLocation, JsonObject> filterDataJsonsBySubFolder(Map<ResourceLocation, JsonObject> jsons, String folder) {
        return jsons.entrySet().stream().filter(e -> {
            ResourceLocation res = (ResourceLocation)e.getKey();
            return res.func_110623_a().startsWith(folder);
        }).collect(InstancedJsonReloadListener.toMapCollector());
    }

    protected Map<ResourceLocation, JsonObject> filterDataJsonsByRootFolderOnly(Map<ResourceLocation, JsonObject> jsons) {
        return jsons.entrySet().stream().filter(e -> {
            ResourceLocation res = (ResourceLocation)e.getKey();
            return !res.func_110623_a().contains("/");
        }).collect(InstancedJsonReloadListener.toMapCollector());
    }

    protected static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMapCollector() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected JsonObject loadDefaultJson(ResourceLocation res) {
        JsonObject jsonObj;
        InputStream is = InstancedJsonReloadListener.getDefaultDatapackResourceStream(res);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        JsonObject jsonObject = jsonObj = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            LOTRLog.warn("Exception closing reader for %s json resource: %s", this.settingsNameForLogging, res);
            e.printStackTrace();
        }
        return jsonObject;
        catch (Exception e) {
            JsonObject jsonObject2;
            try {
                LOTRLog.warn("Failed to parse %s json resource: %s", this.settingsNameForLogging, res);
                e.printStackTrace();
                jsonObject2 = null;
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e2) {
                    LOTRLog.warn("Exception closing reader for %s json resource: %s", this.settingsNameForLogging, res);
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e3) {
                LOTRLog.warn("Exception closing reader for %s json resource: %s", this.settingsNameForLogging, res);
                e3.printStackTrace();
            }
            return jsonObject2;
        }
    }

    protected Map<ResourceLocation, JsonObject> loadDefaultJsonsInSubFolder(String subfolder, int maxDepth) {
        String fullFolder = String.format("%s/%s", this.rootFolder, subfolder);
        Collection<ResourceLocation> resources = InstancedJsonReloadListener.getDefaultDatapackResourcesInFolder(fullFolder, maxDepth, s -> s.endsWith(JSON_EXTENSION));
        return resources.stream().collect(Collectors.toMap(res -> {
            String resPath = res.func_110623_a();
            return new ResourceLocation(res.func_110624_b(), resPath.substring((this.rootFolder + "/").length(), resPath.indexOf(JSON_EXTENSION)));
        }, this::loadDefaultJson));
    }

    private static InputStream getDefaultDatapackResourceStream(ResourceLocation res) {
        return LOTRMod.getModResourceStream(ResourcePackType.SERVER_DATA, res);
    }

    private static Collection<ResourceLocation> getDefaultDatapackResourcesInFolder(String path, int maxDepth, Predicate<String> filter) {
        String namespace = "lotr";
        ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)namespace).get();
        return lotrAsPack.func_225637_a_(ResourcePackType.SERVER_DATA, namespace, path, maxDepth, filter);
    }
}

