/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.datafix;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LOTRItemRemappings {
    private static final Map<ResourceLocation, Block> BLOCK_REMAPS = new HashMap<ResourceLocation, Block>();
    private static final Map<ResourceLocation, Item> ITEM_REMAPS = new HashMap<ResourceLocation, Item>();
    private static final Map<ResourceLocation, Biome> BIOME_REMAPS = new HashMap<ResourceLocation, Biome>();
    private static final Map<ResourceLocation, SoundEvent> SOUND_REMAPS = new HashMap<ResourceLocation, SoundEvent>();
    private static boolean init = false;

    private static void init() {
        init = true;
        LOTRItemRemappings.addBlockRemap("shire_pine_log", LOTRBlocks.PINE_LOG, LOTRItems.PINE_LOG);
        LOTRItemRemappings.addBlockRemap("shire_pine_wood", LOTRBlocks.PINE_WOOD, LOTRItems.PINE_WOOD);
        LOTRItemRemappings.addBlockRemap("shire_pine_planks", LOTRBlocks.PINE_PLANKS, LOTRItems.PINE_PLANKS);
        LOTRItemRemappings.addBlockRemap("shire_pine_leaves", LOTRBlocks.PINE_LEAVES, LOTRItems.PINE_LEAVES);
        LOTRItemRemappings.addBlockRemap("shire_pine_sapling", LOTRBlocks.PINE_SAPLING, LOTRItems.PINE_SAPLING);
        LOTRItemRemappings.addBlockRemap("potted_shire_pine_sapling", LOTRBlocks.POTTED_PINE_SAPLING);
        LOTRItemRemappings.addBlockRemap("shire_pine_slab", LOTRBlocks.PINE_SLAB, LOTRItems.PINE_SLAB);
        LOTRItemRemappings.addBlockRemap("shire_pine_stairs", LOTRBlocks.PINE_STAIRS, LOTRItems.PINE_STAIRS);
        LOTRItemRemappings.addBlockRemap("shire_pine_fence", LOTRBlocks.PINE_FENCE, LOTRItems.PINE_FENCE);
        LOTRItemRemappings.addBlockRemap("shire_pine_fence_gate", LOTRBlocks.PINE_FENCE_GATE, LOTRItems.PINE_FENCE_GATE);
        LOTRItemRemappings.addBlockRemap("shire_pine_pressure_plate", LOTRBlocks.PINE_PRESSURE_PLATE, LOTRItems.PINE_PRESSURE_PLATE);
        LOTRItemRemappings.addBlockRemap("shire_pine_button", LOTRBlocks.PINE_BUTTON, LOTRItems.PINE_BUTTON);
        LOTRItemRemappings.addBlockRemap("stripped_shire_pine_log", LOTRBlocks.STRIPPED_PINE_LOG, LOTRItems.STRIPPED_PINE_LOG);
        LOTRItemRemappings.addBlockRemap("stripped_shire_pine_wood", LOTRBlocks.STRIPPED_PINE_WOOD, LOTRItems.STRIPPED_PINE_WOOD);
        LOTRItemRemappings.addBlockRemap("shire_pine_beam", LOTRBlocks.PINE_BEAM, LOTRItems.PINE_BEAM);
        LOTRItemRemappings.addBlockRemap("shire_pine_sign", LOTRBlocks.PINE_SIGN, LOTRItems.PINE_SIGN);
        LOTRItemRemappings.addBlockRemap("shire_pine_wall_sign", LOTRBlocks.PINE_WALL_SIGN);
        LOTRItemRemappings.addBlockRemap("durnaur_ore", LOTRBlocks.DURNOR_ORE, LOTRItems.DURNOR_ORE);
        LOTRItemRemappings.addBlockRemap("durnaur_block", LOTRBlocks.DURNOR_BLOCK, LOTRItems.DURNOR_BLOCK);
        LOTRItemRemappings.addBlockRemap("speleothem", LOTRBlocks.DRIPSTONE, LOTRItems.DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("mordor_speleothem", LOTRBlocks.MORDOR_DRIPSTONE, LOTRItems.MORDOR_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("obsidian_speleothem", LOTRBlocks.OBSIDIAN_DRIPSTONE, LOTRItems.OBSIDIAN_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("ice_speleothem", LOTRBlocks.ICE_DRIPSTONE, LOTRItems.ICE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("gondor_speleothem", LOTRBlocks.GONDOR_DRIPSTONE, LOTRItems.GONDOR_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("rohan_speleothem", LOTRBlocks.ROHAN_DRIPSTONE, LOTRItems.ROHAN_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("blue_speleothem", LOTRBlocks.BLUE_DRIPSTONE, LOTRItems.BLUE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("red_speleothem", LOTRBlocks.RED_DRIPSTONE, LOTRItems.RED_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("andesite_speleothem", LOTRBlocks.ANDESITE_DRIPSTONE, LOTRItems.ANDESITE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("diorite_speleothem", LOTRBlocks.DIORITE_DRIPSTONE, LOTRItems.DIORITE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("granite_speleothem", LOTRBlocks.GRANITE_DRIPSTONE, LOTRItems.GRANITE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("sandstone_speleothem", LOTRBlocks.SANDSTONE_DRIPSTONE, LOTRItems.SANDSTONE_DRIPSTONE);
        LOTRItemRemappings.addBlockRemap("red_sandstone_speleothem", LOTRBlocks.RED_SANDSTONE_DRIPSTONE, LOTRItems.RED_SANDSTONE_DRIPSTONE);
        LOTRItemRemappings.addItemRemap("durnaur", LOTRItems.DURNOR);
        LOTRItemRemappings.addBiomeRemap("gondor", LOTRBiomes.ANORIEN);
        LOTRItemRemappings.addSoundRemap("block.plate.break", () -> LOTRSoundEvents.CERAMIC_BREAK);
    }

    private static void addBlockRemap(String oldName, Supplier<? extends Block> newBlock) {
        BLOCK_REMAPS.put(new ResourceLocation("lotr", oldName), newBlock.get());
    }

    private static void addBlockRemap(String oldName, Supplier<? extends Block> newBlock, Supplier<? extends Item> newItem) {
        LOTRItemRemappings.addBlockRemap(oldName, newBlock);
        LOTRItemRemappings.addItemRemap(oldName, newItem);
    }

    private static void addItemRemap(String oldName, Supplier<? extends Item> newItem) {
        ITEM_REMAPS.put(new ResourceLocation("lotr", oldName), newItem.get());
    }

    private static void addBiomeRemap(String oldName, Supplier<? extends Biome> newBiome) {
        BIOME_REMAPS.put(new ResourceLocation("lotr", oldName), newBiome.get());
    }

    private static void addSoundRemap(String oldName, Supplier<? extends SoundEvent> newSound) {
        SOUND_REMAPS.put(new ResourceLocation("lotr", oldName), newSound.get());
    }

    public static void handle(RegistryEvent.MissingMappings event) {
        ImmutableList mappings = event.getAllMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            ResourceLocation itemName = mapping.key;
            if (!itemName.func_110624_b().equals("lotr")) continue;
            if (!init) {
                LOTRItemRemappings.init();
            }
            if (event.getRegistry().getRegistrySuperType() == Block.class) {
                if (!BLOCK_REMAPS.containsKey(itemName)) continue;
                Block block = BLOCK_REMAPS.get(itemName);
                mapping.remap((IForgeRegistryEntry)block);
                LOTRLog.info("Remapped old block id %s to new id %s", itemName, block.getRegistryName());
                continue;
            }
            if (event.getRegistry().getRegistrySuperType() == Item.class) {
                if (!ITEM_REMAPS.containsKey(itemName)) continue;
                Item item = ITEM_REMAPS.get(itemName);
                mapping.remap((IForgeRegistryEntry)item);
                LOTRLog.info("Remapped old item id %s to new id %s", itemName, item.getRegistryName());
                continue;
            }
            if (event.getRegistry().getRegistrySuperType() == Biome.class) {
                if (!BIOME_REMAPS.containsKey(itemName)) continue;
                Biome biome = BIOME_REMAPS.get(itemName);
                mapping.remap((IForgeRegistryEntry)biome);
                LOTRLog.info("Remapped old biome id %s to new id %s", itemName, biome.getRegistryName());
                continue;
            }
            if (event.getRegistry().getRegistrySuperType() != SoundEvent.class || !SOUND_REMAPS.containsKey(itemName)) continue;
            SoundEvent sound = SOUND_REMAPS.get(itemName);
            mapping.remap((IForgeRegistryEntry)sound);
            LOTRLog.info("Remapped old sound id %s to new id %s", itemName, sound.getRegistryName());
        }
    }

    public static ResourceLocation correctAlias(ForgeRegistry registry, ResourceLocation from, ResourceLocation to) {
        if (!init) {
            LOTRItemRemappings.init();
        }
        if (from.func_110624_b().equals("lotr") && from.equals((Object)to)) {
            ResourceLocation actualRemappedID = null;
            if (registry.getRegistrySuperType() == Block.class) {
                if (BLOCK_REMAPS.containsKey(from)) {
                    actualRemappedID = BLOCK_REMAPS.get(from).getRegistryName();
                }
            } else if (registry.getRegistrySuperType() == Item.class && ITEM_REMAPS.containsKey(from)) {
                actualRemappedID = ITEM_REMAPS.get(from).getRegistryName();
            }
            if (actualRemappedID == null) {
                LOTRLog.error("Couldn't fix broken old %s registry alias mapped to itself (%s) - couldn't find any actual new ID for the old alias", registry.getRegistryName(), from);
            } else {
                LOTRLog.info("Fixed a broken %s registry alias incorrectly mapped to itself (%s) - corrected to [%s -> %s]", registry.getRegistryName(), from, from, actualRemappedID);
                return actualRemappedID;
            }
        }
        return to;
    }
}

