/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.dim;

import com.google.common.math.IntMath;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.world.biome.LOTRBiomeBase;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;

public abstract class LOTRDimension
extends Dimension {
    private int skyR;
    private int skyG;
    private int skyB;
    private double cloudR;
    private double cloudG;
    private double cloudB;
    private double fogR;
    private double fogG;
    private double fogB;

    public LOTRDimension(World world, DimensionType dimType, float baseBrightness) {
        super(world, dimType, baseBrightness);
    }

    public long getWorldTime() {
        return LOTRTime.getWorldTime(this.field_76579_a);
    }

    public void setWorldTime(long time) {
    }

    public void resetRainAndThunder() {
        if (!this.field_76579_a.field_72995_K) {
            MinecraftServer server = ((ServerWorld)this.field_76579_a).func_73046_m();
            ServerWorld overworld = DimensionManager.getWorld((MinecraftServer)server, (DimensionType)DimensionType.field_223227_a_, (boolean)false, (boolean)true);
            overworld.func_201675_m().resetRainAndThunder();
        } else {
            super.resetRainAndThunder();
        }
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 48000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public int func_76559_b(long worldTime) {
        int day = LOTRDate.ShireReckoning.currentDay;
        return IntMath.mod((int)day, (int)field_111203_a.length);
    }

    public boolean isLunarEclipse(long worldTime) {
        int day = LOTRDate.ShireReckoning.currentDay;
        return this.func_76559_b(worldTime) == 0 && IntMath.mod((int)(day / field_111203_a.length), (int)4) == 3;
    }

    private int getBiomeBlendDistance() {
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings settings = mc.field_71474_y;
        int distance = 0;
        if (settings.field_74347_j) {
            distance = Math.min(settings.field_151451_c * 2, 36);
        }
        return distance;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBlendedBiomeSkyColor(BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        this.skyB = 0;
        this.skyG = 0;
        this.skyR = 0;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = this.field_76579_a.func_226691_t_(pos.func_177982_a(x, 0, z));
                int skyHere = biome.func_225529_c_();
                this.skyR += skyHere >> 16 & 0xFF;
                this.skyG += skyHere >> 8 & 0xFF;
                this.skyB += skyHere & 0xFF;
                ++count;
            }
        }
        this.skyR /= count;
        this.skyG /= count;
        this.skyB /= count;
        return this.skyR << 16 | this.skyG << 8 | this.skyB;
    }

    public Vec3d getBlendedCompleteSkyColor(BlockPos pos, float partialTicks) {
        int lightningFlash;
        float thunder;
        float celestialAngle = this.field_76579_a.func_72826_c(partialTicks);
        float dayBright = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        dayBright = MathHelper.func_76131_a((float)dayBright, (float)0.0f, (float)1.0f);
        int biomeSky = this.getBlendedBiomeSkyColor(pos, partialTicks);
        float r = (float)(biomeSky >> 16 & 0xFF) / 255.0f;
        float g = (float)(biomeSky >> 8 & 0xFF) / 255.0f;
        float b = (float)(biomeSky & 0xFF) / 255.0f;
        r *= dayBright;
        g *= dayBright;
        b *= dayBright;
        float rain = this.field_76579_a.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float rainLerp = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float rainBright = 1.0f - rain * 0.75f;
            r = r * rainBright + rainLerp * (1.0f - rainBright);
            g = g * rainBright + rainLerp * (1.0f - rainBright);
            b = b * rainBright + rainLerp * (1.0f - rainBright);
        }
        if ((thunder = this.field_76579_a.func_72819_i(partialTicks)) > 0.0f) {
            float thunderLerp = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float thunderBright = 1.0f - thunder * 0.75f;
            r = r * thunderBright + thunderLerp * (1.0f - thunderBright);
            g = g * thunderBright + thunderLerp * (1.0f - thunderBright);
            b = b * thunderBright + thunderLerp * (1.0f - thunderBright);
        }
        if ((lightningFlash = ((ClientWorld)this.field_76579_a).func_228332_n_()) > 0) {
            float lightningFlashF = (float)lightningFlash - partialTicks;
            lightningFlashF = Math.min(lightningFlashF, 1.0f);
            r = r * (1.0f - (lightningFlashF *= 0.45f)) + 0.8f * lightningFlashF;
            g = g * (1.0f - lightningFlashF) + 0.8f * lightningFlashF;
            b = b * (1.0f - lightningFlashF) + 1.0f * lightningFlashF;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    public float getSkyFeatureBrightness(BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        float totalBrightness = 0.0f;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = this.field_76579_a.func_226691_t_(pos.func_177982_a(x, 0, z));
                boolean hasSky = biome instanceof LOTRBiomeBase ? ((LOTRBiomeBase)biome).hasSkyFeatures() : true;
                float skyBr = hasSky ? 1.0f : 0.0f;
                totalBrightness += skyBr;
                ++count;
            }
        }
        return totalBrightness /= (float)count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 192.0f;
    }

    public Vec3d getBlendedCompleteCloudColor(BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        Vec3d clouds = ((ClientWorld)this.field_76579_a).func_228328_h_(partialTicks);
        this.cloudB = 0.0;
        this.cloudG = 0.0;
        this.cloudR = 0.0;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Vec3d tempClouds = new Vec3d(clouds.field_72450_a, clouds.field_72448_b, clouds.field_72449_c);
                Biome biome = this.field_76579_a.func_226691_t_(pos.func_177982_a(x, 0, z));
                if (biome instanceof LOTRBiomeBase) {
                    tempClouds = ((LOTRBiomeBase)biome).alterCloudColor(tempClouds);
                }
                this.cloudR += tempClouds.field_72450_a;
                this.cloudG += tempClouds.field_72448_b;
                this.cloudB += tempClouds.field_72449_c;
                ++count;
            }
        }
        this.cloudR /= (double)count;
        this.cloudG /= (double)count;
        this.cloudB /= (double)count;
        return new Vec3d(this.cloudR, this.cloudG, this.cloudB);
    }

    public float getCloudCoverage(BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        float cloudCoverage = 0.0f;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = this.field_76579_a.func_226691_t_(pos.func_177982_a(x, 0, z));
                float coverageHere = biome instanceof LOTRBiomeBase ? ((LOTRBiomeBase)biome).getCloudCoverage() : 1.0f;
                cloudCoverage += coverageHere;
                ++count;
            }
        }
        return cloudCoverage /= (float)count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int i, int k) {
        Biome biome = this.field_76579_a.func_226691_t_(new BlockPos(i, 0, k));
        if (biome instanceof LOTRBiomeBase) {
            return ((LOTRBiomeBase)biome).isFoggy();
        }
        return false;
    }

    public float[] modifyFogIntensity(float farPlane, FogRenderer.FogType fogType, Entity viewer) {
        int distance = this.getBiomeBlendDistance();
        float fogStart = 0.0f;
        float fogEnd = 0.0f;
        BlockPos viewerPos = viewer.func_180425_c();
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                float thisFogStart = 0.0f;
                float thisFogEnd = 0.0f;
                boolean nearFog = this.func_76568_b(viewerPos.func_177958_n() + x, viewerPos.func_177952_p() + z);
                if (nearFog) {
                    thisFogStart = farPlane * 0.05f;
                    thisFogEnd = Math.min(farPlane, 192.0f) * 0.5f;
                } else if (fogType == FogRenderer.FogType.FOG_SKY) {
                    thisFogStart = 0.0f;
                    thisFogEnd = farPlane;
                } else {
                    thisFogStart = farPlane * 0.75f;
                    thisFogEnd = farPlane;
                }
                fogStart += thisFogStart;
                fogEnd += thisFogEnd;
                ++count;
            }
        }
        return new float[]{fogStart /= (float)count, fogEnd /= (float)count};
    }

    private Vec3d getDefaultFogColor(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float r = 0.7529412f;
        float g = 0.84705883f;
        float b = 1.0f;
        return new Vec3d((double)(r *= f * 0.94f + 0.06f), (double)(g *= f * 0.94f + 0.06f), (double)(b *= f * 0.91f + 0.09f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_175622_Z.func_226277_ct_();
        int k = (int)mc.field_175622_Z.func_226281_cx_();
        int distance = this.getBiomeBlendDistance();
        Vec3d fog = this.getDefaultFogColor(celestialAngle, partialTicks);
        this.fogB = 0.0;
        this.fogG = 0.0;
        this.fogR = 0.0;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Vec3d tempFog = new Vec3d(fog.field_72450_a, fog.field_72448_b, fog.field_72449_c);
                Biome biome = this.field_76579_a.func_226691_t_(new BlockPos(i + x, 0, k + z));
                if (biome instanceof LOTRBiomeBase) {
                    tempFog = ((LOTRBiomeBase)biome).alterFogColor(tempFog);
                }
                this.fogR += tempFog.field_72450_a;
                this.fogG += tempFog.field_72448_b;
                this.fogB += tempFog.field_72449_c;
                ++count;
            }
        }
        this.fogR /= (double)count;
        this.fogG /= (double)count;
        this.fogB /= (double)count;
        return new Vec3d(this.fogR, this.fogG, this.fogB);
    }
}

