/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.dim;

import lotr.client.render.DimensionRendererSetup;
import lotr.common.data.LOTRLevelData;
import lotr.common.dim.LOTRDimension;
import lotr.common.init.LOTRDimensions;
import lotr.common.world.biome.provider.MiddleEarthBiomeProvider;
import lotr.common.world.biome.provider.MiddleEarthBiomeProviderSettings;
import lotr.common.world.gen.MiddleEarthGenSettings;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.fml.DistExecutor;

public class MiddleEarthDimension
extends LOTRDimension {
    public MiddleEarthDimension(World world, DimensionType dimType) {
        super(world, dimType, 0.0f);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DimensionRendererSetup(this));
    }

    public ChunkGenerator<?> func_186060_c() {
        WorldType worldtype = this.field_76579_a.func_72912_H().func_76067_t();
        ChunkGeneratorType generatorType = (ChunkGeneratorType)LOTRDimensions.MIDDLE_EARTH_GENERATOR.get();
        MiddleEarthGenSettings genSettings = new MiddleEarthGenSettings();
        genSettings.func_214969_a(Blocks.field_150348_b.func_176223_P());
        genSettings.func_214970_b(Blocks.field_150355_j.func_176223_P());
        MiddleEarthBiomeProviderSettings biomeSettings = new MiddleEarthBiomeProviderSettings(this.field_76579_a.func_72912_H()).setGeneratorSettings(genSettings);
        MiddleEarthBiomeProvider biomeProvider = new MiddleEarthBiomeProvider(biomeSettings);
        return generatorType.create(this.field_76579_a, (BiomeProvider)biomeProvider, (GenerationSettings)genSettings);
    }

    public BlockPos getDefaultPortalCoordinate() {
        return new BlockPos(0, this.field_76579_a.func_217301_I(), 0);
    }

    public BlockPos func_177496_h() {
        return LOTRLevelData.sidedInstance((IWorldReader)this.field_76579_a).getMiddleEarthPortalLocation();
    }

    public BlockPos getSpawnPoint() {
        return this.func_177496_h();
    }

    public void setSpawnPoint(BlockPos pos) {
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        BlockPos spawn = this.func_177496_h();
        spawn = new BlockPos(spawn.func_177958_n(), this.field_76579_a.func_181545_F(), spawn.func_177952_p());
        while (!this.field_76579_a.func_175623_d(spawn.func_177984_a())) {
            spawn = spawn.func_177984_a();
        }
        return spawn;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX >> 4, posZ >> 4), checkValid);
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76567_e() {
        return true;
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return this.func_76567_e() ? IForgeDimension.SleepResult.ALLOW : IForgeDimension.SleepResult.BED_EXPLODES;
    }

    public boolean isDaytime() {
        return this.field_76579_a.func_175657_ab() < 4;
    }

    public void updateWeather(Runnable defaultLogic) {
        defaultLogic.run();
    }
}

