/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.item;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class RingPortalEntity
extends Entity {
    private static final DataParameter<Integer> PORTAL_AGE = EntityDataManager.func_187226_a(RingPortalEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_PORTAL_AGE = 120;
    private float prevPortalRotation;
    private float portalRotation;
    private int clientPortalAge;
    private int clientPrevPortalAge;

    public RingPortalEntity(EntityType<? extends RingPortalEntity> type, World w) {
        super(type, w);
        this.func_184224_h(true);
    }

    public RingPortalEntity(World w) {
        this((EntityType<? extends RingPortalEntity>)((EntityType)LOTREntities.RING_PORTAL.get()), w);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PORTAL_AGE, (Object)0);
    }

    public int getPortalAge() {
        return (Integer)this.field_70180_af.func_187225_a(PORTAL_AGE);
    }

    public void setPortalAge(int i) {
        this.field_70180_af.func_187227_b(PORTAL_AGE, (Object)i);
    }

    public float getPortalScale(float f) {
        return ((float)this.clientPrevPortalAge + (float)(this.clientPortalAge - this.clientPrevPortalAge) * f) / 120.0f;
    }

    public float getPortalRotation(float f) {
        return this.prevPortalRotation + (this.portalRotation - this.prevPortalRotation) * f;
    }

    public float getScriptBrightness(float f) {
        float br = 0.5f + MathHelper.func_76134_b((float)(((float)this.field_70173_aa + f) * 0.01f)) * 0.25f;
        return br;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("PortalAge", this.getPortalAge());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setPortalAge(compound.func_74762_e("PortalAge"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevPortalRotation = this.portalRotation;
        this.portalRotation += 4.0f;
        while (this.portalRotation - this.prevPortalRotation < -180.0f) {
            this.prevPortalRotation -= 360.0f;
        }
        while (this.portalRotation - this.prevPortalRotation >= 180.0f) {
            this.prevPortalRotation += 360.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.field_71093_bK != DimensionType.field_223227_a_ && this.field_71093_bK != LOTRDimensions.middleEarth()) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPortalAge() < 120) {
                this.setPortalAge(this.getPortalAge() + 1);
            }
        } else {
            this.clientPrevPortalAge = this.clientPortalAge;
            this.clientPortalAge = this.getPortalAge();
            if (this.field_70146_Z.nextFloat() < this.getPortalScale(1.0f)) {
                for (int i = 0; i < 1; ++i) {
                    float w = this.func_213311_cf();
                    float h = this.func_213302_cg();
                    double x = this.func_226277_ct_();
                    double y = this.func_226278_cu_() + (double)(h / 2.0f);
                    double z = this.func_226281_cx_();
                    double d = x + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-w), (float)w);
                    double d1 = y + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-h * 0.5f), (float)(h * 0.5f));
                    double d2 = z + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-w), (float)w);
                    double d3 = (x - d) / 8.0;
                    double d4 = (y - d1) / 8.0;
                    double d5 = (z - d2) / 8.0;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    double d7 = 1.0 - d6;
                    double d8 = 0.0;
                    double d9 = 0.0;
                    double d10 = 0.0;
                    if (d7 > 0.0) {
                        d7 *= d7;
                        d8 += d3 / d6 * d7 * 0.2;
                        d9 += d4 / d6 * d7 * 0.2;
                        d10 += d5 / d6 * d7 * 0.2;
                    }
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d, d1, d2, d8, d9, d10);
                }
            }
        }
        if (this.getPortalAge() >= 120) {
            double searchRange = 8.0;
            List entities = this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ().func_72321_a(searchRange, searchRange, searchRange));
            for (Entity e : entities) {
                if (e == this || e instanceof RingPortalEntity || !this.func_174813_aQ().func_72326_a(e.func_174813_aQ()) || !(e instanceof PlayerEntity) && e.field_71088_bW != 0) continue;
                LOTRMod.proxy.setInRingPortal(e);
            }
            if (this.field_70146_Z.nextInt(50) == 0) {
                this.func_184185_a(SoundEvents.field_187810_eg, 0.5f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    protected void func_213284_aV() {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_85031_j(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entity)), 0.0f);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            if (!this.field_70170_p.field_72995_K) {
                SoundType sound = SoundType.field_185853_f;
                this.func_184185_a(sound.func_185845_c(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)16);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 16) {
            ItemStack breakingItem = new ItemStack((IItemProvider)LOTRItems.GOLD_RING.get());
            for (int l = 0; l < 16; ++l) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, breakingItem), this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)LOTRItems.GOLD_RING.get());
    }
}

