/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.projectile;

import java.util.Random;
import lotr.common.block.PlateBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrownPlateEntity
extends ProjectileItemEntity {
    private static final DataParameter<Boolean> THROWN_RETROGRADE = EntityDataManager.func_187226_a(ThrownPlateEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int plateSpin;
    private int prevPlateSpin;

    public ThrownPlateEntity(EntityType<? extends ThrownPlateEntity> type, World w) {
        super(type, w);
    }

    public ThrownPlateEntity(World w, ItemStack stack, LivingEntity e) {
        super((EntityType)LOTREntities.THROWN_PLATE.get(), e, w);
        this.func_213884_b(stack);
    }

    public ThrownPlateEntity(World w, ItemStack stack, double x, double y, double z) {
        super((EntityType)LOTREntities.THROWN_PLATE.get(), x, y, z, w);
        this.func_213884_b(stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(THROWN_RETROGRADE, (Object)false);
    }

    public boolean getThrownRetrograde() {
        return (Boolean)this.field_70180_af.func_187225_a(THROWN_RETROGRADE);
    }

    public void setThrownRetrograde(boolean flag) {
        this.field_70180_af.func_187227_b(THROWN_RETROGRADE, (Object)flag);
    }

    protected Item func_213885_i() {
        return (Item)LOTRItems.FINE_PLATE.get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState getPlateBlockState() {
        Block block;
        ItemStack plateItem = this.func_213882_k();
        if (!plateItem.func_190926_b() && (block = Block.func_149634_a((Item)plateItem.func_77973_b())) instanceof PlateBlock) {
            return block.func_176223_P();
        }
        return ((Block)LOTRBlocks.FINE_PLATE.get()).func_176223_P();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevPlateSpin = this.plateSpin++;
        double velX = this.func_213322_ci().func_82615_a();
        double velY = this.func_213322_ci().func_82617_b();
        double velZ = this.func_213322_ci().func_82616_c();
        float xzSpeed = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
        if (xzSpeed > 0.1f && velY < 0.0 && this.func_70090_H()) {
            float factor = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)0.8f);
            float addY = factor * 0.75f;
            this.func_213293_j(velX *= (double)factor, velY += (double)addY, velZ *= (double)factor);
        }
    }

    public float getPlateSpin(float f) {
        float spinLerp = (float)this.prevPlateSpin + (float)(this.plateSpin - this.prevPlateSpin) * f;
        int spinTicks = 12;
        float deg = spinLerp % (float)spinTicks / (float)spinTicks * 360.0f;
        if (!this.getThrownRetrograde()) {
            deg *= -1.0f;
        }
        return deg;
    }

    protected void func_70184_a(RayTraceResult target) {
        if (target.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity hitEntity = ((EntityRayTraceResult)target).func_216348_a();
            if (hitEntity == this.func_85052_h()) {
                return;
            }
            hitEntity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 1.0f);
        } else if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
            if (!this.field_70170_p.field_72995_K && this.breakGlass(pos)) {
                BlockPos.Mutable movingPos = new BlockPos.Mutable();
                int range = 2;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            if (this.field_70146_Z.nextInt(4) == 0) continue;
                            movingPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                            this.breakGlass((BlockPos)movingPos);
                        }
                    }
                }
            }
        }
        BlockState plateState = this.getPlateBlockState();
        for (int i = 0; i < 8; ++i) {
            float range = 0.25f;
            double x = this.func_226277_ct_() + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-range), (float)range);
            double y = this.func_226278_cu_() + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-range), (float)range);
            double z = this.func_226281_cx_() + (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)(-range), (float)range);
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, plateState), x, y, z, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(plateState.func_215695_r().func_185845_c(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70106_y();
        }
    }

    private boolean breakGlass(BlockPos pos) {
        boolean bannerProtection;
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151592_s && !(bannerProtection = false)) {
            this.field_70170_p.func_217378_a(null, 2001, pos, Block.func_196246_j((BlockState)state));
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        return false;
    }

    protected float func_70185_h() {
        return 0.02f;
    }
}

